/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.flow.masterslaveflow;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.pgQueryDTO;
import com.jxdinfo.hussar.formdesign.pg.function.visitor.constant.PgConstUtil;
import com.jxdinfo.hussar.formdesign.pg.function.visitor.masterslave.util.PgMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.formdesign.pg.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLFLOW_MASTER_SLAVEDataImport")
public class PgMsFlowDataImportVisitor
implements PgOperationVisitor<PgFlowMsDataModel, PgFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgMsFlowDataImportVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLFLOW_MASTER_SLAVEDataImport";

    @Override
    public void visit(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, PgDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        PgFlowMsDataModelDTO flowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, flowMsDataModelDTO);
        PgFlowMsDataModel flowMsDataModel = backCtx.getUseDataModelBase();
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        for (PgDataModelBase pgDataModelBase : flowMsDataModel.getSlaveTables()) {
            PgDataModelBaseDTO pgDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(pgDataModelBase.getId());
            String slaveModelName = pgDataModelBase.getName();
            for (PgDataModelFieldDto pgDataModelFieldDto : pgDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(pgDataModelFieldDto.getFill())) continue;
                relationTagKeys.put(slaveModelName, pgDataModelFieldDto.getCapitalName());
            }
        }
        if (HussarUtils.isNotEmpty(relationTagKeys)) {
            controllerParams.put("relationTagKeys", relationTagKeys);
        }
        HashMap<String, Boolean> slaveTablePlusSave = new HashMap<String, Boolean>();
        for (PgRelationshipDTO relationshipDTO : flowMsDataModelDTO.getRelationshipDtoList()) {
            if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
            slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
        }
        for (PgDataModelBase modelBase : flowMsDataModel.getSlaveTables()) {
            isLogicallyDelete.put(modelBase.getId(), ((PgBaseDataModel)modelBase).getLogicallyDelete());
            PgDataModelBaseDTO pgDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
            String slaveModelName = modelBase.getName();
            capitalNameList.put(slaveModelName, PgMasterSlaveUtil.getCapitalName(slaveModelName));
            for (PgDataModelField pgDataModelField : modelBase.getFields()) {
                if (!"delDefFlag".equals(pgDataModelField.getUsage())) continue;
                logicallyDelField.put(slaveModelName, pgDataModelField.getName());
            }
            for (PgDataModelFieldDto pgDataModelFieldDto : pgDataModelBaseDTO.getFields()) {
                if ("primary".equals(pgDataModelFieldDto.getFill())) {
                    primaryKeys.put(slaveModelName, pgDataModelFieldDto.getCapitalName());
                }
                if (!"foreign".equals(pgDataModelFieldDto.getFill())) continue;
                foreignKeys.put(slaveModelName, pgDataModelFieldDto.getCapitalName());
            }
        }
        this.addFormPlusSaveDto(flowMsDataModel, flowMsDataModelDTO, backCtx, slaveTablePlusSave);
        controllerParams.put("table", flowMsDataModelDTO);
        controllerParams.put("returnValue", flowMsDataModelDTO.getEntityName());
        PgDataModelBaseDTO pgDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(flowMsDataModel.getMasterTable().getId());
        controllerParams.put("masterTable", pgDataModelBaseDTO);
        String controllerPath = "template/pg/flowbackcode/masterslaveflowbackcode/templateImport/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, flowMsDataModelDTO.getServiceName());
        String servicePath = "template/pg/flowbackcode/masterslaveflowbackcode/templateImport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        this.masterSlaveCode(backCtx, controllerParams);
        PgDataModelFieldDto keyField = flowMsDataModelDTO.getKeyField();
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        String string = "template/pg/flowbackcode/masterslaveflowbackcode/templateImport/service_impl.ftl";
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        controllerParams.put("primaryKeys", primaryKeys);
        controllerParams.put("foreignKeys", foreignKeys);
        controllerParams.put("slaveTable", PgMasterSlaveUtil.ofSlaveParam(flowMsDataModel, flowMsDataModelDTO));
        controllerParams.put("isLogicallyDelete", isLogicallyDelete);
        controllerParams.put("logicallyDelField", logicallyDelField);
        controllerParams.put("capitalNameList", capitalNameList);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)string, controllerParams));
        this.renderImport(backCtx, modelId, flowMsDataModelDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", flowMsDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6a21\u677f\u6253\u5370");
        backCtx.addApi(modelId, PgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, String modelId, PgFlowMsDataModelDTO flowMsDataModelDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, flowMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, flowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.template.print.utils.VerifyExcelUtil");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.model.SysExcelTask");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.constants.TaskConstants");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.service.ISysExcelTaskService");
        backCtx.addServiceImplImport(modelId, "java.time.LocalDateTime");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplInversion(modelId, "ISysExcelTaskService");
        backCtx.addServiceImplInversion(modelId, "HussarThreadPoolConfiguration");
        backCtx.addServiceImplImport(modelId, "java.io.IOException");
        backCtx.addServiceImplImport(modelId, "java.io.InputStream");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.SecurityUser");
        backCtx.addServiceImplImport(modelId, "java.util.concurrent.Executor");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration");
    }

    private Map<String, Object> initParams(PgDataModelOperation dataModelOperation, PgMsDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6a21\u677f\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void masterSlaveCode(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        PgFlowMsDataModel flowMsDataModel = backCtx.getUseDataModelBase();
        String modelId = flowMsDataModel.getId();
        PgFlowMsDataModelDTO flowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<PgRelationshipDTO> relationshipDtoList = flowMsDataModelDTO.getRelationshipDtoList();
        PgDataModelBase masterTable = flowMsDataModel.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, PgDataModelBaseDTO> dataModelDtoMap = flowMsDataModelDTO.getDataModelDtoMap();
        PgDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(backCtx, mainDataModelDto, flowMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)flowMsDataModel) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (PgRelationshipDTO pgRelationshipDTO : relationshipDtoList) {
                List<PgRelationshipFieldDTO> pgRelationshipFieldDTOS;
                String slaveTableId = pgRelationshipDTO.getSlaveTableId();
                String relateModelType = pgRelationshipDTO.getRelateModelType();
                PgDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(backCtx, slaveModelDto, flowMsDataModelDTO, false, mainDataModelDto);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                controllerParams.put("slaveFillCodeList", slaveFillCodeList);
                if (slaveFillCode != null) {
                    pgRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(pgRelationshipFieldDTOS = pgRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private String renderFillCode(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, PgDataModelBaseDTO dataModelBaseDTO, PgFlowMsDataModelDTO msDataModelDTO, boolean isMs, PgDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (PgDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", PgConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", PgConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", PgConstUtil.TRUE);
                    break;
                }
                case "primary": {
                    insertFill = true;
                    params.put("insertFill", PgConstUtil.TRUE);
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.support.engine.core.util.EngineUtil");
                    params.put("primaryFill", PgConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/pg/masterslavebackcode/templateImport/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private void addFormPlusSaveDto(PgFlowMsDataModel flowMsDataModel, PgFlowMsDataModelDTO flowMsDataModelDTO, PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, Map<String, Boolean> slaveTablePlusSave) {
        pgQueryDTO queryDTO = new pgQueryDTO();
        String modelId = flowMsDataModel.getId();
        String masterId = flowMsDataModel.getMasterTable().getId();
        queryDTO.setFtlPath("template/pg/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", flowMsDataModelDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", PgMasterSlaveUtil.ofSlaveParam(flowMsDataModel, flowMsDataModelDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("queryDto", queryDTO);
        params.put("table", flowMsDataModelDTO);
        queryDTO.setParams(params);
        queryDTO.setName(flowMsDataModelDTO.getName() + "IncrementDTO");
        queryDTO.setEntityName(flowMsDataModelDTO.getEntityName() + "IncrementDTO");
        queryDTO.setPackageInfo(flowMsDataModelDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(flowMsDataModelDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importDTOPath = flowMsDataModelDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        flowMsDataModelDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }
}

