/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.enclosure;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.function.PgEnclosure;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.translate.PgTranslate;
import com.jxdinfo.hussar.formdesign.pg.util.PgPublicEnclosure;
import com.jxdinfo.hussar.formdesign.pg.util.PgTemplateUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgTranslateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLFLOWENCLOSURE")
public class PgFlowEnclosure
implements PgEnclosure<PgFlowDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(PgFlowEnclosure.class);
    public static final String ENCLOSURE = "POSTGRE_SQLFLOWENCLOSURE";

    @Override
    public PgDataModelBaseDTO enclosure(PgFlowDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        List<PgDataModelField> dataModelFieldBases;
        PgFlowDataModelDTO dataModelBaseDTO = new PgFlowDataModelDTO();
        dataModelBaseDTO.setUseMybatisPlus(true);
        PgPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        if (dataModelBase.getSourceDataModelName() != null) {
            dataModelBaseDTO.setSourceDataModelName(dataModelBase.getSourceDataModelName());
        }
        if (ToolUtil.isEmpty(dataModelFieldBases = dataModelBase.getFlowFields())) {
            logger.error("enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new PgFlowDataModelDTO();
        }
        ArrayList<PgDataModelFieldDto> tableFields = new ArrayList<PgDataModelFieldDto>();
        for (PgDataModelField dataModelFieldBase : dataModelFieldBases) {
            PgDataModelFieldDto tableField = new PgDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        List<PgTranslate> translates = dataModelBase.getTranslate();
        if (ToolUtil.isNotEmpty(translates)) {
            List rightFields = ModelProvideAdapter.adaptor((String)dataModelBase.getId()).getFields(dataModelBase.getId());
            List<Map<String, Object>> translateAnnotations = PgTranslateUtil.translate(translates, rightFields);
            if (ToolUtil.isNotEmpty(translateAnnotations)) {
                List<PgDataModelFieldDto> fields = dataModelBaseDTO.getFields();
                block1: for (Map map : translateAnnotations) {
                    if (!ToolUtil.isNotEmpty((Object)map) || !ToolUtil.isNotEmpty(map.get("fieldId"))) continue;
                    for (PgDataModelFieldDto field : fields) {
                        if (!field.getId().equals(map.get("fieldId").toString())) continue;
                        field.setFieldAnnotation(map.get("fieldAnnotation").toString());
                        continue block1;
                    }
                }
                dataModelBaseDTO.setFields(fields);
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.anno.Trans");
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.constant.TransType");
            }
            List<PgDataModelFieldDto> translateShowFields = PgTranslateUtil.getTranslateShowFields(translates);
            for (PgDataModelFieldDto pgDataModelFieldDto : translateShowFields) {
                if (null == pgDataModelFieldDto.getColumnType() || null == pgDataModelFieldDto.getColumnType().getImportT()) continue;
                dataModelBaseDTO.addEntityImport(pgDataModelFieldDto.getColumnType().getImportT());
            }
            dataModelBaseDTO.setTranslateShowFields(translateShowFields);
        }
        PublishTemplateDto publishTemplateDto = PgTemplateUtil.processTemplate(dataModelBase.getId(), null);
        dataModelBaseDTO.setPublishTemplateDto(publishTemplateDto);
        return dataModelBaseDTO;
    }
}

