/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.task.basetask;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.visitor.task.basetask.PgTaskAsyncVerifyVisitor;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLTASKUniqueVerify")
public class PgTaskUniqueVerifyVisitor
implements PgOperationVisitor<PgTaskDataModel, PgTaskDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgTaskAsyncVerifyVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLTASKUniqueVerify";

    @Override
    public void visit(PgBackCtx<PgTaskDataModel, PgTaskDataModelDTO> taskBackCtx, PgDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        PgFlowDataModelDTO dataModelBaseDTO = (PgFlowDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        PgFlowDataModel pgBaseDataModel = (PgFlowDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        PgBackCtx<PgFlowDataModel, PgFlowDataModelDTO> backCtx = new PgBackCtx<PgFlowDataModel, PgFlowDataModelDTO>();
        backCtx.setUseDataModelBase(pgBaseDataModel);
        HashMap<String, PgFlowDataModelDTO> map = new HashMap<String, PgFlowDataModelDTO>();
        map.put(modelId, dataModelBaseDTO);
        backCtx.setUseDataModelDtoMap(map);
        HashMap<String, Object> controllerParams = new HashMap<String, Object>();
        controllerParams.put("getPrimaryMethod", String.format("%s%s", "get", dataModelBaseDTO.getPrimaryKeyFirstToUpper()));
        controllerParams.put("name", dataModelOperation.getName());
        if (ToolUtil.isNotEmpty((Object)dataModelOperation.getExegesis())) {
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        } else {
            controllerParams.put("exegesis", dataModelBaseDTO.getComment() + "\u552f\u4e00\u6027\u6821\u9a8c");
        }
        controllerParams.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        controllerParams.put("entityName", dataModelBaseDTO.getEntityName());
        controllerParams.put("mapperEnName", dataModelBaseDTO.getMapperEnName());
        controllerParams.put("table", dataModelBaseDTO);
        String controllerPath = "template/pg/backcode/uniqueverify/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/pg/backcode/uniqueverify/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/pg/backcode/uniqueverify/service_impl.ftl";
        List<PgDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        boolean isLogicallyDelete = pgBaseDataModel.getLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (isLogicallyDelete) {
            PgDataModelField logicallyField = pgBaseDataModel.getDeleteFlag();
            for (PgDataModelFieldDto field : fields) {
                if (!field.getId().equals(logicallyField.getId())) continue;
                controllerParams.put("logicallyFlag", field.getCapitalName());
                break;
            }
        }
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u552f\u4e00\u6027\u6821\u9a8c");
        backCtx.addApi(modelId, PgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(PgBackCtx<PgFlowDataModel, PgFlowDataModelDTO> backCtx, String modelId, PgBaseDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
    }
}

