/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.task.masterslavetask;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipBase;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLTASK_MASTER_SLAVEAsyncVerify")
public class PgMsTaskAsyncVerifyVisitor
implements PgOperationVisitor<PgTaskMsDataModel, PgTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgMsTaskAsyncVerifyVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLTASK_MASTER_SLAVEAsyncVerify";

    @Override
    public void visit(PgBackCtx<PgTaskMsDataModel, PgTaskMsDataModelDTO> taskBackCtx, PgDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        PgMsDataModel useDataModelBase = taskBackCtx.getUseDataModelBase();
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        PgFlowMsDataModelDTO pgMsDataModelDTO = (PgFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        PgFlowMsDataModel dataModelBase = (PgFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx = new PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO>();
        backCtx.setUseDataModelBase(dataModelBase);
        HashMap<String, PgFlowMsDataModelDTO> map = new HashMap<String, PgFlowMsDataModelDTO>();
        map.put(modelId, pgMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        HashMap<String, Object> controllerParams = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        controllerParams.put("name", dataModelOperation.getName());
        if (ToolUtil.isNotEmpty((Object)dataModelOperation.getExegesis())) {
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        } else {
            controllerParams.put("exegesis", pgMsDataModelDTO.getComment() + "\u5f02\u6b65\u6821\u9a8c");
        }
        for (PgDataModelFieldDto field : pgMsDataModelDTO.getFields()) {
            if (!"primary".equals(field.getFill())) continue;
            String dataType = field.getColumnType().getType();
            controllerParams.put("primaryKeyType", dataType);
            break;
        }
        controllerParams.put("serviceEnName", pgMsDataModelDTO.getServiceEnName());
        controllerParams.put("table", table);
        controllerParams.put("dataModelBaseDTO", pgMsDataModelDTO);
        String controllerPath = "template/pg/taskbackcode/masterslavetaskbackcode/asyncverify/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, pgMsDataModelDTO.getServiceName());
        String servicePath = "template/pg/taskbackcode/masterslavetaskbackcode/asyncverify/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/pg/taskbackcode/masterslavetaskbackcode/asyncverify/service_impl.ftl";
        ArrayList<JSONObject> columnList = new ArrayList<JSONObject>();
        ArrayList<PgBaseDataModel> allModel = new ArrayList<PgBaseDataModel>();
        String masterTableId = useDataModelBase.getMasterTable().getId();
        allModel.add((PgBaseDataModel)useDataModelBase.getMasterTable());
        List<PgDataModelBase> slaveTables = useDataModelBase.getSlaveTables();
        for (PgRelationshipBase relationship : useDataModelBase.getRelationships()) {
            if (!"association".equals(relationship.getRelateModelType())) continue;
            for (PgDataModelBase slaveTable : slaveTables) {
                if (!slaveTable.getId().equals(relationship.getSlaveTableId())) continue;
                allModel.add((PgBaseDataModel)slaveTable);
            }
        }
        for (PgBaseDataModel pgDataModelBase : allModel) {
            PgDataModelBaseDTO pgDataModelDTO = pgMsDataModelDTO.getDataModelDtoMap().get(pgDataModelBase.getId());
            boolean isMasterTable = pgDataModelBase.getId().equals(masterTableId);
            List<PgDataModelFieldDto> modelDtoFields = pgDataModelDTO.getFields();
            String getPrimaryMethod = "";
            if (isMasterTable) {
                for (PgDataModelFieldDto field : modelDtoFields) {
                    if (!field.isKeyFlag()) continue;
                    getPrimaryMethod = "Boolean".equals(field.getPropertyType()) ? "is" + field.getCapitalName() : "get" + field.getCapitalName();
                    break;
                }
            } else {
                for (PgDataModelFieldDto field : modelDtoFields) {
                    if (!"foreign".equals(field.getFill())) continue;
                    getPrimaryMethod = "Boolean".equals(field.getPropertyType()) ? "is" + field.getCapitalName() : "get" + field.getCapitalName();
                    break;
                }
            }
            boolean logicallyFlag = false;
            PgDataModelField logicallyField = pgDataModelBase.getDeleteFlag();
            if (ToolUtil.isNotEmpty((Object)((Object)logicallyField))) {
                logicallyFlag = true;
            }
            String flagFieldName = "";
            if (logicallyFlag) {
                for (PgDataModelFieldDto field : modelDtoFields) {
                    if (!field.getId().equals(logicallyField.getId())) continue;
                    flagFieldName = field.getCapitalName();
                    break;
                }
            }
            String serviceName = pgDataModelDTO.getServiceEnName();
            List<PgDataModelField> modelTableFields = pgDataModelBase.getFields();
            boolean flag = false;
            for (PgDataModelField modelTableField : modelTableFields) {
                if (!ToolUtil.isNotEmpty((Object)((Object)modelTableField)) || !modelTableField.isChkUnique()) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("columnName", (Object)modelTableField.getName());
                for (PgDataModelFieldDto field : modelDtoFields) {
                    if (!field.getId().equals(modelTableField.getId())) continue;
                    jsonObject.put("javaType", (Object)field.getPropertyType());
                    break;
                }
                ArrayList<JSONObject> rulesList = new ArrayList<JSONObject>();
                if (modelTableField.isChkUnique()) {
                    flag = true;
                    JSONObject obj = new JSONObject();
                    obj.put("type", (Object)"unique");
                    obj.put("sourceFieldName", (Object)modelTableField.getSourceFieldName());
                    obj.put("errorMsg", (Object)(modelTableField.getName() + "\u5217\u552f\u4e00\u503c\u6821\u9a8c\u672a\u901a\u8fc7"));
                    obj.put("entityName", (Object)pgDataModelDTO.getEntityName());
                    obj.put("getPrimaryMethod", (Object)getPrimaryMethod);
                    obj.put("serviceName", (Object)serviceName);
                    obj.put("logicallyDelete", (Object)logicallyFlag);
                    obj.put("logicallyFlag", (Object)flagFieldName);
                    Map<String, Object> params = dataModelOperation.getParams();
                    List asyncVerifyParams = (List)params.get("asyncVerifyParams");
                    if (ToolUtil.isNotEmpty((Object)asyncVerifyParams)) {
                        for (JSONObject asyncVerifyParam : asyncVerifyParams) {
                            if (!ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"columnId")) || !asyncVerifyParam.get((Object)"columnId").equals(modelTableField.getId()) || !ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"rules"))) continue;
                            List paramRules = (List)asyncVerifyParam.get((Object)"rules");
                            for (JSONObject paramRule : paramRules) {
                                if (!ToolUtil.isNotEmpty((Object)paramRule) || !ToolUtil.isNotEmpty((Object)paramRule.get((Object)"ruleType")) || !"unique".equals(paramRule.get((Object)"ruleType"))) continue;
                                obj.put("errorMsg", paramRule.get((Object)"errorMsg"));
                            }
                        }
                    }
                    rulesList.add(obj);
                }
                jsonObject.put("rules", rulesList);
                columnList.add(jsonObject);
            }
            if (!flag) continue;
            backCtx.addServiceImplImport(modelId, pgDataModelDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplImport(modelId, pgDataModelDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplInversion(modelId, pgDataModelDTO.getServiceName());
        }
        controllerParams.put("columnList", columnList);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, pgMsDataModelDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", pgMsDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5f02\u6b65\u6821\u9a8c");
        backCtx.addApi(modelId, PgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, String modelId, PgMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
    }
}

