/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.render;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlTransUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.PrefixUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.PgCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.AspectGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.EntityGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.MapperGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.ServiceImplGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgRender;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.pgQueryDTO;
import com.jxdinfo.hussar.formdesign.pg.function.visitor.task.basetask.util.PgTaskBaseUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataModelUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataSourceUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgModelBeanUtil;
import com.jxdinfo.hussar.formdesign.pg.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLTASK_MASTER_SLAVERENDER")
public class PgTaskMsRender
implements PgRender<PgTaskMsDataModel, PgTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgTaskMsRender.class);
    public static final String RENDER = "POSTGRE_SQLTASK_MASTER_SLAVERENDER";

    @Override
    public List<PgCodeGenerateInfo> renderCode(PgBackCtx<PgTaskMsDataModel, PgTaskMsDataModelDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<PgCodeGenerateInfo> generateInfos = new ArrayList<PgCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        PgTaskMsDataModelDTO pgMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        backCtx.addParam(String.format("publishTemplateDto_%s", modelId), pgMsDataModelDTO.getPublishTemplateDto());
        Map<String, PgDataModelBase> dataModelBaseMap = pgMsDataModelDTO.getDataModelBaseMap();
        Map<String, PgDataModelBaseDTO> dataModelDtoMap = pgMsDataModelDTO.getDataModelDtoMap();
        if (ToolUtil.isNotEmpty(dataModelBaseMap)) {
            for (String string : dataModelBaseMap.keySet()) {
                List<PgCodeGenerateInfo> childGenerators;
                if (!string.equals(backCtx.getUseDataModelBase().getId()) && !string.equals(backCtx.getUseDataModelBase().getTask().getId())) continue;
                PgBackCtx pgBackCtx = new PgBackCtx();
                PgDataModelBase pgDataModelBase = dataModelBaseMap.get(string);
                PgDataModelBaseDTO pgDataModelBaseDTO = dataModelDtoMap.get(string);
                HashMap<String, PgDataModelBaseDTO> map = new HashMap<String, PgDataModelBaseDTO>();
                map.put(string, pgDataModelBaseDTO);
                pgBackCtx.setBaseFile(baseFile);
                pgBackCtx.setUseDataModelBase(pgDataModelBase);
                pgBackCtx.setUseDataModelDtoMap(map);
                pgBackCtx.setModelFunctionTye(pgDataModelBase.getFunctionType());
                if (HussarUtils.equals((Object)string, (Object)modelId)) {
                    PgTaskBaseUtil.transferControllerCode(pgDataModelBaseDTO, pgMsDataModelDTO);
                }
                if (!ToolUtil.isNotEmpty(childGenerators = PgModelBeanUtil.getFunctionModelVisitorBean(pgBackCtx.getUseDataModelBase().getFunctionType()).render().renderCode(pgBackCtx))) continue;
                for (PgCodeGenerateInfo childGenerator : childGenerators) {
                    if ("controller".equals(childGenerator.getFileType()) || "js".equals(childGenerator.getFileType())) continue;
                    generateInfos.add(childGenerator);
                }
            }
        }
        generateInfos.add(this.genEntityCode(pgMsDataModelDTO));
        generateInfos.add(this.genVoCode(pgMsDataModelDTO));
        generateInfos.add(this.genControllerCode(pgMsDataModelDTO));
        generateInfos.add(this.genServiceCode(pgMsDataModelDTO));
        generateInfos.add(this.genServiceImplCode(pgMsDataModelDTO));
        generateInfos.add(this.genMapperCode(pgMsDataModelDTO));
        generateInfos.add(this.genXmlCode(pgMsDataModelDTO));
        generateInfos.add(this.genApiCode(pgMsDataModelDTO, baseFile));
        Map<String, pgQueryDTO> queryDtoMap = pgMsDataModelDTO.getQueryDtoMap();
        if (ToolUtil.isNotEmpty(queryDtoMap)) {
            for (Map.Entry<String, pgQueryDTO> entry : queryDtoMap.entrySet()) {
                pgQueryDTO queryDTO = entry.getValue();
                PgCodeGenerateInfo queryCodeGenerateInfo = this.dynamicModelCode(queryDTO, pgMsDataModelDTO);
                if (null == queryCodeGenerateInfo) continue;
                generateInfos.add(queryCodeGenerateInfo);
            }
        }
        if (ToolUtil.isNotEmpty(pgMsDataModelDTO.getCustomCodeGenerateInfo()) && ToolUtil.isNotEmpty((Object)((Object)pgMsDataModelDTO.getCustomCodeGenerateInfo().get(modelId)))) {
            generateInfos.add(pgMsDataModelDTO.getCustomCodeGenerateInfo().get(modelId));
        }
        Map<String, AspectGenerateInfo> map = pgMsDataModelDTO.getAspectGenerateInfoMap();
        if (ToolUtil.isNotEmpty(pgMsDataModelDTO.getAnnotationNames()) && ToolUtil.isNotEmpty(map)) {
            for (String annotationName : pgMsDataModelDTO.getAnnotationNames()) {
                generateInfos.add(this.genAnnotationCode(pgMsDataModelDTO, annotationName));
                AspectGenerateInfo aspectGenerateInfo = Optional.ofNullable(map.get(map.keySet().stream().filter(key -> HussarUtils.equals((Object)key, (Object)annotationName)).findFirst().orElse(""))).orElseGet(AspectGenerateInfo::new);
                generateInfos.add(this.genAspectCode(pgMsDataModelDTO, annotationName, aspectGenerateInfo));
            }
        }
        return generateInfos;
    }

    private PgCodeGenerateInfo genEntityCode(PgMsDataModelDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "model" + File.separator + dataModelBaseDTO.getEntityName() + ".java";
        String filePath = "template/pg/taskbackcode/mscode/entity.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getEntityName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getEntityGenerateInfo())) {
            EntityGenerateInfo entityGenerateInfo = new EntityGenerateInfo();
            entityGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setEntityGenerateInfo(entityGenerateInfo);
        } else {
            dataModelBaseDTO.getEntityGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            Set imports = Optional.ofNullable(dataModelBaseDTO.getEntityGenerateInfo().getImports()).orElseGet(HashSet::new);
            imports.add("com.baomidou.mybatisplus.annotation.TableField");
            dataModelBaseDTO.getEntityGenerateInfo().setImports(imports);
        }
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("entity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getEntityName() + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genVoCode(PgMsDataModelDTO dto) throws LcdpException {
        String modulePath = dto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "VO".toLowerCase() + File.separator + dto.getVoName() + ".java";
        String filePath = "template/pg/taskbackcode/mscode/vo.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dto.getVoName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dto.getVoGeneratorInfo())) {
            VoGeneratorInfo info = new VoGeneratorInfo();
            info.setQualifyBeanName(qualifyBeanName);
            dto.setVoGeneratorInfo(info);
        } else {
            dto.getVoGeneratorInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("vo");
        codeGenerateInfo.setFileId(dto.getId());
        codeGenerateInfo.setFileName(dto.getVoName() + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genControllerCode(PgMsDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Controller".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Controller" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getControllerName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getControllerGenerateInfo())) {
            ControllerGenerateInfo controllerGenerateInfo = new ControllerGenerateInfo();
            controllerGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setControllerGenerateInfo(controllerGenerateInfo);
        } else {
            dataModelDto.getControllerGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getControllerGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(dataModelDto.getImportInfo().get("Entity"));
        imports.add(dataModelDto.getImportInfo().get("Service"));
        dataModelDto.getControllerGenerateInfo().setImports(imports);
        String filePath = "template/pg/taskbackcode/mscode/controller.ftl";
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(PrefixUtil.replacePrefix((String)newCode));
        codeGenerateInfo.setFileType("controller");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getControllerName() + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genServiceCode(PgMsDataModelDTO dataModelDto) throws LcdpException, IOException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Service" + ".java";
        String filePath = "template/pg/taskbackcode/mscode/service.ftl";
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("service");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Service" + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genServiceImplCode(PgMsDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl" + File.separator + dataModelDto.getEntityName() + "ServiceImpl" + ".java";
        String filePath = "template/pg/taskbackcode/mscode/service_impl.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getServiceImplGenerateInfo())) {
            ServiceImplGenerateInfo serviceImplGenerateInfo = new ServiceImplGenerateInfo();
            serviceImplGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setServiceImplGenerateInfo(serviceImplGenerateInfo);
        } else {
            dataModelDto.getServiceImplGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getServiceImplGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(PgDataSourceUtil.getDataSourceServiceImpl(dataModelDto.getDataSourceName()));
        imports.add("java.util.List");
        imports.add("java.util.Map");
        imports.add("com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        imports.add("org.springframework.beans.factory.annotation.Autowired");
        dataModelDto.addServiceImplInversion(dataModelDto.getMapperName());
        dataModelDto.getServiceImplGenerateInfo().setImports(imports);
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("serviceImpl");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "ServiceImpl" + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genMapperCode(PgMsDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".java";
        String filePath = "template/pg/taskbackcode/mscode/mapper.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getMapperName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getMapperGenerateInfo())) {
            MapperGenerateInfo mapperGenerateInfo = new MapperGenerateInfo();
            mapperGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setMapperGenerateInfo(mapperGenerateInfo);
        } else {
            dataModelDto.getMapperGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getMapperGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add("org.apache.ibatis.annotations.Param");
        imports.add("java.util.List");
        dataModelDto.getMapperGenerateInfo().setImports(imports);
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("mapper");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genXmlCode(PgMsDataModelDTO dataModelDto) throws LcdpException {
        this.structureTranslateXml(dataModelDto);
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + "mapping" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".xml";
        String filePath = "template/pg/taskbackcode/mscode/xml.ftl";
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("xml");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".xml");
        return codeGenerateInfo;
    }

    private void structureTranslateXml(PgMsDataModelDTO dataModelDto) throws LcdpException {
        JSONObject dataModelBase = DataModelUtil.getDataModelJson((String)dataModelDto.getId());
        PgTaskMsDataModel msModelBase = (PgTaskMsDataModel)PgDataModelUtil.transfer(dataModelBase);
        Map<String, String> modelAliasName = msModelBase.getModelAliasName();
        HashMap<String, CharSequence> xmlParams = new HashMap<String, CharSequence>();
        xmlParams.put("return", SqlReturnUtil.renderReturn(msModelBase, modelAliasName));
        xmlParams.put("relation", SqlReturnUtil.renderRelation(msModelBase, dataModelDto.getDataModelBaseMap()));
        StringBuilder whereResult = new StringBuilder(128);
        whereResult.append("<where>\n");
        String template = "<if test=\"${obj}.${attr} != '' and ${obj}.${attr} != null\">\n${T}.${rAttr} ${symbol} ${objAttr}\n</if>\n";
        String templateNoEmpty = "<if test=\"${obj}.${attr} != null\">\n${T}.${rAttr} ${symbol} ${objAttr}\n</if>\n";
        String objName = msModelBase.getName();
        List<PgDataModelField> fields = msModelBase.getFields();
        for (PgDataModelField field : fields) {
            String dataType = field.getDataType();
            if ("array".equals(dataType)) continue;
            String sourceFieldName = field.getSourceFieldName();
            String name = field.getName();
            String objAttr = "#{" + objName + "." + name + "}";
            String useTemplate = template;
            if (ToolUtil.isNotEmpty((Object)dataType) && ("date".equals(dataType) || "boolean".equals(dataType) || "int".equals(dataType) || "long".equals(dataType))) {
                useTemplate = templateNoEmpty;
            }
            String where = useTemplate.replace("${obj}", objName).replace("${attr}", name).replace("${rAttr}", sourceFieldName).replace("${symbol}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${objAttr}", objAttr).replace("${T}", String.valueOf(modelAliasName.get(field.getSourceDataModelId())));
            whereResult.append(where);
        }
        whereResult.append("</where>\n");
        xmlParams.put("whereSql", whereResult);
        dataModelDto.addXmlCode(RenderUtil.renderTemplate((String)"template/pg/masterslavebackcode/code/translate_xml.ftl", xmlParams));
    }

    private PgCodeGenerateInfo genAnnotationCode(PgMsDataModelDTO dataModelDto, String annotationName) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "annotation" + File.separator + annotationName + ".java";
        String filePath = "template/pg/taskbackcode/mscode/annotation.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("annotation");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(annotationName);
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genApiCode(PgMsDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/pg/preview/api/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genAspectCode(PgMsDataModelDTO dataModelDto, String annotationName, AspectGenerateInfo aspectGenerateInfo) throws LcdpException {
        String aspectName = annotationName + NamingStrategy.capitalFirst((String)"aspect");
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "aspect" + File.separator + aspectName + ".java";
        String filePath = "/template/pg/taskbackcode/mscode/aspect.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("aspectName", aspectName);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        params.put("aspect", aspectGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("aspect");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(aspectName);
        return codeGenerateInfo;
    }

    public static String renderTemplate(String templatePath, ApiGenerateInfo apiGenerateInfo) throws LcdpException {
        HashMap<String, ApiGenerateInfo> params = new HashMap<String, ApiGenerateInfo>();
        params.put("api", apiGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }

    private PgCodeGenerateInfo dynamicModelCode(pgQueryDTO queryDTO, PgDataModelBaseDTO dataModelDto) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryDTO)) {
            String writePath = queryDTO.getWriteFilePath();
            String filePath = queryDTO.getFtlPath();
            String newCode = RenderUtil.renderTemplate((String)filePath, queryDTO.getParams());
            PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(queryDTO.getEntityName());
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private PgCodeGenerateInfo genQueryVoCode(pgQueryDTO queryVODto, PgMsDataModelDTO dataModelDto, String modulePath, PgMsDataModel pgMsDataModel) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryVODto)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("queryDto", queryVODto);
            params.put("model", dataModelDto);
            params.put("modelArrayWithPage", pgMsDataModel.getOperations().get(0).getReturnValue());
            String writePath = modulePath + File.separator + "qo" + File.separator + this.upperCase(pgMsDataModel.getOperations().get(0).getReturnValue()) + ".java";
            String filePath = "template/pg/taskbackcode/mscode/queryVo.ftl";
            String newCode = RenderUtil.renderTemplate((String)filePath, params);
            PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(this.upperCase(pgMsDataModel.getOperations().get(0).getReturnValue()));
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private String upperCase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

