@Override
public ApiResponse<${svo!}<${returnValue!}VO>> ${operationName!}(${returnValue!}IncrementDTO ${returnValue?uncap_first}IncrementDTO) {
    try {
        boolean isPagination = ${returnValue?uncap_first}IncrementDTO.getCurrent() != 0
                                    && HussarUtils.isNotEmpty(${returnValue?uncap_first}IncrementDTO.getCurrent());
        Page<${returnValue!}> pager = new Page<>();
        if (isPagination) {
            pager = new Page<>(${returnValue?uncap_first}IncrementDTO.getCurrent(), ${returnValue?uncap_first}IncrementDTO.getSize());
        }
        <#--        全局排序-->
        Map<String, String[]> parameterMap = new HashMap<>();
        List<String> orderRule = new ArrayList<>();
        if (${returnValue?uncap_first}IncrementDTO.getOrders() != null) {
            StringBuilder order = new StringBuilder();
            for (OrderItem orderItem : ${returnValue?uncap_first}IncrementDTO.getOrders()) {
                if (orderItem.isAsc()) {
                    order.append(orderItem.getColumn()).append(ASC);
                }else {
                    order.append(orderItem.getColumn()).append(DESC);
                }
            }
            orderRule.add(order.toString());
            parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
        }
        // 排序条件构造器,将排序条件封装成QueryWrapper
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper<${returnValue}> queryWrapper = singleTableQueryGenerator.initQueryWrapper(new ${returnValue}(), parameterMap);
        // 查询条件构造器,将查询条件封装成QueryWrapper
        List<SuperQueryConditionDto> superQueryConditionDtoList;
        SuperQueryConditionDto superQueryConditionDto = new SuperQueryConditionDto();
        superQueryConditionDto.setField("${foreignKey}");
        superQueryConditionDto.setMatch("AND");
        superQueryConditionDto.setRule("_eq");
        superQueryConditionDto.setVal(${returnValue?uncap_first}IncrementDTO.getId());
        <#if relationTagKey?? && relationTagValue??>
        SuperQueryConditionDto relationQueryConditionDto = new SuperQueryConditionDto();
        relationQueryConditionDto.setField("${relationTagKey}");
        relationQueryConditionDto.setMatch("AND");
        relationQueryConditionDto.setRule("_eq");
        relationQueryConditionDto.setVal("${relationTagValue}");
        </#if>
        <#if flagDelete??>
            SuperQueryConditionDto delConditionDtoOne = new SuperQueryConditionDto();
            delConditionDtoOne.setField("${flagDelete}");
            delConditionDtoOne.setMatch("AND");
            delConditionDtoOne.setRule("_ne");
            delConditionDtoOne.setVal("1");
            SuperQueryConditionDto delConditionDtoEmpty = new SuperQueryConditionDto();
            delConditionDtoEmpty.setField("${flagDelete}");
            delConditionDtoEmpty.setMatch("OR");
            delConditionDtoEmpty.setRule("_isNull");
        </#if>
        //如果查询条件不为空
        if (HussarUtils.isNotEmpty(${returnValue?uncap_first}IncrementDTO.getSuperQueryConditionDto())) {
            superQueryConditionDtoList = ${returnValue?uncap_first}IncrementDTO.getSuperQueryConditionDto();
        } else {
            superQueryConditionDtoList = new ArrayList<>();
        }
        superQueryConditionDtoList.add(superQueryConditionDto);
        <#if relationTagKey?? && relationTagValue??>
        superQueryConditionDtoList.add(relationQueryConditionDto);
        </#if>
        <#if flagDelete??>
            superQueryConditionDtoList.add(delConditionDtoOne);
        </#if>
        SuperQueryGenerator<${returnValue}> superQueryGenerator = new SuperQueryGenerator<>(${returnValue}.class);
        superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
        //如果分页
        if (isPagination) {
            /* @begin ${operationName!}1 #自定义代码 */
            /* @end ${operationName!}1 */
            List<${returnValue!}VO> list = ${table.mapperEnName!}.${operationName!}(pager, queryWrapper);
            /* @begin ${operationName!}2 #自定义代码 */
            /* @end ${operationName!}2 */
            <#if slaveTable.translateShowFields??>
                TransUtil.trans(list);
            </#if>
            // 构造返回值对象
            return ApiResponse.success(${svo!}.of(list, pager.getTotal()));
        } else {
            /* @begin ${operationName!}3 #自定义代码 */
            /* @end ${operationName!}3 */
            List<${returnValue!}VO> list = ${table.mapperEnName!}.${operationName!}(queryWrapper);
            /* @begin ${operationName!}4 #自定义代码 */
            /* @end ${operationName!}4 */
            <#if slaveTable.translateShowFields??>
                TransUtil.trans(list);
            </#if>
            // 构造返回值对象
            return ApiResponse.success(${svo!}.of(list, (long) list.size()));
        }
    } catch (Exception e) {
        <#if table?? && table.transDisposition?? && table.transDisposition>
        throw new HussarException(TfModelEnum.TF_FORM_QUERY_FAILED.getMessage(), e);
        <#else>
        throw new HussarException("表单查询失败", e);
        </#if>
    }
}