/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.processor;

import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.model.PageInfoNode;
import com.jxdinfo.hussar.formdesign.pg.code.PgCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgModelFunction;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.PgRender;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.result.PgCodeResult;
import com.jxdinfo.hussar.formdesign.pg.util.PgCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataModelUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PgModelProcessor
implements DataModelProcessor<PgCodeResult> {
    private static Logger logger = LoggerFactory.getLogger(PgModelProcessor.class);

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"POSTGRE_SQL", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<PgCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx = this.getPgBackCtx(publishCtx);
        PgModelProcessor.init(backCtx, dataModelBase);
        PgModelProcessor.generateSingleModel(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    private PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> getPgBackCtx(PublishCtx<PgCodeResult> publishCtx) {
        PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx = new PgBackCtx<PgDataModelBase, PgDataModelBaseDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        if (publishCtx.getPublishDTO() != null) {
            backCtx.setPublishDTO(publishCtx.getPublishDTO());
        }
        return backCtx;
    }

    public static void init(PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        String modelId = dataModelBase.getId();
        PgModelFunction currentFunction = PgModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        PgDataModelBase currentModelBase = PgDataModelUtil.transfer(dataModelBase);
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, PgDataModelBaseDTO> useDtoMap = new HashMap<String, PgDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx, PublishCtx<PgCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        PgModelProcessor.visit(backCtx);
        PgModelProcessor.render(backCtx, publishCtx);
    }

    public static void visit(PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        PgDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        PgDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        PageInfoNode pageInfoNode = null;
        if (backCtx.getUseDataModelBase().getIsPublishResource()) {
            pageInfoNode = DataModelUtil.getDataModelNode((String)useDataModelBase.getId());
        }
        for (PgDataModelOperation operation : useDataModelBase.getOperations()) {
            if ("AsyncVerify".equals(operation.getType())) {
                operation.setType("UniqueVerify");
                operation.setName("uniqueVerify");
            }
            PgOperationVisitor<PgDataModelBase, PgDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().vistor("POSTGRE_SQL", backCtx.getModelFunctionTye(), operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            try {
                backCtx.getModelFunction().accept(visitor, backCtx, operation);
            }
            catch (Exception var) {
                logger.error("\u6a21\u578b\uff1a{}\uff0c\u65b9\u6cd5\uff1a{} \u6e32\u67d3\u5931\u8d25\uff0c\u6e32\u67d3\u8def\u5f84\uff1a{}", new Object[]{useDataModelBase.getComment(), operation.getName(), visitor.getClass().getName()});
                throw new LcdpException(var, String.format("\u6a21\u578b%s\u6e32\u67d3\u5931\u8d25\uff0c\u5f02\u5e38\uff1a%s", useDataModelBase.getComment(), var.getMessage()));
            }
            if (!backCtx.getUseDataModelBase().getIsPublishResource() || !ToolUtil.isNotEmpty((Object)pageInfoNode)) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((PageInfoNode)pageInfoNode, (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
        useDataModelBase.customOption(backCtx);
    }

    public static void render(PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx, PublishCtx<PgCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        PgRender<PgDataModelBase, PgDataModelBaseDTO> render = backCtx.getModelFunction().render();
        List<PgCodeGenerateInfo> codeGenerateInfos = render.renderCode(backCtx);
        publishCtx.addCodeResults(PgCodeMergeUtil.mergeBack(codeGenerateInfos, backCtx));
        if (HussarUtils.isNotEmpty((Object)backCtx.getParams())) {
            backCtx.getParams().keySet().forEach(key -> {
                if (ToolUtil.isEmpty((Object)publishCtx.getParams())) {
                    publishCtx.addParams(new HashMap());
                }
                publishCtx.getParams().putIfAbsent(key, backCtx.getParam((String)key));
            });
        }
    }
}

