/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.enclosure;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.PropertyType;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.pg.function.PgEnclosure;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.ResultMapUtil;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipBase;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.source.SourcePackageInfo;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.source.SourceUseItem;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.translate.PgTranslate;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataModelUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgModelBeanUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgPublicEnclosure;
import com.jxdinfo.hussar.formdesign.pg.util.PgTemplateUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgTranslateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLFLOW_MASTER_SLAVEENCLOSURE")
public class PgFlowMsEnclosure
implements PgEnclosure<PgFlowMsDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(PgFlowMsEnclosure.class);
    public static final String ENCLOSURE = "POSTGRE_SQLFLOW_MASTER_SLAVEENCLOSURE";

    @Override
    public PgDataModelBaseDTO enclosure(PgFlowMsDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        PgFlowMsDataModelDTO dataModelBaseDTO = new PgFlowMsDataModelDTO();
        PgPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        List<PgDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        HashMap<String, PgDataModelBaseDTO> dataModelDtoMap = new HashMap<String, PgDataModelBaseDTO>(slaveTables.size() + 1);
        HashMap<String, PgDataModelBase> dataModelBaseMap = new HashMap<String, PgDataModelBase>(slaveTables.size() + 1);
        PgDataModelBase masterTable = dataModelBase.getMasterTable();
        masterTable.setModelPath(dataModelBase.getModelPath());
        PgDataModelBaseDTO masterDTO = PgModelBeanUtil.getFunctionModelVisitorBean(masterTable.getFunctionType()).enclosure().enclosure(masterTable);
        Map masterPackageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
        masterDTO.setPackageInfo(masterPackageInfo);
        masterDTO.setImportInfo(PgPublicEnclosure.getImportInfo(masterPackageInfo, masterDTO));
        masterDTO.setTablePath(dataModelBaseDTO.getTablePath());
        dataModelDtoMap.put(masterTable.getId(), masterDTO);
        dataModelBaseMap.put(masterTable.getId(), masterTable);
        List<PgTranslate> translates = dataModelBase.getTranslate();
        List<Object> msTranslates = new ArrayList();
        msTranslates = translates;
        ArrayList<String> slaveId = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dataModelBase.getRelationships())) {
            for (PgRelationshipBase relationship : dataModelBase.getRelationships()) {
                if (!"collection".equals(relationship.getRelateModelType())) continue;
                slaveId.add(relationship.getSlaveTableId());
            }
        }
        for (PgDataModelBase slaveTable : slaveTables) {
            slaveTable.setModelPath(dataModelBase.getModelPath());
            PgDataModelBaseDTO slaveDTO = PgModelBeanUtil.getFunctionModelVisitorBean(slaveTable.getFunctionType()).enclosure().enclosure(slaveTable);
            if (slaveId.contains(slaveTable.getId())) {
                List<PgDataModelField> sFields = slaveTable.getFields();
                ArrayList<PgTranslate> slaveTranslates = new ArrayList<PgTranslate>();
                if (ToolUtil.isNotEmpty(translates)) {
                    block2: for (PgDataModelField field : sFields) {
                        for (PgTranslate translate : translates) {
                            if (!translate.getSourceFieldId().equals(field.getId())) continue;
                            slaveTranslates.add(translate);
                            continue block2;
                        }
                    }
                    PgTranslateUtil.translateMsEnclosure(slaveTranslates, dataModelBase, slaveDTO);
                    if (ToolUtil.isNotEmpty(slaveDTO.getTranslateShowFields())) {
                        slaveDTO.setHasTranslate(true);
                        dataModelBaseDTO.setHasTranslate(true);
                    }
                    msTranslates.removeAll(slaveTranslates);
                }
            }
            Map slavePackageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
            slaveDTO.setPackageInfo(slavePackageInfo);
            slaveDTO.setImportInfo(PgPublicEnclosure.getImportInfo(slavePackageInfo, slaveDTO));
            slaveDTO.setTablePath(dataModelBaseDTO.getTablePath());
            dataModelDtoMap.put(slaveTable.getId(), slaveDTO);
            dataModelBaseMap.put(slaveTable.getId(), slaveTable);
        }
        dataModelBaseDTO.setDataModelBaseMap(dataModelBaseMap);
        dataModelBaseDTO.setDataModelDtoMap(dataModelDtoMap);
        dataModelBaseDTO.setResultMapContent(ResultMapUtil.renderResultMap(dataModelBase, dataModelDtoMap, dataModelBaseMap));
        dataModelBaseDTO.setSubSelect(ResultMapUtil.renderSubSelect(dataModelBase, dataModelDtoMap, dataModelBaseMap));
        List<SourcePackageInfo> sourcePackageInfos = this.sourceCodePackage(dataModelBaseDTO, dataModelBase, dataModelDtoMap);
        dataModelBaseDTO.setSourcePackageInfos(sourcePackageInfos);
        this.sourceCodeRelationship(dataModelBaseDTO, dataModelBase);
        List<PgDataModelField> dataModelFieldBases = dataModelBase.getFlowFields();
        if (ToolUtil.isEmpty(dataModelFieldBases)) {
            logger.error("enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new PgFlowMsDataModelDTO();
        }
        ArrayList<PgDataModelFieldDto> tableFields = new ArrayList<PgDataModelFieldDto>();
        for (PgDataModelField dataModelFieldBase : dataModelFieldBases) {
            PgDataModelFieldDto tableField = new PgDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        PgTranslateUtil.translateMsEnclosure(msTranslates, dataModelBase, dataModelBaseDTO);
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            dataModelBaseDTO.setHasTranslate(true);
        }
        PublishTemplateDto publishTemplateDto = PgTemplateUtil.processTemplate(dataModelBase.getId(), slaveTables);
        dataModelBaseDTO.setPublishTemplateDto(publishTemplateDto);
        return dataModelBaseDTO;
    }

    private void sourceCodeRelationship(PgFlowMsDataModelDTO dataModelDto, PgFlowMsDataModel dataModelBase) throws LcdpException {
        ArrayList<PgRelationshipDTO> relationshipDtoList = new ArrayList<PgRelationshipDTO>();
        List<PgDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        block0: for (PgRelationshipBase relationship : dataModelBase.getRelationships()) {
            PgRelationshipDTO relationshipDto = new PgRelationshipDTO();
            BeanUtils.copyProperties((Object)relationship, (Object)relationshipDto);
            PgDataModelBaseDTO masterModelDto = dataModelDto.getTableInfo(relationship.getMasterTableId());
            PgDataModelBase masterModel = dataModelBase.getMasterTable();
            PgDataModelBaseDTO slaveTableDto = dataModelDto.getTableInfo(relationship.getSlaveTableId());
            relationshipDto.setSlaveTableDto(slaveTableDto);
            PgDataModelBase slaveTable = slaveTables.stream().filter(e -> e.getId().equals(relationship.getSlaveTableId())).findFirst().orElse(null);
            if (slaveTable == null) continue;
            relationshipDto.setSlaveTableName(slaveTableDto.getEntityName());
            relationshipDto.setSlaveTableServiceName(slaveTableDto.getServiceEnName());
            ArrayList<PgRelationshipFieldDTO> relationshipFieldDtoList = new ArrayList<PgRelationshipFieldDTO>();
            for (PgRelationshipFieldBase relationshipField : relationship.getRelationships()) {
                PgDataModelField slaveTableField;
                PgRelationshipFieldDTO relationshipFieldDto = new PgRelationshipFieldDTO();
                BeanUtils.copyProperties((Object)relationshipField, (Object)relationshipFieldDto);
                String masterTableFieldId = relationshipField.getMasterTableFieldId();
                String slaveTableFieldId = relationshipField.getSlaveTableFieldId();
                PgDataModelField masterTableField = null;
                if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{masterTableFieldId})) {
                    masterTableField = masterModel.getFields().stream().filter(e -> e.getId().equals(masterTableFieldId)).findFirst().orElse(null);
                }
                if ((slaveTableField = (PgDataModelField)slaveTable.getFields().stream().filter(e -> e.getId().equals(slaveTableFieldId)).findFirst().orElse(null)) == null) continue block0;
                if (masterTableField != null) {
                    relationshipFieldDto.setMasterFieldCap(masterModelDto.getFieldCapitalName(masterTableField.getName()));
                }
                relationshipFieldDto.setSlaveFieldCap(slaveTableDto.getFieldCapitalName(slaveTableField.getName()));
                relationshipFieldDtoList.add(relationshipFieldDto);
            }
            relationshipDto.setRelationshipDtoList(relationshipFieldDtoList);
            if ("collection".equals(relationshipDto.getRelateModelType())) {
                PgDataModelField field = dataModelBase.getFields().stream().filter(fieldBase -> fieldBase.getSourceDataModelId().equals(relationship.getSlaveTableId())).findFirst().orElseThrow(() -> new LcdpException(LcdpExceptionEnum.ERROR, "\u672a\u627e\u5230\u5b50\u8868\u5bf9\u5e94\u4e3b\u5b50\u8868\u4e2d\u7684\u5217"));
                relationshipDto.setSlaveTableAlias(field.getName());
            }
            relationshipDtoList.add(relationshipDto);
        }
        dataModelDto.setRelationshipDtoList(relationshipDtoList);
    }

    private List<SourcePackageInfo> sourceCodePackage(PgFlowMsDataModelDTO dataModelDto, PgFlowMsDataModel dataModelBase, Map<String, PgDataModelBaseDTO> tableInfoMap) {
        List<PgDataModelField> dataModelFieldBases = dataModelBase.getFields();
        HashMap<String, SourcePackageInfo> sourcePackageInfoMap = new HashMap<String, SourcePackageInfo>();
        VoGeneratorInfo voGeneratorInfo = dataModelDto.getVoGeneratorInfo();
        voGeneratorInfo.addImport(Serializable.class.getCanonicalName());
        for (PgDataModelField dataModelFieldBase : dataModelFieldBases) {
            PropertyType propertyType;
            PgDataModelBaseDTO sourceDataModelDto;
            String sourceModelId = dataModelFieldBase.getSourceDataModelId();
            if (!ToolUtil.isNotEmpty((Object)sourceModelId) || !ToolUtil.isNotEmpty((Object)(sourceDataModelDto = tableInfoMap.get(sourceModelId)))) continue;
            if (DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType())) {
                if (ToolUtil.isEmpty(sourcePackageInfoMap.get(sourceModelId))) {
                    SourcePackageInfo sourcePackageInfo = new SourcePackageInfo();
                    sourcePackageInfo.setDataType("object");
                    sourcePackageInfo.setObjectName(sourceDataModelDto.getEntityName());
                    sourcePackageInfo.setObjectEnName(sourceDataModelDto.getEName());
                    String entityImport = sourceDataModelDto.getImportInfo().get("Entity");
                    sourcePackageInfoMap.put(sourceModelId, sourcePackageInfo);
                    dataModelDto.addEntityImport(entityImport);
                }
                SourceUseItem sourceUseItem = new SourceUseItem();
                sourceUseItem.setCurrAttr(dataModelFieldBase.getName());
                PgDataModelFieldDto sourceField = sourceDataModelDto.getCertainField(dataModelFieldBase.getSourceFieldName());
                sourceUseItem.setSourceAttrCapitalName(sourceField.getCapitalName());
                ((SourcePackageInfo)sourcePackageInfoMap.get(sourceModelId)).addSourceItem(sourceUseItem);
                continue;
            }
            List<PgDataModelFieldDto> dataModelFieldDtoList = dataModelDto.getFields();
            List<PgDataModelFieldDto> voFields = voGeneratorInfo.getFields();
            for (PgDataModelFieldDto dataModelFieldDto : dataModelFieldDtoList) {
                if (!dataModelFieldDto.getPropertyName().equals(dataModelFieldBase.getName()) || !ToolUtil.isNotEmpty((Object)(propertyType = PgDataModelUtil.getEntityPropertyType(dataModelFieldBase.getDataType(), sourceDataModelDto)))) continue;
                dataModelFieldDto.setColumnType(propertyType);
                dataModelDto.addEntityImport(sourceDataModelDto.getImportInfo().get("Entity"));
                dataModelDto.addVoImport(sourceDataModelDto.getImportInfo().get("VO"));
            }
            for (PgDataModelFieldDto voField : voFields) {
                if (!voField.getPropertyName().equals(dataModelFieldBase.getName()) || !ToolUtil.isNotEmpty((Object)(propertyType = PgFlowMsEnclosure.getVoPropertyType(dataModelFieldBase.getDataType(), sourceDataModelDto)))) continue;
                voField.setColumnType(propertyType);
                voGeneratorInfo.addImport(sourceDataModelDto.getImportInfo().get("VO"));
            }
            if (!"array".equals(dataModelFieldBase.getDataType())) continue;
            SourcePackageInfo sourcePackageInfo = new SourcePackageInfo();
            sourcePackageInfo.setDataType("array");
            sourcePackageInfo.setObjectName(sourceDataModelDto.getEntityName());
            sourcePackageInfo.setObjectEnName(sourceDataModelDto.getEName());
            sourcePackageInfo.setQuoteAttr(dataModelFieldBase.getName());
            String entityImport = sourceDataModelDto.getImportInfo().get("Entity");
            sourcePackageInfoMap.put(sourceModelId, sourcePackageInfo);
            dataModelDto.addEntityImport(entityImport);
            dataModelDto.addEntityImport("java.util.List");
            voGeneratorInfo.addImport(sourceDataModelDto.getImportInfo().get("VO"));
            voGeneratorInfo.addImport("java.util.List");
        }
        return new ArrayList<SourcePackageInfo>(sourcePackageInfoMap.values());
    }

    private static PropertyType getVoPropertyType(String type, PgDataModelBaseDTO dataModelDto) {
        PropertyType propertyType = null;
        if (ToolUtil.isNotEmpty((Object)type)) {
            propertyType = new PropertyType();
            propertyType.setImportT(dataModelDto.getImportInfo().get("VO"));
            String modelName = dataModelDto.getVoName();
            if (type.equals("array")) {
                propertyType.setType("List<${model}>".replace("${model}", modelName));
            } else if (type.equals("object")) {
                propertyType.setType(modelName);
            }
        }
        return propertyType;
    }
}

