/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.element.base;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PgBaseConnector {
    public static TableInfoDto tableInfoInEdit(SysDataSource sysDataSource, PgDataModelBase dataModel) {
        TableInfoDto tableDto = new TableInfoDto();
        tableDto.setTableName(dataModel.getSourceDataModelName());
        tableDto.setPollName(dataModel.getDataSourceName());
        tableDto.setTableAlias(dataModel.getName());
        tableDto.setDatasourceId(sysDataSource.getId());
        tableDto.setColumnList(PgBaseConnector.transfer(dataModel.getFields()));
        return tableDto;
    }

    public static TableInfoDto tableInfoInCreate(SysDataSource sysDataSource, PgDataModelBase dataModel) {
        TableInfoDto tableDto = PgBaseConnector.tableInfoInEdit(sysDataSource, dataModel);
        tableDto.setTableDec(dataModel.getTableDesc());
        return tableDto;
    }

    public static List<ColumnInfoDto> transferColumn(List<PgDataModelField> fields, String updateType) {
        ArrayList<ColumnInfoDto> columns = new ArrayList<ColumnInfoDto>();
        for (PgDataModelField x : fields) {
            MetadataColumn metadataColumn = PgBaseConnector.getMetadataColumn(x);
            ColumnInfoDto columnInfoDto = (ColumnInfoDto)BeanUtil.copyProperties((Object)metadataColumn, ColumnInfoDto.class);
            String isPk = "primary".equals(x.getUsage()) ? "1" : "0";
            String isRequired = x.getDataIsEmpty() ? "1" : "0";
            columnInfoDto.setPk(isPk);
            columnInfoDto.setIncrease("0");
            columnInfoDto.setRequired(isRequired);
            if (ToolUtil.isNotEmpty((Object)updateType)) {
                columnInfoDto.setOperation(updateType);
            }
            columns.add(columnInfoDto);
        }
        return columns;
    }

    private static List<MetadataColumn> transfer(List<PgDataModelField> fields) {
        ArrayList<MetadataColumn> columns = new ArrayList<MetadataColumn>();
        for (PgDataModelField x : fields) {
            MetadataColumn metadataColumn = PgBaseConnector.getMetadataColumn(x);
            columns.add(metadataColumn);
        }
        return columns;
    }

    private static MetadataColumn getMetadataColumn(PgDataModelField modelField) {
        Optional engineColumnType;
        String fieldSourceDataType = modelField.getSourceDataType();
        int preIndex = fieldSourceDataType.indexOf("(");
        String dataType = preIndex > -1 ? fieldSourceDataType.substring(0, preIndex) : modelField.getSourceDataType();
        MetadataColumn metadataColumn = new MetadataColumn();
        metadataColumn.setColumnAlias(modelField.getName());
        metadataColumn.setColumnName(modelField.getSourceFieldName());
        metadataColumn.setColumnComment(modelField.getComment());
        metadataColumn.setDataType(dataType);
        metadataColumn.setDataDot(Integer.valueOf(modelField.getDataDot()));
        metadataColumn.setDataLength(Long.valueOf(modelField.getDataLength()));
        metadataColumn.setDataIsEmpty(Integer.valueOf(modelField.getDataIsEmpty() ? 1 : 0));
        if (ToolUtil.isNotEmpty((Object)modelField.getUsage())) {
            if ("primary".equals(modelField.getUsage())) {
                metadataColumn.setPrimarys("1");
            }
            metadataColumn.setPurpose(modelField.getUsage());
        }
        if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)modelField.getDataType())).isPresent()) {
            metadataColumn.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
            metadataColumn.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
        }
        return metadataColumn;
    }
}

