/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.pgQueryDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.querycondition.PgQueryCondition;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.querycondition.PgQueryConditionField;
import com.jxdinfo.hussar.formdesign.pg.function.visitor.constant.PgConstUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataModelUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.pg.util.SqlReturnUtil;
import com.jxdinfo.hussar.formdesign.pg.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLMASTER_SLAVEDataDisplay")
public class PgMsDataDisplayVisitor
implements PgOperationVisitor<PgMsDataModel, PgMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgMsDataDisplayVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLMASTER_SLAVEDataDisplay";

    @Override
    public void visit(PgBackCtx<PgMsDataModel, PgMsDataModelDTO> backCtx, PgDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        PgMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        String modelId = useDataModelBase.getId();
        PgMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, String> aliasMap = useDataModelBase.getModelAliasName();
        Map<String, Object> params = this.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        boolean isSelectCondition = this.renderSelect(backCtx, dataModelOperation, modelId, useDataModelBase, dataModelBaseDTO, params);
        String relateFieldName = String.valueOf(params.get("relateField"));
        String relateField = dataModelBaseDTO.getFieldCapitalName(relateFieldName);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, params);
        String controllertempPath = "template/pg/masterslavebackcode/datadisplay/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllertempPath, params));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isSelectCondition);
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        logger.debug("\u751f\u6210service\u6267\u884c\u5f00\u59cb");
        String servicePath = "template/pg/masterslavebackcode/datadisplay/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, params));
        logger.debug("\u751f\u6210serviceImpl\u6267\u884c\u5f00\u59cb");
        String serviceImplPath = "template/pg/masterslavebackcode/datadisplay/service_impl.ftl";
        params.put("capitalRelateField", relateField);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, params));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/pg/masterslavebackcode/datadisplay/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, params));
        String xmlPath = "template/pg/masterslavebackcode/datadisplay/xml.ftl";
        Map<String, PgDataModelBase> dataModelBaseMap = dataModelBaseDTO.getDataModelBaseMap();
        String finalReturn = SqlReturnUtil.renderReturn(useDataModelBase, aliasMap);
        params.put("return", finalReturn);
        String finalRelation = SqlReturnUtil.renderRelation(useDataModelBase, dataModelBaseMap);
        params.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, params));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", isSelectCondition ? "postJson" : "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6570\u636e\u5c55\u793a");
        backCtx.addApi(modelId, PgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderPageVo(PgBackCtx<PgMsDataModel, PgMsDataModelDTO> backCtx, String modelId, PgMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        PgDataModelUtil.addQueryPageMsVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + PgDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }

    private void renderImport(PgBackCtx<PgMsDataModel, PgMsDataModelDTO> backCtx, String modelId, PgMsDataModelDTO dataModelBaseDTO, boolean isSelectCondition) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.support.audit.core.annotations.AuditLog");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "java.util.Arrays");
            backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        } else {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
            backCtx.addControllerImport(modelId, "java.util.Arrays");
            backCtx.addServiceImport(modelId, "java.util.List");
        }
    }

    private Map<String, Object> initParams(PgDataModelOperation dataModelOperation, PgDataModelBaseDTO dataModelBaseDTO, boolean isLogicallyDelete) {
        Map<String, Object> params = dataModelOperation.getParams();
        params.put("table", dataModelBaseDTO);
        params.put("returnValue", dataModelBaseDTO.getEntityName());
        params.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        params.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6570\u636e\u5c55\u793a");
            params.put("exegesis", dataModelOperation.getExegesis());
        }
        return params;
    }

    private boolean renderSelect(PgBackCtx<PgMsDataModel, PgMsDataModelDTO> backCtx, PgDataModelOperation dataModelOperation, String modelId, PgMsDataModel useDataModelBase, PgMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        Map<String, String> aliasMap = useDataModelBase.getModelAliasName();
        String inValuesSql = this.getInValuesSql(useDataModelBase, dataModelOperation, aliasMap, selectConditionName);
        boolean isSelectCondition = false;
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            PgQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
            ArrayList<String> likeQueryFields = new ArrayList<String>();
            for (PgQueryConditionField queryConditionField : queryCondition.getFields()) {
                String symbol = queryConditionField.getSymbol();
                if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
                likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
            }
            controllerParams.put("likeQueryFields", likeQueryFields);
            if (Optional.ofNullable(queryCondition).map(PgQueryCondition::getFields).isPresent() && !queryCondition.getFields().isEmpty()) {
                DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
                String logicallyFlag = "";
                if (isLogicallyDelete) {
                    PgDataModelField pgDataModelField = useDataModelBase.getDeleteFlag();
                    QueryConditionUtil.addLogicallyFlag(queryCondition, pgDataModelField.getName(), useDataModelBase.getMasterTable().getId());
                    logicallyFlag = pgDataModelField.getSourceFieldName();
                }
                pgQueryDTO queryDTO = PgDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
                dataModelBaseDTO.addQueryDto(queryDTO);
                String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), inValuesSql, dataModelBaseDTO, aliasMap, useDataModelBase, logicallyFlag);
                if (useDataModelBase.isLogicallyDelete()) {
                    QueryConditionUtil.deleteLogicallyFlag(queryCondition);
                }
                controllerParams.put("QueryObj", queryDTO.getEntityName());
                controllerParams.put("queryObj", queryDTO.getName());
                controllerParams.put("whereSql", finalWhereSql);
                isSelectCondition = true;
                controllerParams.put("isSelectCondition", PgConstUtil.TRUE);
                String importInfo = queryDTO.getImportInfo();
                backCtx.addControllerImport(modelId, importInfo);
                backCtx.addServiceImport(modelId, importInfo);
                backCtx.addServiceImplImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            }
        } else {
            controllerParams.put("whereSql", inValuesSql);
        }
        return isSelectCondition;
    }

    private String getInValuesSql(PgMsDataModel useDataModelBase, PgDataModelOperation dataModelOperation, Map<String, String> aliasMap, String selectConditionName) {
        PgDataModelField realFieldBase;
        String template = "<if test=\"inValues != null and inValues.size > 0\">\n ${T_ALIAS}.${REAL_FIELD} in\n    <foreach collection=\"inValues\" item=\"item\" open=\"(\" separator=\",\" close=\")\">\n        #{item}\n    </foreach>\n</if>";
        String entityAttr = (String)dataModelOperation.getParams().get("relateField");
        if (ToolUtil.isNotEmpty((Object)entityAttr) && ToolUtil.isNotEmpty((Object)((Object)(realFieldBase = useDataModelBase.getFields().stream().filter(field -> entityAttr.equals(field.getName())).findAny().orElseGet(PgDataModelField::new))))) {
            String alias = aliasMap.get(realFieldBase.getSourceDataModelId());
            String sourceFieldName = realFieldBase.getSourceFieldName();
            if (useDataModelBase.isLogicallyDelete() && !StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
                String logicallyFlag = useDataModelBase.getModelAliasName().get(useDataModelBase.getMasterTable().getId()) + "." + useDataModelBase.getDeleteFlag().getSourceFieldName();
                template = template + "AND (" + logicallyFlag + " != '1' or " + logicallyFlag + " IS NULL)";
            }
            return template.replace("${T_ALIAS}", alias).replace("${REAL_FIELD}", sourceFieldName);
        }
        return "";
    }
}

