/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLFLOWTableSave")
public class PgFlowTableSaveVisitor
implements PgOperationVisitor<PgFlowDataModel, PgFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgFlowTableSaveVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLFLOWTableSave";

    @Override
    public void visit(PgBackCtx<PgFlowDataModel, PgFlowDataModelDTO> backCtx, PgDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        PgFlowDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = useDataModelBase.getId();
        PgFlowDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        String controllerPath = "template/pg/backcode/tableSave/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/pg/backcode/tableSave/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        if (useDataModelBase.getLogicallyDelete()) {
            controllerParams.put("logicallyDelete", true);
            String logicallyFieldName = useDataModelBase.getDeleteFlag().getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("logicallyFlag", String.valueOf(chars));
        }
        String serviceImplPath = "template/pg/backcode/tableSave/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6570\u636e\u8868\u683c\u5bfc\u5165");
        backCtx.addApi(modelId, PgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(PgBackCtx<PgFlowDataModel, PgFlowDataModelDTO> backCtx, String modelId, PgFlowDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
    }

    private Map<String, Object> initParams(PgDataModelOperation dataModelOperation, PgFlowDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }
}

