/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.visitor.masterslave.PgMsExcelImportVisitor;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLMASTER_SLAVEExcelExport")
public class PgMsExcelExportVisitor
implements PgOperationVisitor<PgMsDataModel, PgMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgMsExcelImportVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLMASTER_SLAVEExcelExport";

    @Override
    public void visit(PgBackCtx<PgMsDataModel, PgMsDataModelDTO> backCtx, PgDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        PgMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        PgDataModelBase masterTable = dataModelBase.getMasterTable();
        PgMsDataModelDTO pgMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = pgMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, PgDataModelBaseDTO> dataModelDtoMap = pgMsDataModelDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", pgMsDataModelDTO);
        controllerParams.put("returnValue", pgMsDataModelDTO.getEntityName());
        controllerParams.put("url", url);
        controllerParams.put("operationName", controllerParams.get("name"));
        PgDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
        backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Service"));
        backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
        backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Entity"));
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(pgMsDataModelDTO.getComment() + "\u4e3b\u5b50\u8868Excel\u5bfc\u51fa");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/pg/masterslavebackcode/excelExport/controller.ftl";
        controllerParams.put("QueryObj", pgMsDataModelDTO.getEntityName() + "SelectCondition");
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelExportDto");
        backCtx.addControllerImport(modelId, pgMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, pgMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerInversion(modelId, pgMsDataModelDTO.getServiceName());
        if (ToolUtil.isNotEmpty((Object)pgMsDataModelDTO.isHasTranslate()) && pgMsDataModelDTO.isHasTranslate()) {
            for (PgDataModelFieldDto field : pgMsDataModelDTO.getFields()) {
                String typeName = "";
                String fieldAnnotation = field.getFieldAnnotation();
                if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                    int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                    int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                    if (startIndex != -1 && endIndex != -1) {
                        typeName = fieldAnnotation.substring(startIndex, endIndex);
                    }
                }
                field.setDictTyeName(typeName);
            }
            pgMsDataModelDTO.getDataModelDtoMap().entrySet().stream().filter(a -> !masterTable.getId().equals(a.getKey())).forEach(entry -> {
                for (PgDataModelFieldDto field : ((PgDataModelBaseDTO)entry.getValue()).getFields()) {
                    String typeName = "";
                    String fieldAnnotation = field.getFieldAnnotation();
                    if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                        int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                        int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                        if (startIndex != -1 && endIndex != -1) {
                            typeName = fieldAnnotation.substring(startIndex, endIndex);
                        }
                    }
                    field.setDictTyeName(typeName);
                }
            });
            backCtx.addServiceImplInversion(modelId, "ISysDicRefService");
        }
        String servicePath = "template/pg/masterslavebackcode/excelExport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImport(modelId, "java.util.List");
        String serviceImplPath = "template/pg/masterslavebackcode/excelExport/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.model.DicSingle");
        backCtx.addServiceImplImport(modelId, "scala.collection.mutable.StringBuilder");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.util.ExcelUtils");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.vo.DictVo");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.service.ISysDicRefService");
        backCtx.addServiceImplImport(modelId, "java.util.LinkedHashMap");
        backCtx.addServiceImplInversion(modelId, pgMsDataModelDTO.getMapperName());
        String mapperPath = "template/pg/masterslavebackcode/excelExport/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, "java.util.LinkedHashMap");
        String xmlPath = "template/pg/masterslavebackcode/excelExport/xml.ftl";
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "downloadResource", url, "\u4e3b\u5b50\u8868Excel\u5bfc\u51fa");
        backCtx.addApi(modelId, PgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

