/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.customOption.task;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.PgCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgCustomOperation;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLTASKCUSTOM_OPTION")
public class PgTaskCustomOption
implements PgCustomOperation<PgTaskDataModel, PgTaskDataModelDTO> {
    public static final String CUSTOM_OPTION = "POSTGRE_SQLTASKCUSTOM_OPTION";

    @Override
    public void publishCustomOption(PgBackCtx<PgTaskDataModel, PgTaskDataModelDTO> backCtx) throws LcdpException {
        this.publishTaskDataBackFill(backCtx);
    }

    private void publishTaskDataBackFill(PgBackCtx<PgTaskDataModel, PgTaskDataModelDTO> backCtx) throws LcdpException {
        if (ToolUtil.isEmpty((Object)backCtx.getParams()) || ToolUtil.isEmpty(backCtx.getParams().get("identity"))) {
            return;
        }
        PgTaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        PgTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        if (ToolUtil.isEmpty(useDataModelDTO.getCustomCodeGenerateInfo())) {
            useDataModelDTO.setCustomCodeGenerateInfo(new HashMap<String, PgCodeGenerateInfo>());
        }
        useDataModelDTO.getCustomCodeGenerateInfo().put(useDataModelBase.getId(), this.genTaskDataBackFillCode(backCtx));
    }

    private PgCodeGenerateInfo genTaskDataBackFillCode(PgBackCtx<PgTaskDataModel, PgTaskDataModelDTO> backCtx) throws LcdpException {
        PgTaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        PgTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        PgBaseDataModel task = useDataModelBase.getTask();
        String taskId = task.getId();
        PgDataModelBaseDTO userTaskModelDTO = useDataModelDTO.getDataModelDtoMap().get(taskId);
        PgDataModelBaseDTO userBusinessModelDTO = useDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getId());
        String modulePath = useDataModelDTO.getTablePath().toLowerCase();
        String fileName = userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl";
        String writePath = modulePath + File.separator + "Task".toLowerCase() + File.separator + fileName + ".java";
        String dataBackFillPath = "template/pg/taskbackcode/code/task_data_backfill_service_impl.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("package", userTaskModelDTO.getPackageInfo().get("Task"));
        params.put("className", fileName);
        params.put("identity", backCtx.getParams().get("identity"));
        TreeSet<String> imports = new TreeSet<String>();
        params.put("implementServiceNameImportInfo", "com.jxdinfo.hussar.workflow.task.model.service.TaskModelService");
        params.put("implementServiceName", "TaskModelService");
        params.put("ProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto");
        params.put("DeletedProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto");
        params.put("ProcessNodeInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto");
        params.put("CompleteTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto");
        params.put("UpdateTaskUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto");
        params.put("WorkflowUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.WorkflowUserDto");
        params.put("TaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto");
        params.put("DeletedTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto");
        params.put("taskEntity", userTaskModelDTO.getEntityName());
        params.put("taskEntityImportInfo", userTaskModelDTO.getImportInfo().get("Entity"));
        params.put("taskServiceName", userTaskModelDTO.getServiceName());
        params.put("taskServiceImportInfo", userTaskModelDTO.getImportInfo().get("Service"));
        params.put("businessServiceName", userBusinessModelDTO.getServiceName());
        params.put("businessServiceImportInfo", userBusinessModelDTO.getImportInfo().get("Service"));
        params.put("businessEntity", userBusinessModelDTO.getEntityName());
        params.put("businessEntityImportInfo", userBusinessModelDTO.getImportInfo().get("Entity"));
        HashMap<String, String> businessColumn = new HashMap<String, String>();
        List<PgDataModelFieldDto> businessFields = userBusinessModelDTO.getFields();
        for (PgDataModelFieldDto pgDataModelFieldDto : businessFields) {
            if (!ToolUtil.isNotEmpty((Object)pgDataModelFieldDto.getFill())) continue;
            businessColumn.put(pgDataModelFieldDto.getFill(), pgDataModelFieldDto.getName());
            if (!"primary".equals(pgDataModelFieldDto.getFill())) continue;
            params.put("primaryType", pgDataModelFieldDto.getColumnType().getType());
            if (!ToolUtil.isNotEmpty((Object)pgDataModelFieldDto.getColumnType().getImportT())) continue;
            imports.add(pgDataModelFieldDto.getColumnType().getImportT());
        }
        params.put("businessColumn", businessColumn);
        List<PgDataModelField> fields = task.getFields();
        for (PgDataModelField field : fields) {
            if ("foreign".equals(field.getUsage())) {
                params.put("taskForeign", field.getSourceFieldName());
            }
            if (!"taskId".equals(field.getName())) continue;
            params.put("taskTaskId", field.getSourceFieldName());
        }
        params.put("dataSourceName", useDataModelBase.getDataSourceName());
        params.put("imports", imports);
        PgCodeGenerateInfo pgCodeGenerateInfo = new PgCodeGenerateInfo();
        pgCodeGenerateInfo.setFileWriteRelativePath(writePath);
        pgCodeGenerateInfo.setFileContent(RenderUtil.renderTemplate((String)dataBackFillPath, params));
        pgCodeGenerateInfo.setFileType("serviceImpl");
        pgCodeGenerateInfo.setFileId(useDataModelDTO.getId());
        pgCodeGenerateInfo.setFileName(userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl" + ".java");
        return pgCodeGenerateInfo;
    }
}

