@Override
<#if !isRemote>@HussarTransactional</#if>
public ApiResponse<String> ${name!}(${table.priType} id){
    try{
        /* @begin ${name!}1 #自定义代码 */
        /* @end ${name!}1 */
        this.removeByIds(Collections.singletonList(id));
        /* @begin ${name!}2 #自定义代码 */
        /* @end ${name!}2 */
        <#if isRemote>
        return this.deleteProcessInstance(id);
        <#else>
        return ((${table.serviceName}) AopContext.currentProxy()).deleteProcessInstance(id);
        </#if>
    } catch(Exception e){
        throw new HussarException(e.getMessage(),e);
    }

}

@Override
<#if !isRemote>@HussarTransactional</#if>
public ApiResponse<String> ${name!}UnStart(${table.priType} id){
    // 验证流程状态
    BpmResponseResult validateResult;
    try {
        <#if isRemote>
        validateResult = this.getValidateResult(id);
        <#else>
        validateResult = ((${table.serviceName}) AopContext.currentProxy()).getValidateResult(id);
        </#if>
        if (BpmConstant.SUCCESS_CODE.equals(validateResult.getCode())) {
            String state = validateResult.getResult().get(0) == null ? "" : validateResult.getResult().get(0).toString();
            switch (state) {
                //1 代表流程已经启动，并且节点处于第一节点，可以删除业务数据和流程数据
                case BpmConstant.SUCCESS_CODE:
                    //删除业务数据
                    this.removeByIds(Collections.singletonList(id));
                    // 删除流程数据
                    <#if isRemote>
                    return this.deleteProcessInstance(id);
                    <#else>
                    return ((${table.serviceName}) AopContext.currentProxy()).deleteProcessInstance(id);
                    </#if>
                //2 代表流程已经启动，并且节点不处于第一节点，不可以删除业务数据和流程数据
                case "2":
                    throw new HussarException(validateResult.getMsg());
                //0 代表流程没有启动，可以删除业务数据，不需要删除流程数据
                case BpmConstant.ERROR_CODE:
                    // 删除业务数据
                    this.removeByIds(Collections.singletonList(id));
                    return ApiResponse.success("");
                default:
                    throw new HussarException("删除失败！");
            }
        }
        throw new HussarException("删除失败！");
    } catch(Exception e) {
        throw new HussarException(e.getMessage(),e);
        }
}

@Override
@HussarTransactional
${dataSourceAnnotation!}
public BpmResponseResult getValidateResult(${table.priType} id) {
    return InstanceEngineService.validateDeleteByBusinessKey(String.valueOf(id));
}

@Override
@HussarTransactional
${dataSourceAnnotation!}
public ApiResponse<String> deleteProcessInstance(${table.priType} id) {
    BpmResponseResult bpmResponseResult;
    try {
        bpmResponseResult =  InstanceEngineService.deleteProcessInstanceByBusinessKey(String.valueOf(id));
        if (BpmConstant.SUCCESS_CODE.equals(bpmResponseResult.getCode())){
            return ApiResponse.success("");
        }
        throw new HussarException(bpmResponseResult.getMsg());
    } catch(Exception e){
        throw new HussarException(e.getMessage(),e);
    }

}