<#include "../../auditLog/ds.ftl">
<#if mainId?? && mainId?has_content>
@Autowired
private ${masterTable.mapperName} ${masterTable.name}DeleteCascadeMapper;

@Override
<#--拼接HUSSARTRANSACTIONAL注解-->
<#if openTransactional?? && openTransactional!>@HussarTransactional</#if>
<#--拼接主表主键类型-->
public ApiResponse<Boolean> ${name!}(List<${masterSlaveTable.priType}> ids) {
    try {
        List<String> idsToDelete = new ArrayList<>();
        idsToDelete.addAll(ids);
        LambdaQueryWrapper<${masterTable.entityName}> deleteCascadeWrapper = new LambdaQueryWrapper();
        deleteCascadeWrapper.in(${masterTable.entityName}::${mainName!} ,ids);
        List<${masterTable.entityName}> entities = ${masterTable.name}DeleteCascadeMapper.selectList(deleteCascadeWrapper);
        if(HussarUtils.isEmpty(entities)){
            return ApiResponse.fail("选中项为空");
        }
        for (int i = 0; i < entities.size(); i++) {
            ${masterTable.name}DeleteCascadeFindAndAddChildIds(entities.get(i).${mainId!}().toString(),idsToDelete);
        }
        idsToDelete = idsToDelete.stream().distinct().collect(Collectors.toList());
        if (null != idsToDelete && idsToDelete.size() > 0) {
            <#if relationshipDtoList??&&relationshipDtoList?size gt 0>

                <#--遍历关联关系集合，则生成以下代码，只生成一次-->
                List<${masterTable.entityName!}> ${masterTable.entityName?uncap_first}List = ${masterTable.serviceName?uncap_first}.listByIds(ids);
                for (${masterTable.entityName!} ${masterTable.entityName?uncap_first} : ${masterTable.entityName?uncap_first}List) {


                <#--遍历关联关系集合，循环生成子表Wrapper对象-->
                <#list relationshipDtoList as map>
                        UpdateWrapper<${map.slaveTableName?cap_first}> ${map.slaveTableName?uncap_first}Wrapper = new UpdateWrapper<>();
                </#list>

                <#--拼接关联关系字符串-->
                ${relationStr}
                /* @begin ${name!}1 #自定义代码 */
                /* @end ${name!}1 */
                <#--遍历关联关系集合，循环生成子表service.remove方法-->
                <#list relationshipDtoList as map>
                        ${map.slaveTableServiceName?uncap_first}.remove(${map.slaveTableName?uncap_first}Wrapper);
                </#list>
                /* @begin ${name!}2 #自定义代码 */
                /* @end ${name!}2 */
                <#--遍历关联关系集合，生成大括号，只生成一次-->
                        }
                /* @begin ${name!}3 #自定义代码 */
                /* @end ${name!}3 */
                <#--遍历关联关系集合，生成主表service.remove方法，只生成一次-->
                <#list relationshipDtoList as map>
                        ${masterTable.serviceName?uncap_first}.removeByIds(idsToDelete);
                        <#break>
                </#list>
            </#if>
                    /* @begin ${name!}4 #自定义代码 */
                    /* @end ${name!}4 */
                    return ApiResponse.success(true);
                    }
        } catch (Exception e) {
        throw new HussarException("删除失败",e);
    }
    return ApiResponse.fail("删除失败");
}

    private void ${masterTable.name}DeleteCascadeFindAndAddChildIds(String parentId, List<String> idsToDelete) {
            LambdaQueryWrapper<${masterTable.entityName}> getChildren = new LambdaQueryWrapper<>();
            getChildren.eq(${masterTable.entityName}::${pId!},parentId);
            List<${masterTable.entityName}> childRecords = ${masterTable.name}DeleteCascadeMapper.selectList(getChildren);
            // 将找到的子记录的ID添加到列表中
            for (${masterTable.entityName} childRecord : childRecords) {
                idsToDelete.add(childRecord.${mainName!}().toString());
                // 递归地查找子记录的子记录
                ${masterTable.name}DeleteCascadeFindAndAddChildIds(childRecord.${mainId!}().toString(), idsToDelete);
            }
        }

<#else>
@Override
<#--拼接HussarTransactional注解-->
<#if openTransactional?? && openTransactional!>@HussarTransactional</#if>
<#--拼接主表主键类型-->
public ApiResponse<Boolean> ${name!}(List<${masterSlaveTable.priType}> ids) {
    try {
        if (null != ids && ids.size() > 0) {
            <#if relationshipDtoList??&&relationshipDtoList?size gt 0>

                <#--遍历关联关系集合，则生成以下代码，只生成一次-->
                List<${masterTable.entityName!}> ${masterTable.entityName?uncap_first}List = ${masterTable.serviceName?uncap_first}.listByIds(ids);
                for (${masterTable.entityName!} ${masterTable.entityName?uncap_first} : ${masterTable.entityName?uncap_first}List) {


                <#--遍历关联关系集合，循环生成子表Wrapper对象-->
                <#list relationshipDtoList as map>
                        UpdateWrapper<${map.slaveTableName?cap_first}> ${map.slaveTableName?uncap_first}Wrapper = new UpdateWrapper<>();
                </#list>

                <#--拼接关联关系字符串-->
                ${relationStr}
                /* @begin ${name!}1 #自定义代码 */
                /* @end ${name!}1 */
                <#--遍历关联关系集合，循环生成子表service.remove方法-->
                <#list relationshipDtoList as map>
                        ${map.slaveTableServiceName?uncap_first}.remove(${map.slaveTableName?uncap_first}Wrapper);
                </#list>
                /* @begin ${name!}2 #自定义代码 */
                /* @end ${name!}2 */
                <#--遍历关联关系集合，生成大括号，只生成一次-->
                        }
                /* @begin ${name!}3 #自定义代码 */
                /* @end ${name!}3 */
                <#--遍历关联关系集合，生成主表service.remove方法，只生成一次-->
                <#list relationshipDtoList as map>
                        ${masterTable.serviceName?uncap_first}.removeByIds(ids);
                        <#break>
                </#list>
            </#if>
                    /* @begin ${name!}4 #自定义代码 */
                    /* @end ${name!}4 */
                    return ApiResponse.success(true);
                    }
        } catch (Exception e) {
        throw new HussarException("删除失败",e);
    }
    return ApiResponse.fail("删除失败");
}
</#if>
