/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.util;

import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.pg.function.PgCustomOperation;
import com.jxdinfo.hussar.formdesign.pg.function.PgEnclosure;
import com.jxdinfo.hussar.formdesign.pg.function.PgModelFunction;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.PgRender;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class PgModelBeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(PgModelBeanUtil.class);

    public static PgOperationVisitor<PgDataModelBase, PgDataModelBaseDTO> getVisitorBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u65b9\u6cd5\u8bbf\u95ee\u8005\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u65b9\u6cd5\u8bbf\u95ee\u8005\u5931\u8d25");
        }
        return (PgOperationVisitor)fromObj;
    }

    public static PgModelFunction getFunctionModelVisitorBean(String functionModelName) throws LcdpException {
        Object fromObj;
        try {
            fromObj = FunctionModelFactory.obtainFunction((String)("POSTGRE_SQL." + functionModelName)).newInstance();
            if (ObjectUtils.isEmpty(fromObj)) {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, fromObj + "\uff1a\u529f\u80fd\u6a21\u578b\u672a\u6ce8\u518c");
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("\u83b7\u53d6\u529f\u80fd\u6a21\u578b\u5931\u8d25", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, functionModelName + "\uff1a\u83b7\u53d6\u529f\u80fd\u6a21\u578b\u5931\u8d25");
        }
        return (PgModelFunction)fromObj;
    }

    public static PgRender<PgDataModelBase, PgDataModelBaseDTO> getRenderBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6bean({})\u5931\u8d25", (Object)bean, (Object)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u5931\u8d25");
        }
        return (PgRender)fromObj;
    }

    public static PgEnclosure<PgDataModelBase> getEnclosureBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6bean({})\u5931\u8d25", (Object)bean, (Object)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u5931\u8d25");
        }
        return (PgEnclosure)fromObj;
    }

    public static PgCustomOperation getCustomOperationBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6bean({})\u5931\u8d25", (Object)bean, (Object)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u5931\u8d25");
        }
        return (PgCustomOperation)fromObj;
    }
}

