/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.provider;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.function.PgModelFunction;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.service.PgWorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.pg.util.PgModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PgModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(PgModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"POSTGRE_SQL", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + dataModelBase.getName();
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            String tenantCodePrefix = Optional.ofNullable(AppContextUtil.getAppInfo()).map(e -> "/" + e.getTenantId()).orElse("");
            return FileUtil.posixPath((String[])new String[]{tenantCodePrefix, apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)modelId);
        if (ToolUtil.isEmpty((Object)dataModelJson)) {
            return "";
        }
        PgModelFunction modelFunction = PgModelBeanUtil.getFunctionModelVisitorBean(dataModelJson.getString("functionType"));
        PgDataModelBase lrDataModelBase = modelFunction.parseDataModel(dataModelJson);
        return lrDataModelBase.getFields().stream().filter(e -> "primary".equals(e.getUsage())).findFirst().orElseGet(PgDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        PgModelFunction modelFunction = PgModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        PgDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(dataModelBase.getOperations())) {
            for (PgDataModelOperation operation : dataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId, String oldVersion, String organId, String newOrganId) throws LcdpException, IOException, CloneNotSupportedException {
        return new PgWorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId, oldVersion, organId, newOrganId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        PgModelFunction modelFunction = PgModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        PgDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        ArrayList<DataModelFieldBase> pgDataModelFields = new ArrayList<DataModelFieldBase>();
        List<PgDataModelField> fields = dataModelBase.getFields();
        if (ToolUtil.isNotEmpty(fields)) {
            pgDataModelFields.addAll(fields);
        } else {
            List<PgDataModelBase> slaveTables = null;
            PgDataModelBase masterTable = new PgBaseDataModel();
            if (modelFunction instanceof PgFlowMsDataModel) {
                slaveTables = ((PgFlowMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((PgFlowMsDataModel)dataModelBase).getMasterTable();
            } else if (modelFunction instanceof PgMsDataModel) {
                slaveTables = ((PgMsDataModel)dataModelBase).getSlaveTables();
                masterTable = ((PgMsDataModel)dataModelBase).getMasterTable();
            }
            pgDataModelFields.addAll(masterTable.getFields());
            if (ToolUtil.isNotEmpty(slaveTables)) {
                for (PgDataModelBase slaveTable : slaveTables) {
                    pgDataModelFields.addAll(slaveTable.getFields());
                }
            }
        }
        if (modelFunction instanceof PgTaskDataModel) {
            pgDataModelFields.addAll(((PgTaskDataModel)dataModelBase).getTask().getFields());
        } else if (modelFunction instanceof PgTaskMsDataModel) {
            pgDataModelFields.addAll(((PgTaskMsDataModel)dataModelBase).getTask().getFields());
        }
        return pgDataModelFields;
    }

    public void delete(String modelId) throws LcdpException {
    }

    public Map<String, Map<String, Object>> getSlaveModelInfos(String modelId) throws LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        PgModelFunction modelFunction = PgModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        PgDataModelBase model = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return model.getSlaveModelInfo();
    }
}

