/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLMASTER_SLAVEFlagDeleteBatch")
public class PgMsFlagDeleteVisitor
implements PgOperationVisitor<PgMsDataModel, PgMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgMsFlagDeleteVisitor.class);
    private static final String DELGETSTR = "::get";
    public static final String OPERATION_NAME = "POSTGRE_SQLMASTER_SLAVEFlagDeleteBatch";

    @Override
    public void visit(PgBackCtx<PgMsDataModel, PgMsDataModelDTO> backCtx, PgDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String currentModelId = backCtx.getUseDataModelBase().getId();
        PgMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        PgMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        PgDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<PgRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            logger.error("\u5b50\u8868\u5173\u8054\u5173\u7cfb\u5bf9\u8c61\u96c6\u5408\u4e3a\u7a7a\u6216\u4e3b\u8868\u5bf9\u8c61\u4e3a\u7a7a");
            return;
        }
        PgDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        for (PgRelationshipDTO relationshipDTO : relationshipDtoList) {
            relationshipDTO.init();
        }
        StringBuilder relationStr = this.getDelStr(relationshipDtoList, masterDto);
        String url = baseDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, Object> params = operation.getParams();
        List<PgDataModelFieldDto> fields = baseDataModelDTO.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            if (fields.get(i).getId().equals(operation.getParams().get("mainId"))) {
                params.put("mainId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (fields.get(i).getId().equals(operation.getParams().get("pId"))) {
                params.put("pId", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
            }
            if (!HussarUtils.isNotEmpty((Object)fields.get(i).getFill()) || !fields.get(i).getFill().equals("primary")) continue;
            params.put("mainName", "get" + Character.toUpperCase(fields.get(i).getPropertyName().charAt(0)) + fields.get(i).getPropertyName().substring(1));
        }
        params.put("masterTable", masterDto);
        params.put("masterSlaveTable", baseDataModelDTO);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        params.put("logicallyDelete", isLogicallyDelete);
        params.put("url", url);
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            params.put("openTransactional", backCtx.getOpenTransactional());
            backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(baseDataModelDTO.getComment() + "\u5220\u9664\u4e3b\u5b50");
            params.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/pg/masterslavebackcode/flagdelete/controller.ftl";
        backCtx.addControllerCode(currentModelId, RenderUtil.renderTemplate((String)controllerPath, params));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "java.util.Arrays");
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(currentModelId, baseDataModelDTO.getServiceName());
        logger.debug("\u751f\u6210service\u6267\u884c\u5f00\u59cb");
        String servicePath = "template/pg/masterslavebackcode/flagdelete/service.ftl";
        backCtx.addServiceImport(currentModelId, "java.util.List");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceCode(currentModelId, RenderUtil.renderTemplate((String)servicePath, params));
        logger.debug("\u751f\u6210serviceImpl\u6267\u884c\u5f00\u59cb");
        boolean delFlag = true;
        for (PgRelationshipDTO pgRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            PgDataModelBaseDTO pgDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(pgRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, pgDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, pgDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, pgDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        String implPath = "template/pg/masterslavebackcode/flagdelete/service_impl.ftl";
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(currentModelId, "org.springframework.beans.factory.annotation.Autowired");
        backCtx.addServiceImplImport(currentModelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
        backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Mapper"));
        backCtx.addServiceImplCode(currentModelId, RenderUtil.renderTemplate((String)implPath, params));
        if (isLogicallyDelete) {
            backCtx.addServiceImplImport(currentModelId, baseDataModelDTO.getImportInfo().get("Mapper"));
            params.put("deleteFlag", useDataModelBase.getDeleteFlag().getSourceFieldName());
            params.put("primaryKey", useDataModelBase.getPrimaryKey().getSourceFieldName());
            backCtx.addServiceImplInversion(currentModelId, baseDataModelDTO.getMapperName());
            String mapperPath = "template/pg/masterslavebackcode/flagdelete/mapper.ftl";
            backCtx.addMapperCode(currentModelId, RenderUtil.renderTemplate((String)mapperPath, params));
            backCtx.addMapperImport(currentModelId, "java.util.List");
            backCtx.addMapperImport(currentModelId, "org.apache.ibatis.annotations.Param");
            String xmlPath = "template/pg/masterslavebackcode/flagdelete/xml.ftl";
            backCtx.addXmlCode(currentModelId, RenderUtil.renderTemplate((String)xmlPath, params));
        }
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postForm", baseDataModelDTO.getApiPrefix() + "/" + operation.getName(), "\u5220\u9664");
        backCtx.addApi(currentModelId, PgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    public StringBuilder getDelStr(List<PgRelationshipDTO> relationshipDtoList, PgDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (PgRelationshipDTO relationtMap : relationshipDtoList) {
            List<PgRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            PgRelationshipFieldDTO pgRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDTO.getSlaveFieldCap()).append(",ids));\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDTO.getSlaveFieldCap()).append(",ids)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                PgRelationshipFieldDTO pgRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(pgRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(pgRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(PgMsFlagDeleteVisitor.lowercase(masterDto.getEntityName())).append(".get").append(pgRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(PgMsFlagDeleteVisitor.lowercase(masterDto.getEntityName())).append(".get").append(pgRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }
}

