/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.render.PgBaseRender;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLFLOW_MASTER_SLAVEExcelImport")
public class PgMsFlowExcelImportVisitor
implements PgOperationVisitor<PgFlowMsDataModel, PgFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgMsFlowExcelImportVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLFLOW_MASTER_SLAVEExcelImport";

    @Override
    public void visit(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, PgDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        PgFlowMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        PgDataModelBase masterTable = dataModelBase.getMasterTable();
        PgFlowMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName();
        Map<String, PgDataModelBaseDTO> dataModelDtoMap = dataModelBaseDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("operationName", controllerParams.get("name"));
        controllerParams.put("slaveTable", PgMsFlowExcelImportVisitor.getSlaveArrayTables(dataModelBaseDTO, dataModelBase));
        controllerParams.put("primaryField", dataModelBaseDTO.getKeyPropertyName());
        PgDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
        controllerParams.put("masterServiceName", masterDTO.getServiceName());
        for (PgDataModelBaseDTO gaussDataModelBaseDTO : dataModelDtoMap.values()) {
            backCtx.addServiceImplImport(modelId, gaussDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplImport(modelId, gaussDataModelBaseDTO.getImportInfo().get("Entity"));
        }
        backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u4e3b\u5b50\u8868Excel\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        String controllerPath = "template/pg/masterslavebackcode/excelImport/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/pg/masterslavebackcode/excelImport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            for (PgDataModelFieldDto pgDataModelFieldDto : dataModelBaseDTO.getFields()) {
                String typeName = "";
                String fieldAnnotation = pgDataModelFieldDto.getFieldAnnotation();
                if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                    int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                    int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                    if (startIndex != -1 && endIndex != -1) {
                        typeName = fieldAnnotation.substring(startIndex, endIndex);
                    }
                }
                pgDataModelFieldDto.setDictTyeName(typeName);
            }
            dataModelBaseDTO.getDataModelDtoMap().entrySet().stream().skip(1L).forEach(entry -> {
                for (PgDataModelFieldDto field : ((PgDataModelBaseDTO)entry.getValue()).getFields()) {
                    String typeName = "";
                    String fieldAnnotation = field.getFieldAnnotation();
                    if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                        int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                        int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                        if (startIndex != -1 && endIndex != -1) {
                            typeName = fieldAnnotation.substring(startIndex, endIndex);
                        }
                    }
                    field.setDictTyeName(typeName);
                }
            });
            backCtx.addServiceImplInversion(modelId, "ISysDicRefService");
        }
        String serviceImplPath = "template/pg/masterslavebackcode/excelImport/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.vo.DictVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.service.ISysDicRefService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.model.DicSingle");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.util.ExcelUtils");
        backCtx.addServiceImplImport(modelId, "java.lang.reflect.Field");
        backCtx.addServiceImplImport(modelId, "java.util.function.Function");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.Collections");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getServiceName());
        for (PgDataModelBaseDTO gaussDataModelBaseDTO : dataModelBaseDTO.getDataModelDtoMap().values()) {
            backCtx.addServiceImplInversion(modelId, gaussDataModelBaseDTO.getServiceName());
        }
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", url, "\u6d41\u7a0b\u4e3b\u5b50\u8868Excel\u5bfc\u5165");
        backCtx.addApi(modelId, PgBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static List<PgDataModelBase> getSlaveArrayTables(PgFlowMsDataModelDTO dataModelBaseDTO, PgFlowMsDataModel dataModelBase) {
        CopyOnWriteArrayList<PgDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<PgDataModelBase>(dataModelBase.getSlaveTables());
        block0: for (PgDataModelBase slaveArrayTable : slaveArrayTables) {
            for (PgDataModelField field : slaveArrayTable.getFields()) {
                if (!"foreign".equals(field.getUsage())) continue;
                slaveArrayTable.setForeignField(field.getName());
                continue block0;
            }
        }
        return slaveArrayTables;
    }
}

