/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.render.PgBaseRender;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLFLOW_MASTER_SLAVEExcelExport")
public class PgMsFlowExcelExportVisitor
implements PgOperationVisitor<PgFlowMsDataModel, PgFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgMsFlowExcelExportVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLFLOW_MASTER_SLAVEExcelExport";

    @Override
    public void visit(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, PgDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        PgFlowMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        PgDataModelBase masterTable = dataModelBase.getMasterTable();
        PgFlowMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName();
        Map<String, PgDataModelBaseDTO> dataModelDtoMap = dataModelBaseDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", url);
        controllerParams.put("operationName", controllerParams.get("name"));
        PgDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
        backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Service"));
        backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
        backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Entity"));
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u4e3b\u5b50\u8868Excel\u5bfc\u51fa");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        String controllerPath = "template/pg/masterslavebackcode/excelExport/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelExportDto");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            for (PgDataModelFieldDto field : dataModelBaseDTO.getFields()) {
                String typeName = "";
                String fieldAnnotation = field.getFieldAnnotation();
                if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                    int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                    int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                    if (startIndex != -1 && endIndex != -1) {
                        typeName = fieldAnnotation.substring(startIndex, endIndex);
                    }
                }
                field.setDictTyeName(typeName);
            }
            dataModelBaseDTO.getDataModelDtoMap().entrySet().stream().filter(a -> !masterTable.getId().equals(a.getKey())).forEach(entry -> {
                for (PgDataModelFieldDto field : ((PgDataModelBaseDTO)entry.getValue()).getFields()) {
                    String typeName = "";
                    String fieldAnnotation = field.getFieldAnnotation();
                    if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                        int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                        int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                        if (startIndex != -1 && endIndex != -1) {
                            typeName = fieldAnnotation.substring(startIndex, endIndex);
                        }
                    }
                    field.setDictTyeName(typeName);
                }
            });
            backCtx.addServiceImplInversion(modelId, "ISysDicRefService");
        }
        String servicePath = "template/pg/masterslavebackcode/excelExport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImport(modelId, "java.util.List");
        String serviceImplPath = "template/pg/masterslavebackcode/excelExport/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.model.DicSingle");
        backCtx.addServiceImplImport(modelId, "scala.collection.mutable.StringBuilder");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.util.ExcelUtils");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.vo.DictVo");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.service.ISysDicRefService");
        backCtx.addServiceImplImport(modelId, "java.util.LinkedHashMap");
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/pg/masterslavebackcode/excelExport/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, "java.util.LinkedHashMap");
        String xmlPath = "template/pg/masterslavebackcode/excelExport/xml.ftl";
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "downloadResource", url, "\u6d41\u7a0b\u4e3b\u5b50\u8868Excel\u5bfc\u51fa");
        backCtx.addApi(modelId, PgBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

