/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.flow.masterslaveflow;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLFLOW_MASTER_SLAVEAsyncVerify")
public class PgMsFlowAsyncVerifyVisitor
implements PgOperationVisitor<PgFlowMsDataModel, PgFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgMsFlowAsyncVerifyVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLFLOW_MASTER_SLAVEAsyncVerify";

    @Override
    public void visit(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, PgDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        PgFlowMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = backCtx.getUseDataModelBase().getId();
        PgFlowMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        HashMap<String, Object> controllerParams = new HashMap<String, Object>();
        controllerParams.put("name", dataModelOperation.getName());
        if (ToolUtil.isNotEmpty((Object)dataModelOperation.getExegesis())) {
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        } else {
            controllerParams.put("exegesis", dataModelBaseDTO.getComment() + "\u5f02\u6b65\u6821\u9a8c");
        }
        controllerParams.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        controllerParams.put("table", table);
        String controllerPath = "template/pg/flowbackcode/masterslaveflowbackcode/asyncverify/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/pg/flowbackcode/masterslaveflowbackcode/asyncverify/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/pg/flowbackcode/masterslaveflowbackcode/asyncverify/service_impl.ftl";
        ArrayList<JSONObject> columnList = new ArrayList<JSONObject>();
        ArrayList<PgBaseDataModel> allModel = new ArrayList<PgBaseDataModel>();
        String masterTableId = useDataModelBase.getMasterTable().getId();
        allModel.add((PgBaseDataModel)useDataModelBase.getMasterTable());
        List<PgDataModelBase> slaveTables = useDataModelBase.getSlaveTables();
        for (PgRelationshipBase relationship : useDataModelBase.getRelationships()) {
            if (!"association".equals(relationship.getRelateModelType())) continue;
            for (PgDataModelBase slaveTable : slaveTables) {
                if (!slaveTable.getId().equals(relationship.getSlaveTableId())) continue;
                allModel.add((PgBaseDataModel)slaveTable);
            }
        }
        for (PgBaseDataModel pgDataModelBase : allModel) {
            PgDataModelBaseDTO pgDataModelDTO = dataModelBaseDTO.getDataModelDtoMap().get(pgDataModelBase.getId());
            boolean isMasterTable = pgDataModelBase.getId().equals(masterTableId);
            List<PgDataModelFieldDto> modelDtoFields = pgDataModelDTO.getFields();
            String getPrimaryMethod = "";
            if (isMasterTable) {
                for (PgDataModelFieldDto field : modelDtoFields) {
                    if (!field.isKeyFlag()) continue;
                    getPrimaryMethod = "Boolean".equals(field.getPropertyType()) ? "is" + field.getCapitalName() : "get" + field.getCapitalName();
                    break;
                }
            } else {
                for (PgDataModelFieldDto field : modelDtoFields) {
                    if (!"foreign".equals(field.getFill())) continue;
                    getPrimaryMethod = "Boolean".equals(field.getPropertyType()) ? "is" + field.getCapitalName() : "get" + field.getCapitalName();
                    break;
                }
            }
            boolean logicallyFlag = false;
            PgDataModelField logicallyField = pgDataModelBase.getDeleteFlag();
            if (ToolUtil.isNotEmpty((Object)((Object)logicallyField))) {
                logicallyFlag = true;
            }
            String flagFieldName = "";
            if (logicallyFlag) {
                for (PgDataModelFieldDto field : modelDtoFields) {
                    if (!field.getId().equals(logicallyField.getId())) continue;
                    flagFieldName = field.getCapitalName();
                    break;
                }
            }
            String serviceName = pgDataModelDTO.getServiceEnName();
            List<PgDataModelField> modelTableFields = pgDataModelBase.getFields();
            boolean flag = false;
            for (PgDataModelField modelTableField : modelTableFields) {
                if (!ToolUtil.isNotEmpty((Object)((Object)modelTableField)) || !modelTableField.isChkUnique()) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("columnName", (Object)modelTableField.getName());
                for (PgDataModelFieldDto field : modelDtoFields) {
                    if (!field.getId().equals(modelTableField.getId())) continue;
                    jsonObject.put("javaType", (Object)field.getPropertyType());
                    break;
                }
                ArrayList<JSONObject> rulesList = new ArrayList<JSONObject>();
                if (modelTableField.isChkUnique()) {
                    flag = true;
                    JSONObject obj = new JSONObject();
                    obj.put("type", (Object)"unique");
                    obj.put("sourceFieldName", (Object)modelTableField.getSourceFieldName());
                    obj.put("errorMsg", (Object)(modelTableField.getName() + "\u5217\u552f\u4e00\u503c\u6821\u9a8c\u672a\u901a\u8fc7"));
                    obj.put("entityName", (Object)pgDataModelDTO.getEntityName());
                    obj.put("getPrimaryMethod", (Object)getPrimaryMethod);
                    obj.put("serviceName", (Object)serviceName);
                    obj.put("logicallyDelete", (Object)logicallyFlag);
                    obj.put("logicallyFlag", (Object)flagFieldName);
                    Map<String, Object> params = dataModelOperation.getParams();
                    List asyncVerifyParams = (List)params.get("asyncVerifyParams");
                    if (ToolUtil.isNotEmpty((Object)asyncVerifyParams)) {
                        for (JSONObject asyncVerifyParam : asyncVerifyParams) {
                            if (!ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"columnId")) || !asyncVerifyParam.get((Object)"columnId").equals(modelTableField.getId()) || !ToolUtil.isNotEmpty((Object)asyncVerifyParam.get((Object)"rules"))) continue;
                            List paramRules = (List)asyncVerifyParam.get((Object)"rules");
                            for (JSONObject paramRule : paramRules) {
                                if (!ToolUtil.isNotEmpty((Object)paramRule) || !ToolUtil.isNotEmpty((Object)paramRule.get((Object)"ruleType")) || !"unique".equals(paramRule.get((Object)"ruleType"))) continue;
                                obj.put("errorMsg", paramRule.get((Object)"errorMsg"));
                            }
                        }
                    }
                    rulesList.add(obj);
                }
                jsonObject.put("rules", rulesList);
                columnList.add(jsonObject);
            }
            if (!flag) continue;
            backCtx.addServiceImplImport(modelId, pgDataModelDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplImport(modelId, pgDataModelDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplInversion(modelId, pgDataModelDTO.getServiceName());
        }
        controllerParams.put("columnList", columnList);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5f02\u6b65\u6821\u9a8c");
        backCtx.addApi(modelId, PgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, String modelId, PgFlowMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
    }
}

