/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.element.masterslave;

import com.google.common.base.CaseFormat;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlTransUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipBase;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.task.PgTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataModelUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ResultMapUtil {
    protected static final int DEF_SB_SIZE = 128;
    private static final String KEY_COLUMN = "<id column=\"${column}\" property=\"${property}\"/>\n";
    private static final String RESULT_COLUMN = "<result column=\"${column}\" property=\"${property}\" ${jdbcType} />\n";
    private static final String ASSOCIATION = "<association property=\"${property}\" javaType=\"${javaType}\">\n${associationContent}</association>\n";
    private static final String COLLECTION = "<collection property=\"${property}\" column=\"{${column}}\" ofType=\"${javaType}\" javaType=\"ArrayList\" select=\"${alias}SubSelect\" fetchType=\"eager\">\n</collection>\n";
    private static final String SUBSELECT = "<!-- \u4e00\u5bf9\u591a\u5b50\u67e5\u8be2 -->\n<select id=\"${alias}SubSelect\" resultMap=\"${subMap}\">\nSELECT\n${fieldSql!}\nFROM ${subTable!}\nWHERE ${whereSql!}\n</select>";
    private static final String SUB_MAP = "<!-- \u4e00\u5bf9\u591a\u67e5\u8be2Map -->\n<resultMap id=\"${subMap}\" type=\"${subClass}\">\n${result}</resultMap>\n";

    public static String renderResultMap(PgMsDataModel dataModelBase, Map<String, PgDataModelBaseDTO> dataModelDtoMap, Map<String, PgDataModelBase> dataModelBaseMap) {
        StringBuilder finalResult = new StringBuilder(128);
        List<PgDataModelField> baseFields = dataModelBase.getFields();
        int currIndex = -1;
        for (PgDataModelField modelFieldBase : baseFields) {
            ++currIndex;
            PgDataModelField fieldBase = modelFieldBase;
            if (!"primary".equals(fieldBase.getUsage())) continue;
            Collections.swap(baseFields, 0, currIndex);
            break;
        }
        PgDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterTableId = masterTable.getId();
        PgDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterTable.getId());
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        if (ToolUtil.isNotEmpty(baseFields)) {
            String fromModelId;
            for (PgDataModelField dataModelFieldBase : baseFields) {
                fromModelId = dataModelFieldBase.getSourceDataModelId();
                String originField = dataModelFieldBase.getSourceFieldName();
                String attrType = dataModelFieldBase.getDataType();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)aliasMap.get(fromModelId))) continue;
                finalResult.append(RESULT_COLUMN.replace("${column}", aliasMap.get(fromModelId) + dataModelFieldBase.getAttrName()).replace("${property}", dataModelFieldBase.getName()).replace("${jdbcType}", "date".equals(dataModelFieldBase.getDataType()) ? "jdbcType=\"TIMESTAMP\"" : ""));
            }
            for (PgDataModelField field : baseFields) {
                fromModelId = field.getSourceDataModelId();
                String attrType = field.getDataType();
                String attrName = field.getName();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)masterTableId) || DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)mainDataModelDto)) continue;
                PgRelationshipBase relationshipBase = ResultMapUtil.getRelation(fromModelId, dataModelBase);
                StringBuilder stringBuilder = new StringBuilder();
                PgDataModelBase dependModelBase = dataModelBaseMap.get(fromModelId);
                PgDataModelBaseDTO dependModelDto = dataModelDtoMap.get(fromModelId);
                List<PgDataModelField> dependFields = dependModelBase.getFields();
                for (PgDataModelField dependModelField : dependFields) {
                    if (!ToolUtil.isNotEmpty((Object)dependModelField.getSourceDataModelId())) continue;
                    stringBuilder.append(ResultMapUtil.handleAttr(dependModelField, aliasMap.get(fromModelId)));
                }
                if (ToolUtil.isEmpty((Object)relationshipBase) || "association".equals(relationshipBase.getRelateModelType())) {
                    finalResult.append(ASSOCIATION.replace("${property}", attrName).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${associationContent}", stringBuilder.toString()));
                    continue;
                }
                if (!"collection".equals(relationshipBase.getRelateModelType())) continue;
                String template = "${showName}=${alias}${realName},";
                StringBuilder column = new StringBuilder(128);
                for (PgRelationshipFieldBase relation : relationshipBase.getRelationships()) {
                    if ("input".equals(relation.getMode())) break;
                    String realName = "";
                    String showName = "";
                    for (PgDataModelField fieldBase1 : masterTable.getFields()) {
                        if (!StringUtils.isNotEmpty((CharSequence)fieldBase1.getSourceFieldName()) || !ToolUtil.isNotEmpty((Object)fieldBase1.getSourceDataModelId()) || !fieldBase1.getId().equals(relation.getMasterTableFieldId())) continue;
                        realName = ResultMapUtil.capitalFirst(fieldBase1.getName());
                        showName = fieldBase1.getName();
                        break;
                    }
                    column.append(template.replace("${showName}", CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, showName)).replace("${alias}", aliasMap.get(masterTableId)).replace("${realName}", realName));
                }
                finalResult.append(COLLECTION.replace("${property}", attrName).replace("${alias}", aliasMap.get(fromModelId)).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${column}", StringUtils.strip((String)column.toString(), (String)",")).replace("${collectionContent}", stringBuilder.toString()));
            }
        }
        return finalResult.toString();
    }

    public static String renderSubSelect(PgMsDataModel dataModelBase, Map<String, PgDataModelBaseDTO> dataModelDtoMap, Map<String, PgDataModelBase> dataModelBaseMap) throws LcdpException {
        StringBuilder finalResult = new StringBuilder(128);
        for (PgRelationshipBase relationship : dataModelBase.getRelationships()) {
            if (!"collection".equals(relationship.getRelateModelType())) continue;
            PgDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(relationship.getSlaveTableId());
            PgDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
            Map<String, String> aliasMap = dataModelBase.getModelAliasName();
            String alias = aliasMap.get(slaveModelBase.getId());
            String condition = ResultMapUtil.renderRelationCondition(dataModelBase.getMasterTable(), slaveModelBase, relationship.getRelationships(), alias, aliasMap.get(dataModelBase.getMasterTable().getId()));
            String subMap = ResultMapUtil.renderSubMap(slaveModelBase);
            finalResult.append(SUB_MAP.replace("${subMap}", alias + "SubResult").replace("${subClass}", slaveModelDto.getImportInfo().get("Entity")).replace("${result}", subMap));
            String subTable = slaveModelBase.getSourceDataModelName() + " " + alias;
            finalResult.append(SUBSELECT.replace("${subMap}", alias + "SubResult").replace("${alias}", alias).replace("${fieldSql!}", "*").replace("${subTable!}", subTable).replace("${whereSql!}", condition));
        }
        return finalResult.toString();
    }

    public static String renderSubMap(PgDataModelBase dataModelBase) {
        StringBuilder finalResult = new StringBuilder(128);
        List<PgDataModelField> dataModelFieldBases = dataModelBase.getFields();
        int currIndex = -1;
        for (PgDataModelField modelFieldBase : dataModelFieldBases) {
            ++currIndex;
            PgDataModelField fieldBase = modelFieldBase;
            if (!"primary".equals(fieldBase.getUsage())) continue;
            Collections.swap(dataModelFieldBases, 0, currIndex);
            break;
        }
        if (ToolUtil.isNotEmpty(dataModelFieldBases)) {
            for (PgDataModelField dataModelFieldBase : dataModelFieldBases) {
                String showModelId = dataModelFieldBase.getSourceDataModelId();
                String originField = dataModelFieldBase.getSourceFieldName();
                String attrType = dataModelFieldBase.getDataType();
                if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)attrType)) continue;
                finalResult.append(ResultMapUtil.handleSubAttr(dataModelFieldBase));
            }
        }
        return finalResult.toString();
    }

    private static String renderRelationCondition(PgDataModelBase masterDataModelBase, PgDataModelBase slaveDataModelBase, List<PgRelationshipFieldBase> relationshipFieldBases, String alias, String mainAlias) {
        StringBuilder finalCondition = new StringBuilder(128);
        String modelConditionTemplate = "${CONNECT} ${T_RE}.${RE_FIELD} ${SYMBOL} ${FIELD}";
        for (int i = 0; i < relationshipFieldBases.size(); ++i) {
            PgRelationshipFieldBase relationshipFieldBase = relationshipFieldBases.get(i);
            String connect = relationshipFieldBase.getConnect();
            if (i == 0) {
                connect = "";
            }
            String mainField = PgDataModelUtil.getModelFieldById(masterDataModelBase.getFields(), relationshipFieldBase.getMasterTableFieldId()).getName();
            String dependField = PgDataModelUtil.getModelFieldById(slaveDataModelBase.getFields(), relationshipFieldBase.getSlaveTableFieldId()).getSourceFieldName();
            String symbol = relationshipFieldBase.getSymbol();
            String field = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, mainField);
            field = "input".equals(relationshipFieldBase.getMode()) ? "'" + field + "'" : "#{" + field + "}";
            finalCondition.append(modelConditionTemplate.replace("${CONNECT}", connect).replace("${FIELD}", field).replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)symbol)).replace("${T_RE}", alias).replace("${RE_FIELD}", dependField).replace("${RE}", mainAlias)).append(" ");
        }
        return finalCondition.toString();
    }

    private static String handleAttr(PgDataModelField dataModelFieldBase, String alias) {
        StringBuilder stringBuilder = new StringBuilder();
        String attrName = dataModelFieldBase.getAttrName();
        if (ToolUtil.isNotEmpty((Object)alias)) {
            if ("primary".equals(dataModelFieldBase.getUsage())) {
                stringBuilder.append(KEY_COLUMN.replace("${column}", alias + attrName).replace("${property}", dataModelFieldBase.getName()));
            } else {
                stringBuilder.append(RESULT_COLUMN.replace("${column}", alias + attrName).replace("${property}", dataModelFieldBase.getName()).replace("${jdbcType}", "date".equals(dataModelFieldBase.getDataType()) ? "jdbcType=\"TIMESTAMP\"" : ""));
            }
        }
        return stringBuilder.toString();
    }

    private static String handleSubAttr(PgDataModelField dataModelFieldBase) {
        StringBuilder stringBuilder = new StringBuilder();
        String attrName = dataModelFieldBase.getName();
        if ("primary".equals(dataModelFieldBase.getUsage())) {
            stringBuilder.append(KEY_COLUMN.replace("${column}", dataModelFieldBase.getSourceFieldName()).replace("${property}", attrName));
        } else {
            stringBuilder.append(RESULT_COLUMN.replace("${column}", dataModelFieldBase.getSourceFieldName()).replace("${property}", attrName).replace("${jdbcType}", "date".equals(dataModelFieldBase.getDataType()) ? "jdbcType=\"TIMESTAMP\"" : ""));
        }
        return stringBuilder.toString();
    }

    public static PgRelationshipBase getRelation(String fromModelId, PgMsDataModel dataModel) {
        for (PgRelationshipBase relationship : dataModel.getRelationships()) {
            if (!fromModelId.equals(relationship.getSlaveTableId())) continue;
            return relationship;
        }
        return new PgRelationshipBase();
    }

    public static String capitalFirst(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }

    public static String renderResultMap(PgTaskMsDataModel dataModelBase, Map<String, PgDataModelBaseDTO> dataModelDtoMap, Map<String, PgDataModelBase> dataModelBaseMap) {
        StringBuilder finalResult = new StringBuilder(128);
        List<PgDataModelField> baseFields = dataModelBase.getFields();
        int currIndex = -1;
        for (PgDataModelField modelFieldBase : baseFields) {
            ++currIndex;
            PgDataModelField fieldBase = modelFieldBase;
            if (!"primary".equals(fieldBase.getUsage())) continue;
            Collections.swap(baseFields, 0, currIndex);
            break;
        }
        PgDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterTableId = masterTable.getId();
        PgDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterTable.getId());
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        if (ToolUtil.isNotEmpty(baseFields)) {
            String fromModelId;
            for (PgDataModelField dataModelFieldBase : baseFields) {
                fromModelId = dataModelFieldBase.getSourceDataModelId();
                String originField = dataModelFieldBase.getSourceFieldName();
                String attrType = dataModelFieldBase.getDataType();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)aliasMap.get(fromModelId))) continue;
                finalResult.append(RESULT_COLUMN.replace("${column}", aliasMap.get(fromModelId) + dataModelFieldBase.getAttrName()).replace("${property}", dataModelFieldBase.getName()).replace("${jdbcType}", "date".equals(dataModelFieldBase.getDataType()) ? "jdbcType=\"TIMESTAMP\"" : ""));
            }
            for (PgDataModelField field : baseFields) {
                fromModelId = field.getSourceDataModelId();
                String attrType = field.getDataType();
                String attrName = field.getName();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)masterTableId) || DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)mainDataModelDto)) continue;
                PgRelationshipBase relationshipBase = ResultMapUtil.getRelation(fromModelId, dataModelBase);
                StringBuilder stringBuilder = new StringBuilder();
                PgDataModelBase dependModelBase = dataModelBaseMap.get(fromModelId);
                PgDataModelBaseDTO dependModelDto = dataModelDtoMap.get(fromModelId);
                List<PgDataModelField> dependFields = dependModelBase.getFields();
                for (PgDataModelField dependModelField : dependFields) {
                    if (!ToolUtil.isNotEmpty((Object)dependModelField.getSourceDataModelId())) continue;
                    stringBuilder.append(ResultMapUtil.handleAttr(dependModelField, aliasMap.get(fromModelId)));
                }
                if (ToolUtil.isEmpty((Object)relationshipBase) || "association".equals(relationshipBase.getRelateModelType())) {
                    finalResult.append(ASSOCIATION.replace("${property}", attrName).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${associationContent}", stringBuilder.toString()));
                    continue;
                }
                if (!"collection".equals(relationshipBase.getRelateModelType())) continue;
                String template = "${showName}=${alias}${realName},";
                StringBuilder column = new StringBuilder(128);
                for (PgRelationshipFieldBase relation : relationshipBase.getRelationships()) {
                    if ("input".equals(relation.getMode())) break;
                    String realName = "";
                    String showName = "";
                    for (PgDataModelField fieldBase1 : masterTable.getFields()) {
                        if (!StringUtils.isNotEmpty((CharSequence)fieldBase1.getSourceFieldName()) || !ToolUtil.isNotEmpty((Object)fieldBase1.getSourceDataModelId()) || !fieldBase1.getId().equals(relation.getMasterTableFieldId())) continue;
                        realName = ResultMapUtil.capitalFirst(fieldBase1.getName());
                        showName = fieldBase1.getName();
                        break;
                    }
                    column.append(template.replace("${showName}", CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, showName)).replace("${alias}", aliasMap.get(masterTableId)).replace("${realName}", realName));
                }
                finalResult.append(COLLECTION.replace("${property}", attrName).replace("${alias}", aliasMap.get(fromModelId)).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${column}", StringUtils.strip((String)column.toString(), (String)",")).replace("${collectionContent}", stringBuilder.toString()));
            }
        }
        return finalResult.toString();
    }

    public static String renderResultMap(PgTaskDataModel dataModelBase, Map<String, PgDataModelBaseDTO> dataModelDtoMap, Map<String, PgDataModelBase> dataModelBaseMap) {
        StringBuilder finalResult = new StringBuilder(128);
        List<PgDataModelField> baseFields = dataModelBase.getFields();
        int currIndex = -1;
        for (PgDataModelField modelFieldBase : baseFields) {
            ++currIndex;
            PgDataModelField fieldBase = modelFieldBase;
            if (!"primary".equals(fieldBase.getUsage())) continue;
            Collections.swap(baseFields, 0, currIndex);
            break;
        }
        PgTaskDataModel TaskBusinessTable = dataModelBase;
        String TaskBusinessTableId = TaskBusinessTable.getId();
        PgDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(TaskBusinessTable.getId());
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        if (ToolUtil.isNotEmpty(baseFields)) {
            String fromModelId;
            for (PgDataModelField dataModelFieldBase : baseFields) {
                fromModelId = dataModelFieldBase.getSourceDataModelId();
                String originField = dataModelFieldBase.getSourceFieldName();
                String attrType = dataModelFieldBase.getDataType();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)aliasMap.get(fromModelId))) continue;
                finalResult.append(RESULT_COLUMN.replace("${column}", aliasMap.get(fromModelId) + dataModelFieldBase.getAttrName()).replace("${property}", dataModelFieldBase.getName()).replace("${jdbcType}", "date".equals(dataModelFieldBase.getDataType()) ? "jdbcType=\"TIMESTAMP\"" : ""));
            }
            for (PgDataModelField field : baseFields) {
                fromModelId = field.getSourceDataModelId();
                String attrType = field.getDataType();
                String attrName = field.getName();
                if (!ToolUtil.isNotEmpty((Object)fromModelId) || !ToolUtil.isNotEmpty((Object)TaskBusinessTableId) || DataModelFieldTypeConvert.isBaseData((String)attrType) || !ToolUtil.isNotEmpty((Object)mainDataModelDto)) continue;
                PgRelationshipBase relationshipBase = ResultMapUtil.getRelation(fromModelId, dataModelBase);
                StringBuilder stringBuilder = new StringBuilder();
                PgDataModelBase dependModelBase = dataModelBaseMap.get(fromModelId);
                PgDataModelBaseDTO dependModelDto = dataModelDtoMap.get(fromModelId);
                List<PgDataModelField> dependFields = dependModelBase.getFields();
                for (PgDataModelField dependModelField : dependFields) {
                    if (!ToolUtil.isNotEmpty((Object)dependModelField.getSourceDataModelId())) continue;
                    stringBuilder.append(ResultMapUtil.handleAttr(dependModelField, aliasMap.get(fromModelId)));
                }
                if (ToolUtil.isEmpty((Object)relationshipBase) || "association".equals(relationshipBase.getRelateModelType())) {
                    finalResult.append(ASSOCIATION.replace("${property}", attrName).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${associationContent}", stringBuilder.toString()));
                    continue;
                }
                if (!"collection".equals(relationshipBase.getRelateModelType())) continue;
                String template = "${showName}=${alias}${realName},";
                StringBuilder column = new StringBuilder(128);
                for (PgRelationshipFieldBase relation : relationshipBase.getRelationships()) {
                    if ("input".equals(relation.getMode())) break;
                    String realName = "";
                    String showName = "";
                    for (PgDataModelField fieldBase1 : TaskBusinessTable.getFields()) {
                        if (!StringUtils.isNotEmpty((CharSequence)fieldBase1.getSourceFieldName()) || !ToolUtil.isNotEmpty((Object)fieldBase1.getSourceDataModelId()) || !fieldBase1.getId().equals(relation.getMasterTableFieldId())) continue;
                        realName = ResultMapUtil.capitalFirst(fieldBase1.getName());
                        showName = fieldBase1.getName();
                        break;
                    }
                    column.append(template.replace("${showName}", CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, showName)).replace("${alias}", aliasMap.get(TaskBusinessTableId)).replace("${realName}", realName));
                }
                finalResult.append(COLLECTION.replace("${property}", attrName).replace("${alias}", aliasMap.get(fromModelId)).replace("${javaType}", dependModelDto.getImportInfo().get("Entity")).replace("${column}", StringUtils.strip((String)column.toString(), (String)",")).replace("${collectionContent}", stringBuilder.toString()));
            }
        }
        return finalResult.toString();
    }

    public static String renderSubSelect(PgTaskDataModel dataModelBase, Map<String, PgDataModelBaseDTO> dataModelDtoMap, Map<String, PgDataModelBase> dataModelBaseMap) throws LcdpException {
        StringBuilder finalResult = new StringBuilder(128);
        for (PgRelationshipBase relationship : dataModelBase.getRelationships()) {
            if (!"collection".equals(relationship.getRelateModelType())) continue;
            PgDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(relationship.getSlaveTableId());
            PgDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
            Map<String, String> aliasMap = dataModelBase.getModelAliasName();
            String alias = aliasMap.get(slaveModelBase.getId());
            String condition = ResultMapUtil.renderRelationCondition(dataModelBase, slaveModelBase, relationship.getRelationships(), alias, aliasMap.get(dataModelBase.getId()));
            String subMap = ResultMapUtil.renderSubMap(slaveModelBase);
            finalResult.append(SUB_MAP.replace("${subMap}", alias + "SubResult").replace("${subClass}", slaveModelDto.getImportInfo().get("Entity")).replace("${result}", subMap));
            String subTable = slaveModelBase.getSourceDataModelName() + " " + alias;
            finalResult.append(SUBSELECT.replace("${subMap}", alias + "SubResult").replace("${alias}", alias).replace("${fieldSql!}", "*").replace("${subTable!}", subTable).replace("${whereSql!}", condition));
        }
        return finalResult.toString();
    }

    public static PgRelationshipBase getRelation(String fromModelId, PgTaskDataModel dataModel) {
        for (PgRelationshipBase relationship : dataModel.getRelationships()) {
            if (!fromModelId.equals(relationship.getSlaveTableId())) continue;
            return relationship;
        }
        return new PgRelationshipBase();
    }
}

