/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.dataset.ValueObjectProperty;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.source.SourcePackageInfo;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.pgQueryDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.querycondition.PgQueryCondition;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.sortcondition.PgSortCondition;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.sortcondition.PgSortConditionField;
import com.jxdinfo.hussar.formdesign.pg.function.render.PgBaseRender;
import com.jxdinfo.hussar.formdesign.pg.function.visitor.constant.PgConstUtil;
import com.jxdinfo.hussar.formdesign.pg.function.visitor.masterslave.PgMsConditionFilterVisitor;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataModelUtil;
import com.jxdinfo.hussar.formdesign.pg.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLMASTER_SLAVESlaveQuery")
public class PgMsSlavePlusQueryVisitor
implements PgOperationVisitor<PgMsDataModel, PgMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgMsConditionFilterVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLMASTER_SLAVESlaveQuery";

    @Override
    public void visit(PgBackCtx<PgMsDataModel, PgMsDataModelDTO> backCtx, PgDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String slaveModelId = String.valueOf(dataModelOperation.getParams().get("slaveModelId"));
        if (HussarUtils.isEmpty((Object)slaveModelId)) {
            return;
        }
        String modelId = backCtx.getUseDataModelBase().getId();
        PgMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, PgDataModelBaseDTO> dataModelDtoMap = dataModelBaseDTO.getDataModelDtoMap();
        if (ToolUtil.isNotEmpty(dataModelDtoMap) && ToolUtil.isEmpty((Object)dataModelDtoMap.get(slaveModelId))) {
            return;
        }
        for (SourcePackageInfo sourcePackageInfo : dataModelBaseDTO.getSourcePackageInfos()) {
            if (!"object".equals(sourcePackageInfo.getDataType()) || !dataModelBaseDTO.getDataModelDtoMap().get(slaveModelId).getName().equals(sourcePackageInfo.getObjectEnName())) continue;
            return;
        }
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, backCtx.getUseDataModelBase());
        boolean isSortCondition = this.renderSort(backCtx, dataModelOperation, modelId, controllerParams, backCtx.getUseDataModelBase());
        boolean isSortOverall = false;
        boolean isPagination = (Boolean)dataModelOperation.getParams().get("isPagination");
        this.renderSelect(backCtx, dataModelOperation, modelId, dataModelBaseDTO);
        controllerParams.put("isSortOverall", isSortOverall);
        controllerParams.put("isPagination", isPagination);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams, dataModelOperation);
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), dataModelBaseDTO);
        String controllerPath = "template/pg/masterslavebackcode/slavePlusQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/pg/masterslavebackcode/slavePlusQuery/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/pg/masterslavebackcode/slavePlusQuery/service_impl.ftl";
        controllerParams.put("operationName", controllerParams.get("name"));
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/pg/masterslavebackcode/slavePlusQuery/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/pg/masterslavebackcode/slavePlusQuery/xml.ftl";
        String finalRelation = SqlReturnUtil.renderRelation(backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isSortCondition);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5b50\u8868\u5206\u9875\u67e5\u8be2");
        backCtx.addApi(modelId, PgBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderImport(PgBackCtx<PgMsDataModel, PgMsDataModelDTO> backCtx, String modelId, PgMsDataModelDTO dataModelBaseDTO, boolean isSortCondition) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Mapper"));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        if (isSortCondition) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private Map<String, Object> initParams(PgDataModelOperation dataModelOperation, PgMsDataModelDTO dataModelBaseDTO, PgMsDataModel msDataModel) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        String slaveModelId = String.valueOf(dataModelOperation.getParams().get("slaveModelId"));
        String slaveModelName = NamingStrategy.capitalFirst((String)String.valueOf(dataModelBaseDTO.getDataModelBaseMap().get(slaveModelId).getName()));
        String aliasName = msDataModel.getModelAliasName().get(slaveModelId);
        for (PgDataModelField pgDataModelField : dataModelBaseDTO.getDataModelBaseMap().get(slaveModelId).getFields()) {
            if (!"foreign".equals(pgDataModelField.getUsage())) continue;
            controllerParams.put("foreignKey", pgDataModelField.getName());
            break;
        }
        for (PgDataModelFieldDto pgDataModelFieldDto : dataModelBaseDTO.getDataModelDtoMap().get(slaveModelId).getFields()) {
            if (!"delDefFlag".equals(pgDataModelFieldDto.getFill())) continue;
            controllerParams.put("flagDelete", pgDataModelFieldDto.getPropertyName());
            break;
        }
        controllerParams.put("slaveModelName", slaveModelName);
        controllerParams.put("aliasName", aliasName);
        controllerParams.put("tableSql", dataModelBaseDTO.getDataModelBaseMap().get(slaveModelId));
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("slaveTable", dataModelBaseDTO.getDataModelDtoMap().get(slaveModelId));
        controllerParams.put("returnValue", slaveModelName);
        controllerParams.put("masterSlave", dataModelBaseDTO.getEntityName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u5b50\u8868\u5206\u9875\u67e5\u8be2");
            } else {
                dataModelOperation.setExegesis("\u5b50\u8868\u5206\u9875\u67e5\u8be2");
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void renderSelect(PgBackCtx<PgMsDataModel, PgMsDataModelDTO> backCtx, PgDataModelOperation dataModelOperation, String modelId, PgMsDataModelDTO dataModelBaseDTO) {
        String queryConditionName = dataModelOperation.getEnterParam();
        ArrayList queryFieldsList = new ArrayList();
        pgQueryDTO queryDTO = new pgQueryDTO();
        queryDTO.setFtlPath("template/pg/backcode/code/slaveDto.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("table", table);
        PgQueryCondition queryConditionSql = new PgQueryCondition();
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        if (StringUtil.isNotBlank((CharSequence)selectConditionName)) {
            List queryCondition = backCtx.getUseDataModelBase().getDataSetById(queryConditionName).getDataSetObject().getProperties();
            for (ValueObjectProperty property : queryCondition) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("queryType", property.getDataType());
                map.put("queryName", property.getName());
                queryFieldsList.add(map);
            }
            queryConditionSql = backCtx.getUseDataModelBase().getQuConBaseByName(selectConditionName);
        }
        params.put("queryFieldsList", queryFieldsList);
        params.put("queryDto", queryDTO);
        params.put("priType", dataModelBaseDTO.getKeyField().getPropertyType());
        String slaveModelId = String.valueOf(dataModelOperation.getParams().get("slaveModelId"));
        String slaveModelName = String.valueOf(dataModelBaseDTO.getDataModelBaseMap().get(slaveModelId).getName());
        String slaveDtoImportPath = dataModelBaseDTO.getPackageInfo().get("dto") + "." + NamingStrategy.capitalFirst((String)slaveModelName) + "IncrementDTO";
        queryDTO.setParams(params);
        queryDTO.setName(slaveModelName + "IncrementDTO");
        queryDTO.setEntityName(NamingStrategy.capitalFirst((String)slaveModelName) + "IncrementDTO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        DataSet dataSet = backCtx.getUseDataModelBase().getDataSetById(queryConditionSql.getFromDataSet());
        if (ToolUtil.isNotEmpty((Object)dataSet)) {
            List<PgQueryFieldDTO> queryVOFields = PgDataModelUtil.addQueryVOField(dataSet.getDataSetObject().getProperties(), queryDTO);
            for (PgQueryFieldDTO queryVOField : queryVOFields) {
                queryDTO.addVOField(queryVOField);
            }
        }
        dataModelBaseDTO.addQueryDto(queryDTO);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addControllerImport(modelId, slaveDtoImportPath);
        backCtx.addServiceImplImport(modelId, slaveDtoImportPath);
        backCtx.addServiceImport(modelId, slaveDtoImportPath);
        backCtx.addMapperImport(modelId, slaveDtoImportPath);
    }

    private boolean renderSort(PgBackCtx<PgMsDataModel, PgMsDataModelDTO> backCtx, PgDataModelOperation dataModelOperation, String modelId, Map<String, Object> controllerParams, PgMsDataModel useDataModelBase) {
        PgSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(PgSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            for (PgSortConditionField field : sortCondition.getFields()) {
                field.setFromModelFieldSort(PgDataModelUtil.camelToUnderLine(field.getFromModelFieldSort()));
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", PgConstUtil.TRUE);
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            return true;
        }
        return false;
    }

    private void renderPageVo(PgBackCtx<PgMsDataModel, PgMsDataModelDTO> backCtx, String modelId, PgMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams, PgDataModelOperation dataModelOperation) {
        PgDataModelUtil.addSlaveQueryPageVo(dataModelBaseDTO, dataModelOperation);
        String slaveVoEntityName = dataModelBaseDTO.getEntityName() + PgDataModelUtil.SLAVE_PAGE_VO;
        String slaveVoImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + slaveVoEntityName;
        String slaveModelId = String.valueOf(dataModelOperation.getParams().get("slaveModelId"));
        String slaveModelName = NamingStrategy.capitalFirst((String)String.valueOf(dataModelBaseDTO.getDataModelBaseMap().get(slaveModelId).getName()));
        String slaveModelImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + slaveModelName + "VO";
        String sModelImportPath = dataModelBaseDTO.getPackageInfo().get("Entity") + "." + slaveModelName;
        controllerParams.put("svo", slaveVoEntityName);
        controllerParams.put("svoPath", slaveVoImportPath);
        controllerParams.put("sPath", slaveModelImportPath);
        backCtx.addControllerImport(modelId, slaveVoImportPath);
        backCtx.addServiceImport(modelId, slaveVoImportPath);
        backCtx.addServiceImplImport(modelId, slaveVoImportPath);
        backCtx.addControllerImport(modelId, slaveModelImportPath);
        backCtx.addServiceImport(modelId, slaveModelImportPath);
        backCtx.addServiceImplImport(modelId, slaveModelImportPath);
        backCtx.addMapperImport(modelId, slaveModelImportPath);
        backCtx.addMapperImport(modelId, sModelImportPath);
        backCtx.addServiceImplImport(modelId, sModelImportPath);
    }
}

