/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.render;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.PrefixUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.PgCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.AspectGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.EntityGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.MapperGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.ServiceImplGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgRender;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.pgQueryDTO;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataSourceUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLBASERENDER")
public class PgBaseRender
implements PgRender<PgBaseDataModel, PgBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgBaseRender.class);
    public static final String RENDER = "POSTGRE_SQLBASERENDER";

    @Override
    public List<PgCodeGenerateInfo> renderCode(PgBackCtx<PgBaseDataModel, PgBaseDataModelDTO> backCtx) throws LcdpException, IOException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<PgCodeGenerateInfo> pgCodeGenerateInfos = new ArrayList<PgCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        PgBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        pgCodeGenerateInfos.add(this.genEntityCode(dataModelBaseDTO));
        pgCodeGenerateInfos.add(this.genVoCode(dataModelBaseDTO));
        pgCodeGenerateInfos.add(this.genControllerCode(dataModelBaseDTO));
        pgCodeGenerateInfos.add(this.genServiceCode(dataModelBaseDTO));
        pgCodeGenerateInfos.add(this.genServiceImplCode(dataModelBaseDTO));
        pgCodeGenerateInfos.add(this.genMapperCode(dataModelBaseDTO));
        pgCodeGenerateInfos.add(this.genXmlCode(dataModelBaseDTO));
        pgCodeGenerateInfos.add(this.genApiCode(dataModelBaseDTO, baseFile));
        Map<String, pgQueryDTO> queryDtoMap = dataModelBaseDTO.getQueryDtoMap();
        if (ToolUtil.isNotEmpty(queryDtoMap)) {
            for (Map.Entry<String, pgQueryDTO> queryDTOEntry : queryDtoMap.entrySet()) {
                pgQueryDTO queryDTO = queryDTOEntry.getValue();
                PgCodeGenerateInfo queryCodeGenerateInfo = this.dynamicModelCode(queryDTO, dataModelBaseDTO);
                if (null == queryCodeGenerateInfo) continue;
                pgCodeGenerateInfos.add(queryCodeGenerateInfo);
            }
        }
        Map<String, AspectGenerateInfo> aspectGenerateInfoMap = dataModelBaseDTO.getAspectGenerateInfoMap();
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getAnnotationNames()) && ToolUtil.isNotEmpty(aspectGenerateInfoMap)) {
            for (String annotationName : dataModelBaseDTO.getAnnotationNames()) {
                pgCodeGenerateInfos.add(this.genAnnotationCode(dataModelBaseDTO, annotationName));
                AspectGenerateInfo aspectGenerateInfo = Optional.ofNullable(aspectGenerateInfoMap.get(aspectGenerateInfoMap.keySet().stream().filter(key -> key.equals(annotationName)).findFirst().orElse(""))).orElseGet(AspectGenerateInfo::new);
                pgCodeGenerateInfos.add(this.genAspectCode(dataModelBaseDTO, annotationName, aspectGenerateInfo));
            }
        }
        return pgCodeGenerateInfos;
    }

    private PgCodeGenerateInfo genEntityCode(PgBaseDataModelDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "model" + File.separator + dataModelBaseDTO.getEntityName() + ".java";
        String filePath = "template/pg/backcode/code/entity.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getEntityName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getEntityGenerateInfo())) {
            EntityGenerateInfo entityGenerateInfo = new EntityGenerateInfo();
            entityGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setEntityGenerateInfo(entityGenerateInfo);
        } else {
            dataModelBaseDTO.getEntityGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("entity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getEntityName() + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genVoCode(PgBaseDataModelDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "VO".toLowerCase() + File.separator + dataModelBaseDTO.getVoName() + ".java";
        String filePath = "template/pg/backcode/code/vo.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getVoName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getVoGeneratorInfo())) {
            VoGeneratorInfo info = new VoGeneratorInfo();
            info.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setVoGeneratorInfo(info);
        } else {
            dataModelBaseDTO.getVoGeneratorInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("queryEntity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getVoName() + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genControllerCode(PgBaseDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Controller".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Controller" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getControllerName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getControllerGenerateInfo())) {
            ControllerGenerateInfo controllerGenerateInfo = new ControllerGenerateInfo();
            controllerGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setControllerGenerateInfo(controllerGenerateInfo);
        } else {
            dataModelDto.getControllerGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getControllerGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(dataModelDto.getImportInfo().get("Entity"));
        imports.add(dataModelDto.getImportInfo().get("Service"));
        dataModelDto.getControllerGenerateInfo().setImports(imports);
        String filePath = "template/pg/backcode/code/controller.ftl";
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(PrefixUtil.replacePrefix((String)newCode));
        codeGenerateInfo.setFileType("controller");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getControllerName() + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genServiceCode(PgBaseDataModelDTO dataModelDto) throws LcdpException, IOException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Service" + ".java";
        String filePath = "template/pg/backcode/code/service.ftl";
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("service");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Service" + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genServiceImplCode(PgBaseDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl" + File.separator + dataModelDto.getEntityName() + "ServiceImpl" + ".java";
        String filePath = "template/pg/backcode/code/service_impl.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getServiceImplGenerateInfo())) {
            ServiceImplGenerateInfo serviceImplGenerateInfo = new ServiceImplGenerateInfo();
            serviceImplGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setServiceImplGenerateInfo(serviceImplGenerateInfo);
        } else {
            dataModelDto.getServiceImplGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getServiceImplGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(PgDataSourceUtil.getDataSourceServiceImpl(dataModelDto.getDataSourceName()));
        imports.add("java.util.List");
        imports.add("java.util.Map");
        imports.add("com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
        imports.add("com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        dataModelDto.getServiceImplGenerateInfo().setImports(imports);
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("serviceImpl");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "ServiceImpl" + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genMapperCode(PgBaseDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".java";
        String filePath = "template/pg/backcode/code/mapper.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getMapperName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getMapperGenerateInfo())) {
            MapperGenerateInfo mapperGenerateInfo = new MapperGenerateInfo();
            mapperGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setMapperGenerateInfo(mapperGenerateInfo);
        } else {
            dataModelDto.getMapperGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("mapper");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".java");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genXmlCode(PgBaseDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + "mapping" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".xml";
        String filePath = "template/pg/backcode/code/xml.ftl";
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("xml");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".xml");
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo dynamicModelCode(pgQueryDTO queryDTO, PgDataModelBaseDTO dataModelDto) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryDTO)) {
            String writePath = queryDTO.getWriteFilePath();
            String filePath = queryDTO.getFtlPath();
            String newCode = RenderUtil.renderTemplate((String)filePath, queryDTO.getParams());
            PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(queryDTO.getEntityName());
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private PgCodeGenerateInfo genAnnotationCode(PgBaseDataModelDTO dataModelDto, String annotationName) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "annotation" + File.separator + annotationName + ".java";
        String filePath = "template/pg/backcode/code/annotation.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("annotation");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(annotationName);
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genApiCode(PgBaseDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/pg/preview/api/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genPreviewApiCode(PgBaseDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/pg/preview/api/api-file.ftl";
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private PgCodeGenerateInfo genAspectCode(PgBaseDataModelDTO dataModelDto, String annotationName, AspectGenerateInfo aspectGenerateInfo) throws LcdpException {
        String aspectName = annotationName + NamingStrategy.capitalFirst((String)"aspect");
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "aspect" + File.separator + aspectName + ".java";
        String filePath = "template/pg/backcode/code/aspect.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("aspectName", aspectName);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        params.put("aspect", aspectGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("aspect");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(aspectName);
        return codeGenerateInfo;
    }

    public static String renderTemplate(String templatePath, ApiGenerateInfo apiGenerateInfo) throws LcdpException {
        HashMap<String, ApiGenerateInfo> params = new HashMap<String, ApiGenerateInfo>();
        params.put("api", apiGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }
}

