/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.element.customview;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.pg.function.PgEnclosure;
import com.jxdinfo.hussar.formdesign.pg.function.PgRender;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.querycondition.PgQueryCondition;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.querycondition.PgQueryObject;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.sortcondition.PgSortCondition;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.sortcondition.PgSortConditionField;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PgCustomViewModel
extends PgDataModelBase {
    private static final Logger logger = LoggerFactory.getLogger(PgDataModelBase.class);
    public static final String FUNCTION_TYPE = "CUSTOM_VIEW";
    private String viewSql;
    public static final Logger LOGGER = LoggerFactory.getLogger(PgBaseDataModel.class);
    private String sourceDataModelName;
    private List<PgQueryCondition> queryConditions;
    private List<PgQueryObject> queryObject;
    private List<PgSortCondition> sortCondition;
    private List<PgDataModelField> addFields;
    private List<PgDataModelField> delFields;
    private List<PgDataModelField> editFields;

    public String getViewSql() {
        return this.viewSql;
    }

    public void setViewSql(String viewSql) {
        this.viewSql = viewSql;
    }

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"POSTGRE_SQL.CUSTOM_VIEW", PgCustomViewModel.class);
    }

    @Override
    public PgCustomViewModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        PgCustomViewModel customSqlModel;
        try {
            customSqlModel = (PgCustomViewModel)JSONObject.parseObject((String)jsonObject.toString(), PgCustomViewModel.class);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return customSqlModel;
    }

    public PgEnclosure enclosure() throws LcdpException {
        return null;
    }

    public PgRender render() throws LcdpException {
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    public List<PgQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<PgQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<PgQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<PgQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<PgSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (PgSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (PgSortConditionField field : condition.getFields()) {
                    try {
                        Map<String, String> fieldMap = PgDataModelUtil.transfer(DataModelUtil.getDataModelBase((String)field.getFromModelIdSort())).getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName));
                        String fieldName = fieldMap.get(field.getFromModelFieldIdSort());
                        if (HussarUtils.equals((Object)fieldName, (Object)field.getFromModelFieldSort())) continue;
                        field.setFromModelFieldSort(fieldName);
                    }
                    catch (LcdpException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<PgSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    public List<PgDataModelField> getAddFields() {
        return this.addFields;
    }

    public void setAddFields(List<PgDataModelField> addFields) {
        this.addFields = addFields;
    }

    public List<PgDataModelField> getDelFields() {
        return this.delFields;
    }

    public void setDelFields(List<PgDataModelField> delFields) {
        this.delFields = delFields;
    }

    public List<PgDataModelField> getEditFields() {
        return this.editFields;
    }

    public void setEditFields(List<PgDataModelField> editFields) {
        this.editFields = editFields;
    }

    @Override
    public PgQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (PgQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return new PgQueryCondition();
    }

    @Override
    public PgSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (PgSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return new PgSortCondition();
    }
}

