/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.util;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlTransUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipBase;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SqlReturnUtil {
    protected static final int DEF_SB_SIZE = 128;

    public static String renderReturn(PgMsDataModel dataModel, Map<String, String> aliasMap) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        List<PgDataModelField> dataModelFieldBases = dataModel.getFields();
        for (PgDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static void renderAlias(PgMsDataModel dataModel, Map<String, String> aliasMap, PgDataModelBaseDTO dataModelBaseDTO) {
        String template = "${alias}.${attrReal}";
        List<PgDataModelField> dataModelFieldBases = dataModel.getFields();
        List<PgDataModelFieldDto> dataModelFieldDtos = dataModelBaseDTO.getFields();
        for (PgDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            for (PgDataModelFieldDto dataModelFieldDto : dataModelFieldDtos) {
                if (dataModelFieldDto.getName() == null || !dataModelFieldDto.getId().equals(dataModelFieldBase.getId())) continue;
                dataModelFieldDto.setAliasName(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField));
            }
        }
    }

    public static String renderRelation(PgMsDataModel dataModelBase, Map<String, PgDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<PgRelationshipBase> relationships = dataModelBase.getRelationships();
        PgDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        if (ToolUtil.isNotEmpty((Object)masterId)) {
            String mainModel = masterTable.getSourceDataModelName();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterId)));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (PgRelationshipBase relationship : relationships) {
                if (!"association".equals(relationship.getRelateModelType())) continue;
                PgDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveModelBase.getSourceDataModelName().toUpperCase();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), dataModelBase, alias, "and", modelAlias.get(masterId), slaveModelBase);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderTotalCalculateRelation(PgMsDataModel dataModelBase, Map<String, PgDataModelBase> dataModelBaseMap, Map<String, Object> controllerParams) {
        boolean isPaired = false;
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<PgRelationshipBase> relationships = dataModelBase.getRelationships();
        PgDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        if (ToolUtil.isNotEmpty((Object)masterId)) {
            String mainModel = masterTable.getSourceDataModelName().toUpperCase();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterId)));
            controllerParams.put("Alias", modelAlias.get(masterId));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (PgRelationshipBase relationship : relationships) {
                if (!"association".equals(relationship.getRelateModelType())) continue;
                PgDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveModelBase.getSourceDataModelName().toUpperCase();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), dataModelBase, alias, "and", modelAlias.get(masterId), slaveModelBase);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (ToolUtil.isNotEmpty((Object)condition)) {
                    relationResult.append("ON\n").append(condition);
                }
                isPaired = true;
            }
        }
        controllerParams.put("isPaired", isPaired);
        return relationResult.toString();
    }

    private static String renderRelationCondition(List<PgRelationshipFieldBase> relationshipFieldBases, PgMsDataModel dataModelBase, String alias, String lastConnect, String mainAlias, PgDataModelBase slaveModelBase) {
        StringBuilder finalCondition = new StringBuilder(128);
        String slaveModelBaseId = slaveModelBase.getId();
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        for (int i = 0; i < relationshipFieldBases.size(); ++i) {
            PgRelationshipFieldBase relationshipFieldBase = relationshipFieldBases.get(i);
            String connect = lastConnect;
            if (i == 0) {
                connect = "";
            }
            PgDataModelBase masterTable = dataModelBase.getMasterTable();
            PgDataModelBase slaveTables = null;
            List<PgDataModelBase> slaveTableList = dataModelBase.getSlaveTables();
            String masterTableFieldId = relationshipFieldBase.getMasterTableFieldId();
            String mainField = null;
            String slaveTableFieldId = relationshipFieldBase.getSlaveTableFieldId();
            for (PgDataModelBase pgDataModelBase : slaveTableList) {
                if (!slaveModelBaseId.equals(pgDataModelBase.getId())) continue;
                slaveTables = pgDataModelBase;
                break;
            }
            String dependField = null;
            for (PgDataModelField field : masterTable.getFields()) {
                if (!masterTableFieldId.equals(field.getId())) continue;
                mainField = field.getSourceFieldName();
                break;
            }
            for (PgDataModelField field : slaveTables.getFields()) {
                if (!slaveTableFieldId.equals(field.getId())) continue;
                dependField = field.getSourceFieldName();
                break;
            }
            String string = relationshipFieldBase.getSymbol();
            String connectSym = relationshipFieldBase.getConnect();
            finalCondition.append(conditionTemplate.replace("${CONNECT}", connect).replace("${FIELD}", StringUtils.isNotBlank((CharSequence)mainField) ? mainField : "").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)string)).replace("${T_RE}", alias).replace("${RE_FIELD}", StringUtils.isNotBlank((CharSequence)dependField) ? dependField : "").replace("${RE}", mainAlias));
            lastConnect = connectSym;
        }
        return finalCondition.toString();
    }
}

