/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.PropertyType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.dataset.ValueObjectProperty;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.function.PgModelFunction;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.pgQueryDTO;
import com.jxdinfo.hussar.formdesign.pg.util.PgModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class PgDataModelUtil {
    public static String PAGE_VO = "PageVO";

    public static PgDataModelBase transfer(DataModelBase dataModelBase) throws LcdpException {
        PgModelFunction modelFunction = PgModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        return modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)dataModelBase.getId()));
    }

    public static PgDataModelBase transfer(String jsonData) throws LcdpException {
        DataModelBase dataModel = (DataModelBase)JSONObject.parseObject((String)jsonData, DataModelBase.class);
        PgModelFunction modelFunction = PgModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        return modelFunction.parseDataModel(JSONObject.parseObject((String)jsonData));
    }

    public static PgDataModelField getModelFieldById(List<PgDataModelField> fields, String fieldId) {
        return fields.stream().filter(field -> field.getId().equals(fieldId)).findFirst().orElseGet(PgDataModelField::new);
    }

    public static void addQueryPageVo(PgDataModelBaseDTO dataModelBaseDTO) {
        pgQueryDTO queryDTO = new pgQueryDTO();
        queryDTO.setFtlPath("template/pg/backcode/code/page.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }

    public static void addQueryPageViewVo(PgDataModelBaseDTO dataModelBaseDTO) {
        PgDataModelUtil.addQueryPageVo(dataModelBaseDTO);
    }

    public static void addQueryPageMsVo(PgDataModelBaseDTO msdataModelBaseDTO) {
        PgDataModelUtil.addQueryPageVo(msdataModelBaseDTO);
    }

    public static pgQueryDTO getQueryDto(DataSet dataSet, PgDataModelBaseDTO dataModelDTO) {
        pgQueryDTO queryDto;
        block4: {
            block3: {
                queryDto = new pgQueryDTO();
                queryDto.setId(dataSet.getId());
                queryDto.setName(EnclosureUtil.processName((String)dataSet.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
                queryDto.setComment(dataSet.getComment());
                Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
                queryDto.setPackageInfo(packageInfo.get("dto"));
                queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataSet.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
                queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
                queryDto.setFtlPath("template/pg/backcode/code/queryDto.ftl");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("queryDto", queryDto);
                queryDto.setParams(params);
                queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
                if (!dataSet.getDataSetObject().getObjectType().equals(ComponentData.DataSetObjectTypeEnum.DATA_MODEL.getValue())) break block3;
                queryDto.setDataModel(true);
                if (!ToolUtil.isNotEmpty(dataModelDTO.getFields())) break block4;
                for (PgDataModelFieldDto field : dataModelDTO.getFields()) {
                    PgQueryFieldDTO queryVOFieldDto = new PgQueryFieldDTO();
                    queryVOFieldDto.setComment(field.getComment());
                    queryVOFieldDto.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)field.getColumnType().getType()));
                    queryVOFieldDto.setPropertyName(field.getName());
                    queryDto.addVOField(queryVOFieldDto);
                }
                break block4;
            }
            if (ToolUtil.isNotEmpty((Object)dataSet.getDataSetObject().getProperties())) {
                List<PgQueryFieldDTO> queryVOFields = PgDataModelUtil.addQueryVOField(dataSet.getDataSetObject().getProperties(), queryDto);
                for (PgQueryFieldDTO queryVOField : queryVOFields) {
                    queryDto.addVOField(queryVOField);
                }
            }
        }
        return queryDto;
    }

    public static pgQueryDTO getFilterDto(PgDataModelBaseDTO dataModelDTO) {
        pgQueryDTO queryDto = new pgQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setImports(Collections.singleton(dataModelDTO.getImportInfo().get("Entity")));
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        queryDto.setFtlPath("template/pg/backcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryDto", queryDto);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    public static pgQueryDTO getTotalQueryDto(PgDataModelBaseDTO dataModelDTO) {
        pgQueryDTO queryDto = new pgQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelDTO.getName() + "TotalQuery"), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setFtlPath("template/backcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("queryDto", queryDto);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    private static List<PgQueryFieldDTO> addQueryVOField(List<ValueObjectProperty> properties, pgQueryDTO queryDto) {
        ArrayList<PgQueryFieldDTO> children = new ArrayList<PgQueryFieldDTO>();
        for (ValueObjectProperty property : properties) {
            PgQueryFieldDTO queryVOFieldDto = new PgQueryFieldDTO();
            queryVOFieldDto.setComment(property.getComment());
            queryVOFieldDto.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)property.getBaseDataType()));
            queryVOFieldDto.setType(property.getBaseDataType());
            queryVOFieldDto.setPropertyName(property.getName());
            if (ToolUtil.isNotEmpty((Object)property.getProperties())) {
                queryVOFieldDto.setChildren(PgDataModelUtil.addQueryVOField(property.getProperties(), queryDto));
            }
            children.add(queryVOFieldDto);
            if (null == queryVOFieldDto.getDbColumnType() || null == queryVOFieldDto.getDbColumnType().getImportT()) continue;
            queryDto.addImport(queryVOFieldDto.getDbColumnType().getImportT());
        }
        return children;
    }

    public static PropertyType getEntityPropertyType(String type, PgDataModelBaseDTO dataModelDto) {
        PropertyType propertyType = null;
        if (ToolUtil.isNotEmpty((Object)type)) {
            propertyType = new PropertyType();
            propertyType.setImportT(dataModelDto.getImportInfo().get("Entity"));
            String modelName = dataModelDto.getEntityName();
            if (type.equals("array")) {
                propertyType.setType("List<${model}>".replace("${model}", modelName));
            } else if (type.equals("object")) {
                propertyType.setType(modelName);
            }
        }
        return propertyType;
    }

    public static ContrastVO<PgDataModelField> contrastWith(List<TableField> tableFields, List<PgDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        List<Object> addFields = new ArrayList();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<PgDataModelField> delFields = new ArrayList<PgDataModelField>();
        ArrayList<PgDataModelField> modifyFields = new ArrayList<PgDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && (tableFields.get(j).getDataLength() == -1 || modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength()) && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot() && HussarUtils.equals((Object)modelFields.get(i).getComment(), (Object)tableFields.get(j).getComment()) && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(PgDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        addFields = PgDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<PgDataModelField> pushContrastWith(List<TableField> tableFields, List<PgDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        List<Object> addFields = new ArrayList();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<PgDataModelField> delFields = new ArrayList<PgDataModelField>();
        ArrayList<PgDataModelField> modifyFields = new ArrayList<PgDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().toUpperCase().equals(tableFields.get(j).getName().toUpperCase())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(PgDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        addFields = PgDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<PgDataModelField> contrastWithView(List<TableField> tableFields, List<PgDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<PgDataModelField> delFields = new ArrayList<PgDataModelField>();
        ArrayList<PgDataModelField> modifyFields = new ArrayList<PgDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equalsIgnoreCase(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && (tableFields.get(j).getDataLength() == -1 || modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength()) && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot()) break;
                modifyFields.add(PgDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<PgDataModelField> addFields = PgDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<PgDataModelField> contrastWithIgnoreCase(List<TableField> tableFields, List<PgDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<PgDataModelField> delFields = new ArrayList<PgDataModelField>();
        ArrayList<PgDataModelField> modifyFields = new ArrayList<PgDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && (tableFields.get(j).getDataLength() == -1 || modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength()) && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot()) break;
                modifyFields.add(PgDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        List<PgDataModelField> addFields = PgDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<PgDataModelField> mcontrastWith(List<TableField> tableFields, List<PgDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<PgDataModelField> addFields = new ArrayList<PgDataModelField>();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<PgDataModelField> modifyFields = new ArrayList<PgDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!modelFields.get(i).getSourceFieldName().equals(tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().equalsIgnoreCase(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && (tableFields.get(j).getDataLength() == -1 || modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength()) && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot() && HussarUtils.equals((Object)modelFields.get(i).getComment(), (Object)tableFields.get(j).getComment()) && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(modelFields.get(i));
            }
            if (flag) continue;
            addFields.add(modelFields.get(i));
        }
        List<PgDataModelField> delFields = PgDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static List<PgDataModelField> tabTransmodel(List<TableField> tableFields) {
        ArrayList<PgDataModelField> modelFields = new ArrayList<PgDataModelField>();
        tableFields.forEach(tab -> {
            PgDataModelField field = new PgDataModelField();
            field.setSourceFieldName(tab.getName());
            field.setDataIsEmpty(tab.getDataIsEmpty());
            field.setDataLength(tab.getDataLength());
            field.setDataDot(tab.getDataDot());
            field.setComment(tab.getComment());
            field.setSourceDataType(tab.getType().toUpperCase());
            if ("PRI".equals(tab.getPrimarys())) {
                field.setUsage("primary");
            }
            modelFields.add(field);
        });
        return modelFields;
    }

    public static PgDataModelField tabTransmodelOne(TableField tableFields, String id) {
        PgDataModelField field = new PgDataModelField();
        field.setId(id);
        field.setSourceFieldName(tableFields.getName());
        field.setDataIsEmpty(tableFields.getDataIsEmpty());
        field.setDataLength(tableFields.getDataLength());
        field.setDataDot(tableFields.getDataDot());
        field.setComment(tableFields.getComment());
        if ("PRI".equals(tableFields.getPrimarys())) {
            field.setUsage("primary");
        }
        field.setSourceDataType(tableFields.getType().toUpperCase());
        return field;
    }
}

