/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.flow.masterslaveflow.util;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgFlowMsUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx) throws LcdpException {
        PgFlowMsUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx) throws LcdpException {
        PgFlowMsUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        PgMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        PgMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        PgDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<PgRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        PgDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        if (params.get("logicallyDelete") != null) {
            for (PgRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.init();
            }
        } else {
            for (PgRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = PgFlowMsUtil.getDelStr(relationshipDtoList, masterDto);
        PgFlowMsUtil.renderTransaction(backCtx, params, currentModelId);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (PgRelationshipDTO pgRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            PgDataModelBaseDTO pgDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(pgRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, pgDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, pgDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, pgDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        PgMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        PgMsDataModelDTO pgMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<PgRelationshipDTO> relationshipDtoList = pgMsDataModelDTO.getRelationshipDtoList();
        PgDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, PgDataModelBaseDTO> dataModelDtoMap = pgMsDataModelDTO.getDataModelDtoMap();
        PgDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        PgFlowMsUtil.renderTransaction(backCtx, controllerParams, modelId);
        String masterFillCode = PgFlowMsUtil.renderFillCode(mainDataModelDto, pgMsDataModelDTO);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            for (PgRelationshipDTO relationshipDTO : relationshipDtoList) {
                List<PgRelationshipFieldDTO> pgRelationshipFieldDTOS;
                String slaveTableId = relationshipDTO.getSlaveTableId();
                String relateModelType = relationshipDTO.getRelateModelType();
                PgDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = PgFlowMsUtil.renderFillCode(slaveModelDto, pgMsDataModelDTO);
                if (slaveFillCode != null) {
                    relationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(pgRelationshipFieldDTOS = relationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private static void renderTransaction(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams, String modelId) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(PgDataModelBaseDTO dataModelBaseDTO, PgMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (PgDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": 
                case "companyId": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/pg/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<PgRelationshipDTO> relationshipDtoList, PgDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (PgRelationshipDTO relationtMap : relationshipDtoList) {
            List<PgRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            PgRelationshipFieldDTO pgRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDTO.getSlaveFieldCap()).append(",idList));\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                PgRelationshipFieldDTO pgRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(pgRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(pgRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(PgFlowMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(pgRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(pgRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(PgFlowMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(pgRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }
}

