/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.flow.PgFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.visitor.constant.PgConstUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLFLOW_MASTER_SLAVEFormSave")
public class PgMsFlolwFormSaveVisitor
implements PgOperationVisitor<PgFlowMsDataModel, PgFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgMsFlolwFormSaveVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLFLOW_MASTER_SLAVEFormSave";

    @Override
    public void visit(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, PgDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        PgMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        PgMsDataModelDTO pgMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = pgMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        PgDataModelFieldDto keyField = pgMsDataModelDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", pgMsDataModelDTO);
        controllerParams.put("returnValue", pgMsDataModelDTO.getEntityName());
        controllerParams.put("url", url);
        PgDataModelBaseDTO masterBaseDto = pgMsDataModelDTO.getDataModelDtoMap().get(dataModelBase.getMasterTable().getId());
        controllerParams.put("masterTable", masterBaseDto);
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(pgMsDataModelDTO.getComment() + "\u65b0\u589e\u6216\u4fee\u6539");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/pg/flowbackcode/masterslaveflowbackcode/formsave/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, pgMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, pgMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerInversion(modelId, pgMsDataModelDTO.getServiceName());
        String servicePath = "template/pg/flowbackcode/masterslaveflowbackcode/formsave/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        this.masterSlaveCode(backCtx, controllerParams);
        controllerParams.put("primaryField", keyField.getCapitalName());
        String serviceImplPath = "template/pg/flowbackcode/masterslaveflowbackcode/formsave/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", url, "\u65b0\u589e\u6216\u4fee\u6539");
        backCtx.addApi(modelId, PgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void masterSlaveCode(PgBackCtx<PgFlowMsDataModel, PgFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        PgMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        PgMsDataModelDTO pgMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<PgRelationshipDTO> relationshipDtoList = pgMsDataModelDTO.getRelationshipDtoList();
        PgDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, PgDataModelBaseDTO> dataModelDtoMap = pgMsDataModelDTO.getDataModelDtoMap();
        PgDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(mainDataModelDto, pgMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            for (PgRelationshipDTO relationshipDTO : relationshipDtoList) {
                List<PgRelationshipFieldDTO> relationshipFieldDTOS;
                String slaveTableId = relationshipDTO.getSlaveTableId();
                String relateModelType = relationshipDTO.getRelateModelType();
                PgDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(slaveModelDto, pgMsDataModelDTO, false, mainDataModelDto);
                if (slaveFillCode != null) {
                    relationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(relationshipFieldDTOS = relationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private String renderFillCode(PgDataModelBaseDTO dataModelBaseDTO, PgMsDataModelDTO msDataModelDTO, boolean isMs, PgDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (PgDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": 
                case "companyId": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", PgConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", PgConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", PgConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/pg/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }
}

