/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.processor;

import com.jxdinfo.hussar.formdesign.back.common.util.ApiResourceAcceptor;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.PgCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgModelFunction;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.PgRender;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.sortcondition.PgSortCondition;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.sortcondition.PgSortConditionField;
import com.jxdinfo.hussar.formdesign.pg.result.PgCodeResult;
import com.jxdinfo.hussar.formdesign.pg.util.PgCodeMergeUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataModelUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PgModelProcessor
implements DataModelProcessor<PgCodeResult> {
    private static Logger logger = LoggerFactory.getLogger(PgModelProcessor.class);

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)"POSTGRE_SQL", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<PgCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx = this.getPgBackCtx(publishCtx);
        PgModelProcessor.init(backCtx, dataModelBase);
        PgModelProcessor.generateSingleModel(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    private PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> getPgBackCtx(PublishCtx<PgCodeResult> publishCtx) {
        PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx = new PgBackCtx<PgDataModelBase, PgDataModelBaseDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        return backCtx;
    }

    public static void init(PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx, DataModelBase dataModelBase) throws IOException, LcdpException, CloneNotSupportedException {
        String modelId = dataModelBase.getId();
        PgModelFunction currentFunction = PgModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        PgDataModelBase currentModelBase = PgDataModelUtil.transfer(dataModelBase);
        List<PgSortCondition> sortConditions = currentModelBase.getSortCondition();
        if (HussarUtils.isNotEmpty(sortConditions)) {
            for (PgSortCondition sortCondition : sortConditions) {
                List<PgSortConditionField> sortConditionFields = sortCondition.getFields();
                for (PgSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName();
                }
            }
        }
        backCtx.setUseDataModelBase(currentModelBase);
        HashMap<String, PgDataModelBaseDTO> useDtoMap = new HashMap<String, PgDataModelBaseDTO>();
        useDtoMap.put(modelId, currentFunction.enclosure().enclosure(currentModelBase));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(currentModelBase.getFunctionType());
    }

    public static void generateSingleModel(PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx, PublishCtx<PgCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        PgModelProcessor.visit(backCtx);
        PgModelProcessor.render(backCtx, publishCtx);
    }

    public static void visit(PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        PgDataModelBase useDataModelBase = backCtx.getUseDataModelBase();
        PgDataModelBaseDTO modelBaseDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        for (PgDataModelOperation operation : useDataModelBase.getOperations()) {
            PgOperationVisitor<PgDataModelBase, PgDataModelBaseDTO> visitor = null;
            try {
                visitor = backCtx.getModelFunction().vistor("POSTGRE_SQL", backCtx.getModelFunctionTye(), operation.getType());
            }
            catch (LcdpException ignored) {
                logger.error("\u5f53\u524d\u6a21\u578b\u4e0d\u652f\u6301\u6b64\u65b9\u6cd5\uff0c\u6a21\u578b\u7c7b\u578b\uff1a{}\uff0c\u65b9\u6cd5\u7c7b\u578b\uff1a{}", (Object)backCtx.getModelFunctionTye(), (Object)operation.getType());
            }
            if (visitor == null) continue;
            backCtx.getModelFunction().accept(visitor, backCtx, operation);
            if (!backCtx.getUseDataModelBase().getIsPublishResource()) continue;
            backCtx.addApiResources(ApiResourceAcceptor.of((String)useDataModelBase.getId(), (String)operation.getId(), (String)operation.getName(), (String)FileUtil.posixPath((String[])new String[]{modelBaseDTO.getTablePath(), operation.getName()}), (String)operation.getName()));
        }
    }

    public static void render(PgBackCtx<PgDataModelBase, PgDataModelBaseDTO> backCtx, PublishCtx<PgCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        PgRender<PgDataModelBase, PgDataModelBaseDTO> render = backCtx.getModelFunction().render();
        List<PgCodeGenerateInfo> codeGenerateInfos = render.renderCode(backCtx);
        publishCtx.addCodeResults(PgCodeMergeUtil.mergeBack(codeGenerateInfos, backCtx));
    }
}

