/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.view;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.view.PgViewDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.view.PgViewDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLVIEWFormQuery")
public class PgViewFormQueryVisitor
implements PgOperationVisitor<PgViewDataModel, PgViewDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgViewFormQueryVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLVIEWFormQuery";

    @Override
    public void visit(PgBackCtx<PgViewDataModel, PgViewDataModelDTO> backCtx, PgDataModelOperation dataModelOperation) throws LcdpException {
        String visitorName = OPERATION_NAME;
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        PgViewDataModelDTO dataModelViewDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelViewDTO.getApiPrefix() + "/" + dataModelOperation.getName();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelViewDTO);
        controllerParams.put("returnValue", dataModelViewDTO.getEntityName());
        controllerParams.put("url", url);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelViewDTO.getComment() + "\u8868\u5355\u67e5\u8be2");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        String controllerPath = "template/pg/backcode/get/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelViewDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelViewDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(modelId, dataModelViewDTO.getServiceName());
        String servicePath = "template/pg/backcode/get/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        String serviceImplPath = "template/pg/backcode/get/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "get", url, "\u8868\u5355\u67e5\u8be2");
        backCtx.addApi(modelId, PgBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }
}

