/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.visitor.base;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgOperationVisitor;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.operation.PgDataModelOperation;
import com.jxdinfo.hussar.formdesign.pg.function.render.PgBaseRender;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLBASEFlagDeleteBatch")
public class PgFlagDeleteVisitor
implements PgOperationVisitor<PgBaseDataModel, PgBaseDataModelDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgFlagDeleteVisitor.class);
    public static final String OPERATION_NAME = "POSTGRE_SQLBASEFlagDeleteBatch";

    @Override
    public void visit(PgBackCtx<PgBaseDataModel, PgBaseDataModelDTO> backCtx, PgDataModelOperation dataModelOperation) throws LcdpException {
        LOGGER.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        PgBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        PgBaseDataModel pgBaseDataModel = backCtx.getUseDataModelBase();
        boolean isLogicallyDelete = pgBaseDataModel.getLogicallyDelete();
        Map<String, Object> flagDeleteParams = this.initParams(dataModelOperation, dataModelBaseDTO, isLogicallyDelete);
        PgDataModelFieldDto keyFieldDto = dataModelBaseDTO.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            LOGGER.error("\u6a21\u578b\u672a\u8bbe\u7f6e\u4e3b\u952e");
            return;
        }
        String controllerPath = "template/pg/backcode/flagdelete/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, flagDeleteParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/pg/backcode/flagdelete/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, flagDeleteParams));
        String serviceImplPath = "template/pg/backcode/flagdelete/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, flagDeleteParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        if (isLogicallyDelete) {
            flagDeleteParams.put("deleteFlag", pgBaseDataModel.getDeleteFlag().getSourceFieldName());
            flagDeleteParams.put("primaryKey", pgBaseDataModel.getPrimaryKey().getSourceFieldName());
            backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
            String mapperPath = "template/pg/backcode/flagdelete/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, flagDeleteParams));
            String xmlPath = "template/pg/backcode/flagdelete/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, flagDeleteParams));
        }
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isLogicallyDelete);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5220\u9664");
        backCtx.addApi(modelId, PgBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(PgBackCtx<PgBaseDataModel, PgBaseDataModelDTO> backCtx, String modelId, PgBaseDataModelDTO dataModelBaseDTO, Boolean isLogicallyDelete) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "java.util.Arrays");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        if (isLogicallyDelete.booleanValue()) {
            backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Mapper"));
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        } else {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        }
    }

    private Map<String, Object> initParams(PgDataModelOperation dataModelOperation, PgBaseDataModelDTO dataModelBaseDTO, boolean isLogicallyDelete) throws LcdpException {
        Map<String, Object> flagDeleteParams = dataModelOperation.getParams();
        flagDeleteParams.put("table", dataModelBaseDTO);
        flagDeleteParams.put("returnValue", dataModelBaseDTO.getEntityName());
        flagDeleteParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        flagDeleteParams.put("logicallyDelete", isLogicallyDelete);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u6279\u91cf\u5220\u9664");
            flagDeleteParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return flagDeleteParams;
    }
}

