/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.render;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.code.PgCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.pg.ctx.PgBackCtx;
import com.jxdinfo.hussar.formdesign.pg.function.PgRender;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.pg.function.element.baseapi.PgBaseApiDataModel;
import com.jxdinfo.hussar.formdesign.pg.util.PgBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="POSTGRE_SQLBASE_APIRENDER")
public class PgBaseApiRender
implements PgRender<PgBaseApiDataModel, PgBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(PgBaseApiRender.class);
    public static final String RENDER = "POSTGRE_SQLBASE_APIRENDER";

    @Override
    public List<PgCodeGenerateInfo> renderCode(PgBackCtx<PgBaseApiDataModel, PgBaseDataModelDTO> backCtx) throws LcdpException, IOException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<PgCodeGenerateInfo> pgCodeGenerateInfos = new ArrayList<PgCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        PgBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        pgCodeGenerateInfos.add(this.genApiCode(dataModelBaseDTO, baseFile));
        return pgCodeGenerateInfos;
    }

    private PgCodeGenerateInfo genApiCode(PgBaseDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = HussarUtils.isNotEmpty((Object)baseFile) && HussarUtils.equals((Object)"MobilePage", (Object)baseFile.getType()) ? "template/preview/api/api-mobile-file.ftl" : "template/preview/api/api-file.ftl";
        String newCode = PgBackRenderUtil.renderTemplate(filePath, dataModelDto);
        PgCodeGenerateInfo codeGenerateInfo = new PgCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }
}

