/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.element.masterslave;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.function.PgEnclosure;
import com.jxdinfo.hussar.formdesign.pg.function.PgRender;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.querycondition.PgQueryCondition;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.querycondition.PgQueryObject;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.sortcondition.PgSortCondition;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataModelUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PgMsDataModel
extends PgDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(PgMsDataModel.class);
    public static final String FUNCTION_TYPE = "MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<PgQueryCondition> queryConditions;
    private List<PgQueryObject> queryObject;
    private PgDataModelBase masterTable;
    private List<PgDataModelBase> slaveTables;
    private List<PgRelationshipBase> relationships;
    private boolean logicallyDelete;
    private List<PgSortCondition> sortCondition;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"POSTGRE_SQL.MASTER_SLAVE", PgMsDataModel.class);
    }

    @Override
    public PgMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        PgMsDataModel pgMsDataModel;
        try {
            ArrayList<PgDataModelField> fieldList = new ArrayList<PgDataModelField>();
            pgMsDataModel = (PgMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), PgMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                PgDataModelBase master = PgDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(pgMsDataModel.getName() + "Master");
                pgMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<PgDataModelBase> slaveTables = new ArrayList<PgDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    PgDataModelBase slaveTable = PgDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (PgRelationshipBase relationship : pgMsDataModel.getRelationships()) {
                    PgDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(PgBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    PgDataModelField pgDataModelField = new PgDataModelField();
                    pgDataModelField.setId(UUID.randomUUID().toString());
                    pgDataModelField.setName(dataModelBase.getName());
                    pgDataModelField.setComment(dataModelBase.getComment());
                    pgDataModelField.setSourceDataModelId(dataModelBase.getId());
                    pgDataModelField.setDataType("array");
                    fieldList.add(pgDataModelField);
                }
                pgMsDataModel.setSlaveTables(slaveTables);
            }
            pgMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return pgMsDataModel;
    }

    @Override
    public PgEnclosure<PgDataModelBase> enclosure() throws LcdpException {
        return PgModelBeanUtil.getEnclosureBean("POSTGRE_SQL", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public PgRender<PgDataModelBase, PgDataModelBaseDTO> render() throws LcdpException {
        return PgModelBeanUtil.getRenderBean("POSTGRE_SQL", FUNCTION_TYPE, "RENDER");
    }

    public PgDataModelBase getMasterTable() {
        return this.masterTable;
    }

    public void setMasterTable(PgDataModelBase masterTable) {
        this.masterTable = masterTable;
    }

    public List<PgDataModelBase> getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(List<PgDataModelBase> slaveTables) {
        this.slaveTables = slaveTables;
    }

    public List<PgRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<PgRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<PgQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<PgQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<PgQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<PgQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<PgSortCondition> getSortCondition() {
        return this.sortCondition;
    }

    public void setSortCondition(List<PgSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public boolean isLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    @Override
    public PgQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (PgQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public PgSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (PgSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return "";
    }

    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.masterTable.getId(), "T2");
        if (ToolUtil.isNotEmpty(this.relationships) && !this.relationships.isEmpty()) {
            for (int i = 0; i < this.relationships.size(); ++i) {
                PgRelationshipBase relationship = this.relationships.get(i);
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        return finalMap;
    }

    public DataSet getDataSetById(String dataSetId) {
        if (this.getDataSets() != null) {
            for (DataSet dataSet : this.getDataSets()) {
                if (!dataSet.getId().equals(dataSetId)) continue;
                return dataSet;
            }
        }
        return null;
    }

    @Override
    public List<ContrastVO<PgDataModelField>> findTableContrast() throws IOException, LcdpException {
        List<ContrastVO<PgDataModelField>> tableContrast = this.masterTable.findTableContrast();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).findTableContrast().get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<PgDataModelField>> tableContrastModel(FieldsContrastParam<PgDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<PgDataModelField>> tableContrast = this.masterTable.tableContrastModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).tableContrastModel(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<PgDataModelField>> modelContrastTable(FieldsContrastParam<PgDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<PgDataModelField>> tableContrast = this.masterTable.modelContrastTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).modelContrastTable(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.masterTable.checkTableContrast(modelId).getDetails().get(0));
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            details.add(this.slaveTables.get(i).checkTableContrast(modelId).getDetails().get(0));
        }
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<PgDataModelField> fieldsContrastParam) throws Exception {
        this.masterTable.updateTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            this.slaveTables.get(i).updateTable(fieldsContrastParam);
        }
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<PgDataModelField> fieldsContrastParam) throws Exception {
        String sql = this.masterTable.copyTableByModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            sql = sql + this.slaveTables.get(i).copyTableByModel(fieldsContrastParam);
        }
        return sql;
    }

    public PgDataModelField getDeleteFlag() {
        return this.getMasterTable().getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public PgDataModelField getPrimaryKey() {
        return this.getMasterTable().getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }
}

