/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.pg.function.element.flow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.pg.function.PgEnclosure;
import com.jxdinfo.hussar.formdesign.pg.function.PgRender;
import com.jxdinfo.hussar.formdesign.pg.function.element.base.PgBaseDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.PgMsDataModel;
import com.jxdinfo.hussar.formdesign.pg.function.element.masterslave.relationship.PgRelationshipBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBase;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.PgDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.pg.function.modelentity.field.PgDataModelField;
import com.jxdinfo.hussar.formdesign.pg.util.PgDataModelUtil;
import com.jxdinfo.hussar.formdesign.pg.util.PgModelBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PgFlowMsDataModel
extends PgMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(PgFlowMsDataModel.class);
    public static final String FUNCTION_TYPE = "FLOW_MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<PgDataModelField> flowFields;

    public List<PgDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<PgDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"POSTGRE_SQL.FLOW_MASTER_SLAVE", PgFlowMsDataModel.class);
    }

    @Override
    public PgFlowMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        PgFlowMsDataModel pgFlowMsDataModel;
        try {
            ArrayList<PgDataModelField> fieldList = new ArrayList<PgDataModelField>();
            pgFlowMsDataModel = (PgFlowMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), PgFlowMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                PgDataModelBase master = PgDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(pgFlowMsDataModel.getName() + "Master");
                pgFlowMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<PgDataModelBase> slaveTables = new ArrayList<PgDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    PgDataModelBase slaveTable = PgDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (PgRelationshipBase relationship : pgFlowMsDataModel.getRelationships()) {
                    PgDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(PgBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    PgDataModelField pgDataModelField = new PgDataModelField();
                    pgDataModelField.setId(UUID.randomUUID().toString());
                    pgDataModelField.setName(dataModelBase.getName());
                    pgDataModelField.setComment(dataModelBase.getComment());
                    pgDataModelField.setSourceDataModelId(dataModelBase.getId());
                    pgDataModelField.setDataType("array");
                    fieldList.add(pgDataModelField);
                }
                pgFlowMsDataModel.setSlaveTables(slaveTables);
            }
            pgFlowMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return pgFlowMsDataModel;
    }

    @Override
    public PgEnclosure<PgDataModelBase> enclosure() throws LcdpException {
        return PgModelBeanUtil.getEnclosureBean("POSTGRE_SQL", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public PgRender<PgDataModelBase, PgDataModelBaseDTO> render() throws LcdpException {
        return PgModelBeanUtil.getRenderBean("POSTGRE_SQL", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<PgDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<PgDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<PgDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTable((FieldsContrastParam<PgDataModelField>)fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<PgDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        return super.checkTableContrast(modelId);
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<PgDataModelField> fieldsContrastParam) throws Exception {
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<PgDataModelField> fieldsContrastParam) throws Exception {
        return super.copyTableByModel(fieldsContrastParam);
    }
}

