/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.provider;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelSyncProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class OscarModelSyncProvider
implements DataModelSyncProvider<OscarDataModelField> {
    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"OSCARSYNC", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public List<ContrastVO<OscarDataModelField>> tableContrastModel(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws LcdpException, IOException {
        OscarDataModelBase oscarDataModelBase = OscarDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)fieldsContrastParam.getModelId()));
        this.setExtFields(fieldsContrastParam, oscarDataModelBase);
        this.setSlaveTables(fieldsContrastParam, oscarDataModelBase);
        return oscarDataModelBase.tableContrastModelIn(fieldsContrastParam);
    }

    private void setFieldsType(List<ContrastVO<OscarDataModelField>> contrastVOS, OscarDataModelBase oscarDataModelBase) {
        if (AppContextUtil.isExtension() && !oscarDataModelBase.isExtension()) {
            for (ContrastVO<OscarDataModelField> contrastVO : contrastVOS) {
                List modifyFields;
                List addFields = contrastVO.getAddFields();
                if (HussarUtils.isNotEmpty((Object)addFields)) {
                    for (OscarDataModelField addField : addFields) {
                        addField.setExtension(true);
                    }
                }
                if (!HussarUtils.isNotEmpty((Object)(modifyFields = contrastVO.getModifyFields()))) continue;
                for (OscarDataModelField modelField : modifyFields) {
                    modelField.setExtension(true);
                }
            }
        }
    }

    private void setExtFields(FieldsContrastParam<OscarDataModelField> fieldsContrastParam, OscarDataModelBase oscarDataModelBase) throws LcdpException {
        JSONObject dataModelJsonExt;
        Object extFieldsObj;
        if (AppContextUtil.isExtension() && !oscarDataModelBase.isExtension() && HussarUtils.isNotEmpty((Object)(extFieldsObj = (dataModelJsonExt = DataModelUtil.getDataModelJsonExt((String)oscarDataModelBase.getId())).get((Object)"extFields")))) {
            Map extFields = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)extFieldsObj), (TypeReference)new TypeReference<Map<String, List<JSONObject>>>(){}, (Feature[])new Feature[0]);
            fieldsContrastParam.setExtFields(extFields);
        }
    }

    private Map<String, List<JSONObject>> getExtFields(OscarDataModelBase oscarDataModelBase) throws LcdpException {
        JSONObject dataModelJsonExt;
        Object extFieldsObj;
        if (AppContextUtil.isExtension() && !oscarDataModelBase.isExtension() && HussarUtils.isNotEmpty((Object)(extFieldsObj = (dataModelJsonExt = DataModelUtil.getDataModelJsonExt((String)oscarDataModelBase.getId())).get((Object)"extFields")))) {
            Map extFields = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)extFieldsObj), (TypeReference)new TypeReference<Map<String, List<JSONObject>>>(){}, (Feature[])new Feature[0]);
            return extFields;
        }
        return new HashMap<String, List<JSONObject>>();
    }

    private List<JSONObject> getExtSlaveTables(OscarDataModelBase oscarDataModelBase) throws LcdpException {
        JSONObject dataModelJsonExt;
        Object extSlaveTablesObj;
        if (AppContextUtil.isExtension() && !oscarDataModelBase.isExtension() && HussarUtils.isNotEmpty((Object)(extSlaveTablesObj = (dataModelJsonExt = DataModelUtil.getDataModelJsonExt((String)oscarDataModelBase.getId())).get((Object)"slaveTables")))) {
            return JSONObject.parseArray((String)JSONObject.toJSONString((Object)extSlaveTablesObj), JSONObject.class);
        }
        return new ArrayList<JSONObject>();
    }

    private Map<String, List<JSONObject>> getExtSlaveTableFields(OscarDataModelBase oscarDataModelBase) throws LcdpException {
        List<JSONObject> slaveTables = this.getExtSlaveTables(oscarDataModelBase);
        HashMap<String, List<JSONObject>> extSlaveTableFields = new HashMap<String, List<JSONObject>>();
        if (HussarUtils.isNotEmpty(slaveTables)) {
            for (JSONObject slaveTable : slaveTables) {
                OscarDataModelBase extSlaveTable = OscarDataModelUtil.transfer(slaveTable);
                String id = extSlaveTable.getId();
                List fields = JSONArray.parseArray((String)JSONObject.toJSONString(extSlaveTable.getFields()), JSONObject.class);
                extSlaveTableFields.put(id, fields);
            }
            return extSlaveTableFields;
        }
        return new HashMap<String, List<JSONObject>>();
    }

    private void setSlaveTables(FieldsContrastParam<OscarDataModelField> fieldsContrastParam, OscarDataModelBase oscarDataModelBase) throws LcdpException {
        JSONObject dataModelJsonExt;
        Object extSlaveTablesObj;
        if (AppContextUtil.isExtension() && !oscarDataModelBase.isExtension() && HussarUtils.isNotEmpty((Object)(extSlaveTablesObj = (dataModelJsonExt = DataModelUtil.getDataModelJsonExt((String)oscarDataModelBase.getId())).get((Object)"slaveTables")))) {
            List slaveTables = JSONObject.parseArray((String)JSONObject.toJSONString((Object)extSlaveTablesObj), JSONObject.class);
            fieldsContrastParam.setSlaveTables(slaveTables);
        }
    }

    private void setSlaveTablesFields(FieldsContrastParam<OscarDataModelField> fieldsContrastParam, OscarDataModelBase oscarDataModelBase) throws LcdpException {
        List slaveTables;
        if (AppContextUtil.isExtension() && !oscarDataModelBase.isExtension() && HussarUtils.isNotEmpty((Object)fieldsContrastParam.getSlaveTables()) && HussarUtils.isNotEmpty((Object)(slaveTables = fieldsContrastParam.getSlaveTables()))) {
            for (JSONObject slaveTable : slaveTables) {
                OscarDataModelBase extSlaveTable = OscarDataModelUtil.transfer(slaveTable);
                String id = extSlaveTable.getId();
                List fields = JSONArray.parseArray((String)JSONObject.toJSONString(extSlaveTable.getFields()), JSONObject.class);
                if (HussarUtils.isEmpty((Object)fieldsContrastParam.getExtFields())) {
                    fieldsContrastParam.setExtFields(new HashMap());
                }
                fieldsContrastParam.getExtFields().put(id, fields);
            }
        }
    }

    public List<ContrastVO<OscarDataModelField>> modelContrastTable(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws LcdpException, IOException {
        OscarDataModelBase oscarDataModelBase = OscarDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)fieldsContrastParam.getModelId()));
        this.setExtFields(fieldsContrastParam, oscarDataModelBase);
        this.setSlaveTables(fieldsContrastParam, oscarDataModelBase);
        return oscarDataModelBase.modelContrastTableIn(fieldsContrastParam);
    }

    public List<ContrastIndexVO> tableContrastModelIndex(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws LcdpException, IOException {
        OscarDataModelBase oscarDataModelBase = OscarDataModelUtil.transfer(DataModelUtil.getDataModelBase((String)fieldsContrastParam.getModelId()));
        return oscarDataModelBase.tableContrastModelIndex(fieldsContrastParam);
    }

    public List<ContrastIndexVO> modelContrastTableIndex(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws LcdpException, IOException {
        OscarDataModelBase oscarDataModelBase = OscarDataModelUtil.transfer(DataModelUtil.getDataModelBase((String)fieldsContrastParam.getModelId()));
        return oscarDataModelBase.modelContrastTableIndex(fieldsContrastParam);
    }

    public List<ContrastVO<OscarDataModelField>> findTableContrast(DataModelBase dataModelBase) throws LcdpException, IOException {
        OscarDataModelBase oscarDataModelBase = OscarDataModelUtil.transfer(dataModelBase);
        return oscarDataModelBase.findTableContrast();
    }

    public List<ContrastVO<OscarDataModelField>> findTableContrast(JSONObject jsonObject) throws LcdpException, IOException {
        OscarDataModelBase oscarDataModelBase = OscarDataModelUtil.transfer(String.valueOf(jsonObject.get((Object)"functionType")));
        return oscarDataModelBase.findTableContrast();
    }

    public PublishCheckVO checkTableContrast(DataModelBase dataModelBase, String modelId) throws LcdpException, IOException {
        OscarDataModelBase oscarDataModelBase = OscarDataModelUtil.transfer(dataModelBase);
        Map<String, List<JSONObject>> extFields = this.getExtFields(oscarDataModelBase);
        List<JSONObject> extSlaveTables = this.getExtSlaveTables(oscarDataModelBase);
        return oscarDataModelBase.checkTableContrast(modelId, extFields, extSlaveTables);
    }

    public Boolean updateTableByModel(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        OscarDataModelBase oscarDataModelBase = OscarDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)fieldsContrastParam.getModelId()));
        this.setSlaveTables(fieldsContrastParam, oscarDataModelBase);
        oscarDataModelBase.updateTable(fieldsContrastParam);
        return true;
    }

    public Boolean updateIndex(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        OscarDataModelBase oscarDataModelBase = OscarDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)fieldsContrastParam.getModelId()));
        return oscarDataModelBase.updateIndex(fieldsContrastParam);
    }

    public String copyTableByModel(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        OscarDataModelBase oscarDataModelBase = OscarDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)fieldsContrastParam.getModelId()));
        this.setSlaveTables(fieldsContrastParam, oscarDataModelBase);
        return oscarDataModelBase.copyTableByModel(fieldsContrastParam);
    }
}

