/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProviderFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarModelFunction;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.service.OscarWorkFlowVisitorServiceImpl;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OscarModelProvider
implements DataModelProvider {
    private static final Logger logger = LoggerFactory.getLogger(OscarModelProvider.class);

    @PostConstruct
    public void register() {
        ProviderFactory.register((String)"OSCAR", (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public String getApiPrefix(String modelId) throws IOException, LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        String apiPrefix = dataModelBase.getModelPath() + "/" + dataModelBase.getName();
        if (ToolUtil.isNotEmpty((Object)apiPrefix)) {
            return FileUtil.posixPath((String[])new String[]{apiPrefix});
        }
        return "";
    }

    public String getPrimaryFieldName(String modelId) throws IOException, LcdpException {
        JSONObject dataModelJson = DataModelUtil.getDataModelJson((String)modelId);
        if (ToolUtil.isEmpty((Object)dataModelJson)) {
            return "";
        }
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModelJson.getString("functionType"));
        OscarDataModelBase lrDataModelBase = modelFunction.parseDataModel(dataModelJson);
        return lrDataModelBase.getFields().stream().filter(e -> "primary".equals(e.getUsage())).findFirst().orElseGet(OscarDataModelField::new).getName();
    }

    public String getOperationNameById(String operationId, String modelId) throws IOException, LcdpException {
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        OscarDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if (ToolUtil.isNotEmpty(dataModelBase.getOperations())) {
            for (OscarDataModelOperation operation : dataModelBase.getOperations()) {
                if (!operation.getId().equals(operationId)) continue;
                return operation.getName();
            }
        }
        return "";
    }

    public List<Map<String, String>> visitorGeneration(String identityKey, String workFlowName, String modelName, String modelId, String workflowId, String oldVersion, String organId, String newOrganId) throws LcdpException, IOException, CloneNotSupportedException {
        return new OscarWorkFlowVisitorServiceImpl().visitorGeneration(identityKey, workFlowName, modelName, modelId, workflowId, oldVersion, organId, newOrganId);
    }

    public void sync(String modelId) throws LcdpException, IOException {
    }

    public List<DataModelFieldBase> getFields(String modelId) throws LcdpException {
        List<DataModelFieldBase> extSlaveFields;
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)modelId);
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        OscarDataModelBase dataModelBase = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        ArrayList<DataModelFieldBase> oscarDataModelFields = new ArrayList<DataModelFieldBase>();
        List<OscarDataModelField> fields = dataModelBase.getFields();
        List<Object> slaveTables = new ArrayList();
        OscarDataModelBase masterTable = new OscarBaseDataModel();
        if (modelFunction instanceof OscarFlowMsDataModel) {
            slaveTables = ((OscarFlowMsDataModel)dataModelBase).getSlaveTables();
            masterTable = ((OscarFlowMsDataModel)dataModelBase).getMasterTable();
        } else if (modelFunction instanceof OscarMsDataModel) {
            slaveTables = ((OscarMsDataModel)dataModelBase).getSlaveTables();
            masterTable = ((OscarMsDataModel)dataModelBase).getMasterTable();
        }
        if (ToolUtil.isNotEmpty(fields)) {
            oscarDataModelFields.addAll(fields);
            oscarDataModelFields.addAll(this.extFields(modelId, HussarUtils.isEmpty((Object)masterTable.getId()) ? modelId : masterTable.getId()));
            if (HussarUtils.isNotEmpty(slaveTables)) {
                for (OscarDataModelBase oscarDataModelBase : slaveTables) {
                    oscarDataModelFields.addAll(this.extFields(modelId, oscarDataModelBase.getId()));
                }
            }
        } else {
            oscarDataModelFields.addAll(masterTable.getFields());
            oscarDataModelFields.addAll(this.extFields(modelId, masterTable.getId()));
            if (HussarUtils.isNotEmpty(slaveTables)) {
                for (OscarDataModelBase oscarDataModelBase : slaveTables) {
                    oscarDataModelFields.addAll(oscarDataModelBase.getFields());
                    oscarDataModelFields.addAll(this.extFields(modelId, oscarDataModelBase.getId()));
                }
            }
        }
        if (modelFunction instanceof OscarTaskDataModel) {
            oscarDataModelFields.addAll(((OscarTaskDataModel)dataModelBase).getTask().getFields());
        } else if (modelFunction instanceof OscarTaskMsDataModel) {
            oscarDataModelFields.addAll(((OscarTaskMsDataModel)dataModelBase).getTask().getFields());
        }
        if ((modelFunction instanceof OscarMsDataModel || modelFunction instanceof OscarFlowMsDataModel || modelFunction instanceof OscarTaskDataModel) && HussarUtils.isNotEmpty(extSlaveFields = this.extSlaveFields(modelId))) {
            oscarDataModelFields.addAll(extSlaveFields);
        }
        return oscarDataModelFields;
    }

    private List<DataModelFieldBase> extFields(String sourceId, String modelId) throws LcdpException {
        JSONObject extFieldsJson;
        Object fields;
        Object extFieldsObj;
        JSONObject dataModelBaseExt;
        ArrayList<DataModelFieldBase> extFields = new ArrayList<DataModelFieldBase>();
        if (AppContextUtil.isExtension() && HussarUtils.isNotEmpty((Object)(dataModelBaseExt = DataModelUtil.getDataModelJsonExt((String)sourceId))) && HussarUtils.isNotEmpty((Object)(extFieldsObj = dataModelBaseExt.get((Object)"extFields"))) && HussarUtils.isNotEmpty((Object)(fields = (extFieldsJson = JSONObject.parseObject((String)JSON.toJSONString((Object)extFieldsObj))).get((Object)modelId)))) {
            List dataModelFieldBases = JSONArray.parseArray((String)JSON.toJSONString((Object)fields), DataModelFieldBase.class);
            extFields.addAll(dataModelFieldBases);
        }
        return extFields;
    }

    private List<DataModelFieldBase> extSlaveFields(String sourceId) throws LcdpException {
        JSONArray extSlaveTables;
        ArrayList<DataModelFieldBase> extSlaveFields = new ArrayList<DataModelFieldBase>();
        JSONObject dataModelBaseExt = DataModelUtil.getDataModelJsonExt((String)sourceId);
        if (HussarUtils.isNotEmpty((Object)dataModelBaseExt) && HussarUtils.isNotEmpty((Object)(extSlaveTables = dataModelBaseExt.getJSONArray("slaveTables")))) {
            for (Object extSlaveTable : extSlaveTables) {
                OscarDataModelBase oscarDataModelBase = (OscarDataModelBase)JsonUtil.parse((String)extSlaveTable.toString(), OscarBaseDataModel.class);
                if (!HussarUtils.isNotEmpty((Object)oscarDataModelBase) || !HussarUtils.isNotEmpty(oscarDataModelBase.getFields())) continue;
                extSlaveFields.addAll(oscarDataModelBase.getFields());
            }
        }
        return extSlaveFields;
    }

    public void delete(String s) throws LcdpException {
    }

    public Map<String, Map<String, Object>> getSlaveModelInfos(String modelId) throws LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        OscarDataModelBase model = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        return model.getSlaveModelInfo();
    }

    public Map<String, Map<String, String>> getModelAliasName(String modelId) throws LcdpException, IOException, CloneNotSupportedException {
        HashMap<String, Map<String, String>> alias = new HashMap<String, Map<String, String>>();
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)modelId);
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        OscarDataModelBase model = modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)modelId));
        if ("TASK_MASTER_SLAVE".equals(model.getFunctionType())) {
            OscarTaskMsDataModelDTO enclosure = (OscarTaskMsDataModelDTO)modelFunction.enclosure().enclosure(model);
            OscarDataModelBase oscarDataModelBase = enclosure.getDataModelBaseMap().get(modelId);
            alias.put("task", oscarDataModelBase.getModelAliasName());
        }
        alias.put("noTask", model.getModelAliasName());
        return alias;
    }

    public Map<String, Object> getSomeModelInfo(JSONObject dataModel) throws LcdpException, IOException, CloneNotSupportedException {
        HashMap<String, Object> some = new HashMap<String, Object>();
        OscarModelFunction modelFunction = OscarModelBeanUtil.getFunctionModelVisitorBean(dataModel.getString("functionType"));
        OscarDataModelBase model = modelFunction.parseDataModel(dataModel);
        OscarDataModelBaseDTO enclosure = modelFunction.enclosure().enclosure(model);
        if ("TASK_MASTER_SLAVE".equals(model.getFunctionType())) {
            OscarDataModelBaseDTO taskDTO = ((OscarTaskMsDataModelDTO)enclosure).getDataModelDtoMap().get(dataModel.get((Object)"id"));
            some.put("importInfo", taskDTO.getImportInfo());
            String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)taskDTO.getServiceImplName(), (String)taskDTO.getTablePath().toLowerCase());
            some.put("qualifyBeanName", qualifyBeanName);
            return some;
        }
        if ("TASK".equals(model.getFunctionType())) {
            OscarDataModelBaseDTO taskDTO = ((OscarTaskDataModelDTO)enclosure).getDataModelDtoMap().get(dataModel.get((Object)"id"));
            some.put("importInfo", taskDTO.getImportInfo());
            String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)taskDTO.getServiceImplName(), (String)taskDTO.getTablePath().toLowerCase());
            some.put("qualifyBeanName", qualifyBeanName);
            return some;
        }
        some.put("importInfo", enclosure.getImportInfo());
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)enclosure.getServiceImplName(), (String)enclosure.getTablePath().toLowerCase());
        some.put("qualifyBeanName", qualifyBeanName);
        return some;
    }
}

