/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.render.OscarBaseRender;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.flow.baseflow.OscarInitialNodeRejectCodeVisitor;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARFLOWTaskEntrust")
public class OscarTaskEntrustCodeVisitor
implements OscarOperationVisitor<OscarFlowDataModel, OscarFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarInitialNodeRejectCodeVisitor.class);
    public static final String OPERATION_NAME = "OSCARFLOWTaskEntrust";

    @Override
    public void visit(OscarBackCtx<OscarFlowDataModel, OscarFlowDataModelDTO> backCtx, OscarDataModelOperation operation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        OscarFlowDataModelDTO dataModelBaseDto = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(operation, dataModelBaseDto);
        String controllerPath = "template/oscar/flowbackcode/baseflowbackcode/taskentrust/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDto);
        backCtx.addControllerInversion(modelId, dataModelBaseDto.getServiceName());
        String servicePath = "template/oscar/flowbackcode/baseflowbackcode/taskentrust/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String implPath = "template/oscar/flowbackcode/baseflowbackcode/taskentrust/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, controllerParams));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", dataModelBaseDto.getApiPrefix(new String[0]) + "/" + operation.getName(), "\u4efb\u52a1\u8f6c\u529e", null);
        backCtx.addApi(modelId, OscarBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderImport(OscarBackCtx<OscarFlowDataModel, OscarFlowDataModelDTO> backCtx, String modelId, OscarFlowDataModelDTO dataModelBaseDto) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDto.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDto.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs");
        backCtx.addServiceImplImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
    }

    private Map<String, Object> initParams(OscarDataModelOperation operation, OscarFlowDataModelDTO dataModelBaseDto) {
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("dataSourceAnnotation", OscarDataSourceUtil.getMethodDataSourceAnnotation());
        controllerParams.put("table", dataModelBaseDto);
        controllerParams.put("parameter", dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getEntityName());
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(dataModelBaseDto.getComment() + "\u4efb\u52a1\u8f6c\u529e");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        return controllerParams;
    }
}

