/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.base;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARBASESerialNumber")
public class OscarSerialNumberVisitor
implements OscarOperationVisitor<OscarBaseDataModel, OscarBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarSerialNumberVisitor.class);
    public static final String OPERATION_NAME = "OSCARBASESerialNumber";

    @Override
    public void visit(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        OscarBaseDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = useDataModelBase.getId();
        OscarBaseDataModelDTO oscarBaseDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Optional<OscarDataModelFieldDto> serialFieldOpt = oscarBaseDataModelDTO.getFields().stream().filter(m -> HussarUtils.equals((Object)"serialNumber", (Object)m.getFill())).findFirst();
        if (!serialFieldOpt.isPresent()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", oscarBaseDataModelDTO);
        OscarDataModelFieldDto field = serialFieldOpt.get();
        params.put("field", field);
        params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
        params.put("returnValue", oscarBaseDataModelDTO.getEntityName());
        oscarBaseDataModelDTO.addServiceImplImport(oscarBaseDataModelDTO.getImportInfo().get("Entity"));
        oscarBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
        oscarBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
        oscarBaseDataModelDTO.addServiceImplImport("java.util.HashMap");
        oscarBaseDataModelDTO.addServiceImplImport("java.util.Map");
        oscarBaseDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSONObject");
        oscarBaseDataModelDTO.addServiceImplImport("com.alibaba.fastjson.JSON");
        oscarBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        oscarBaseDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        oscarBaseDataModelDTO.addServiceImplImport("org.apache.commons.beanutils.BeanUtils");
        oscarBaseDataModelDTO.addServiceImplImport("java.lang.reflect.InvocationTargetException");
        backCtx.addServiceImplInversion(useDataModelBase.getId(), "ISysCodeRuleService");
        String implPath = "template/oscar/backcode/serialNumber/serialNumberServiceImpl.ftl";
        String servicePath = "template/oscar/backcode/serialNumber/serialNumberService.ftl";
        SerialNumberUtil.saveCodeRule(JSONObject.parseObject((String)JSONObject.toJSONString((Object)useDataModelBase)), useDataModelBase.getComment(), useDataModelBase.getSourceDataModelName(), field.getName(), params, false, field.getId());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, params));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

