/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.render;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.PrefixUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.OscarCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.AspectGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.EntityGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.MapperGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ServiceImplGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarRender;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarQueryDTO;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataSourceUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarRenderUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARBASERENDER")
public class OscarBaseRender
implements OscarRender<OscarBaseDataModel, OscarBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarBaseRender.class);
    public static final String RENDER = "OSCARBASERENDER";

    @Override
    public List<OscarCodeGenerateInfo> renderCode(OscarBackCtx<OscarBaseDataModel, OscarBaseDataModelDTO> backCtx) throws LcdpException, IOException {
        Map<String, OscarQueryDTO> queryDtoMap;
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<OscarCodeGenerateInfo> oscarCodeGenerateInfos = new ArrayList<OscarCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        OscarBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        boolean extension = backCtx.getUseDataModelBase().isExtension();
        dataModelBaseDTO.setExtension(extension);
        backCtx.addParam(String.format("publishTemplateDto_%s", modelId), dataModelBaseDTO.getPublishTemplateDto());
        oscarCodeGenerateInfos.add(this.genEntityCode(dataModelBaseDTO));
        oscarCodeGenerateInfos.add(this.genVoCode(dataModelBaseDTO));
        oscarCodeGenerateInfos.add(this.genControllerCode(dataModelBaseDTO));
        oscarCodeGenerateInfos.add(this.genServiceCode(dataModelBaseDTO));
        oscarCodeGenerateInfos.add(this.genServiceImplCode(dataModelBaseDTO));
        oscarCodeGenerateInfos.add(this.genMapperCode(dataModelBaseDTO));
        oscarCodeGenerateInfos.add(this.genXmlCode(dataModelBaseDTO));
        oscarCodeGenerateInfos.add(this.genApiCode(dataModelBaseDTO, baseFile));
        if (AppContextUtil.isHTSZMode() && !AppContextUtil.isExtension() && !backCtx.isRenderPoint()) {
            oscarCodeGenerateInfos.add(OscarRenderUtil.genHookServiceImplCode(dataModelBaseDTO));
            backCtx.setRenderPoint(true);
        }
        if (ToolUtil.isNotEmpty(queryDtoMap = dataModelBaseDTO.getQueryDtoMap())) {
            for (Map.Entry<String, OscarQueryDTO> queryDTOEntry : queryDtoMap.entrySet()) {
                OscarQueryDTO queryDTO = queryDTOEntry.getValue();
                OscarCodeGenerateInfo queryCodeGenerateInfo = this.dynamicModelCode(queryDTO, dataModelBaseDTO);
                if (null == queryCodeGenerateInfo) continue;
                oscarCodeGenerateInfos.add(queryCodeGenerateInfo);
            }
        }
        Map<String, AspectGenerateInfo> aspectGenerateInfoMap = dataModelBaseDTO.getAspectGenerateInfoMap();
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getAnnotationNames()) && ToolUtil.isNotEmpty(aspectGenerateInfoMap)) {
            for (String annotationName : dataModelBaseDTO.getAnnotationNames()) {
                oscarCodeGenerateInfos.add(this.genAnnotationCode(dataModelBaseDTO, annotationName));
                AspectGenerateInfo aspectGenerateInfo = Optional.ofNullable(aspectGenerateInfoMap.get(aspectGenerateInfoMap.keySet().stream().filter(key -> key.equals(annotationName)).findFirst().orElse(""))).orElseGet(AspectGenerateInfo::new);
                oscarCodeGenerateInfos.add(this.genAspectCode(dataModelBaseDTO, annotationName, aspectGenerateInfo));
            }
        }
        return oscarCodeGenerateInfos;
    }

    private OscarCodeGenerateInfo genEntityCode(OscarBaseDataModelDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "model" + File.separator + dataModelBaseDTO.getEntityName() + ".java";
        String filePath = "template/oscar/backcode/code/entity.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getEntityName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getEntityGenerateInfo())) {
            EntityGenerateInfo entityGenerateInfo = new EntityGenerateInfo();
            entityGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setEntityGenerateInfo(entityGenerateInfo);
        } else {
            dataModelBaseDTO.getEntityGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("entity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getEntityName() + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genVoCode(OscarBaseDataModelDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "VO".toLowerCase() + File.separator + dataModelBaseDTO.getVoName() + ".java";
        String filePath = "template/oscar/backcode/code/vo.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getVoName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getVoGeneratorInfo())) {
            VoGeneratorInfo info = new VoGeneratorInfo();
            info.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setVoGeneratorInfo(info);
        } else {
            dataModelBaseDTO.getVoGeneratorInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("queryEntity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getVoName() + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genControllerCode(OscarBaseDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Controller".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Controller" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getControllerName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getControllerGenerateInfo())) {
            ControllerGenerateInfo controllerGenerateInfo = new ControllerGenerateInfo();
            controllerGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setControllerGenerateInfo(controllerGenerateInfo);
        } else {
            dataModelDto.getControllerGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getControllerGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(dataModelDto.getImportInfo().get("Entity"));
        imports.add(dataModelDto.getImportInfo().get("Service"));
        dataModelDto.getControllerGenerateInfo().setImports(imports);
        String filePath = "template/oscar/backcode/code/controller.ftl";
        dataModelDto.setExtensionApp(AppContextUtil.isExtension());
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(PrefixUtil.replacePrefix((String)newCode));
        codeGenerateInfo.setFileType("controller");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getControllerName() + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genServiceCode(OscarBaseDataModelDTO dataModelDto) throws LcdpException, IOException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Service" + ".java";
        String filePath = "template/oscar/backcode/code/service.ftl";
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("service");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Service" + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genServiceImplCode(OscarBaseDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl" + File.separator + dataModelDto.getEntityName() + "ServiceImpl" + ".java";
        String filePath = "template/oscar/backcode/code/service_impl.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getServiceImplGenerateInfo())) {
            ServiceImplGenerateInfo serviceImplGenerateInfo = new ServiceImplGenerateInfo();
            serviceImplGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setServiceImplGenerateInfo(serviceImplGenerateInfo);
        } else {
            dataModelDto.getServiceImplGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getServiceImplGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(OscarDataSourceUtil.getDataSourceServiceImpl(dataModelDto.getDataSourceName()));
        imports.add("java.util.List");
        imports.add("java.util.Map");
        imports.add("java.util.HashMap");
        imports.add("com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
        imports.add("com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        dataModelDto.getServiceImplGenerateInfo().setImports(imports);
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("serviceImpl");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "ServiceImpl" + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genMapperCode(OscarBaseDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".java";
        String filePath = "template/oscar/backcode/code/mapper.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getMapperName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getMapperGenerateInfo())) {
            MapperGenerateInfo mapperGenerateInfo = new MapperGenerateInfo();
            mapperGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setMapperGenerateInfo(mapperGenerateInfo);
        } else {
            dataModelDto.getMapperGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("mapper");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".java");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genXmlCode(OscarBaseDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + "mapping" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".xml";
        String filePath = "template/oscar/backcode/code/xml.ftl";
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("xml");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".xml");
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo dynamicModelCode(OscarQueryDTO queryDTO, OscarDataModelBaseDTO dataModelDto) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryDTO)) {
            String writePath = queryDTO.getWriteFilePath();
            String filePath = queryDTO.getFtlPath();
            String newCode = RenderUtil.renderTemplate((String)filePath, queryDTO.getParams());
            OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(queryDTO.getEntityName());
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private OscarCodeGenerateInfo genAnnotationCode(OscarBaseDataModelDTO dataModelDto, String annotationName) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "annotation" + File.separator + annotationName + ".java";
        String filePath = "template/oscar/backcode/code/annotation.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("annotation");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(annotationName);
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genApiCode(OscarBaseDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/oscar/preview/api/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genPreviewApiCode(OscarBaseDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/oscar/preview/api/api-file.ftl";
        String newCode = OscarBackRenderUtil.renderTemplate(filePath, dataModelDto);
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private OscarCodeGenerateInfo genAspectCode(OscarBaseDataModelDTO dataModelDto, String annotationName, AspectGenerateInfo aspectGenerateInfo) throws LcdpException {
        String aspectName = annotationName + NamingStrategy.capitalFirst((String)"aspect");
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "aspect" + File.separator + aspectName + ".java";
        String filePath = "template/oscar/backcode/code/aspect.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("aspectName", aspectName);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        params.put("aspect", aspectGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        OscarCodeGenerateInfo codeGenerateInfo = new OscarCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("aspect");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(aspectName);
        return codeGenerateInfo;
    }

    public static String renderTemplate(String templatePath, ApiGenerateInfo apiGenerateInfo) throws LcdpException {
        HashMap<String, ApiGenerateInfo> params = new HashMap<String, ApiGenerateInfo>();
        params.put("api", apiGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }
}

