/**
* ${exegesis}
*/
@Override
public ApiResponse<String> ${name!}(MultipartFile file, Long taskId, String templateId){
    InputStream input;
    String fileName;
    try {
        input= file.getInputStream(); //将文件转为流
        fileName = file.getOriginalFilename();
    } catch (IOException e) {
        throw new HussarException(e);
    }
    // 获取当前用户
    SecurityUser user = BaseSecurityUtil.getUser();
    //开启异步，可通过taskId查询异步进程中的任务状态
    Executor hussarBaseExcelExecutor = hussarThreadPoolConfiguration.getAsyncExecutor();
    hussarBaseExcelExecutor.execute(() -> {
        <#-- 读取文件并校验  -->
        List<${returnValue}> importData = VerifyExcelUtil.readInputStreamCheckExcel(user, fileName, input, templateId, taskId);
        if(ToolUtil.isNotEmpty(importData)) {
            <#if fillCode??>
            for (${returnValue} ${table.entityName?uncap_first} : importData) {
                ${fillCode!}
            }
            </#if>
            SysExcelTask excelTask = iSysExcelTaskService.getById(taskId);
            /* @begin ${name!} #自定义代码 */
            /* @end ${name!} */
            try {
                this.saveOrUpdateBatch(importData);
                excelTask.setTaskStatus(TaskConstants.TASK_STATUS_IMPORT_SUCCEED);
                excelTask.setDataSuccess(importData.size());
                excelTask.setDataError(0);
                excelTask.setLastTime(LocalDateTime.now());
                excelTask.setLastEditor(user.getId());
                iSysExcelTaskService.updateById(excelTask);
            }catch (Exception e) {
                excelTask.setTaskStatus(TaskConstants.TASK_STATUS_IMPORT_FAILED);
                excelTask.setDataSuccess(0);
                excelTask.setDataError(importData.size());
                excelTask.setLastTime(LocalDateTime.now());
                excelTask.setLastEditor(user.getId());
                iSysExcelTaskService.updateById(excelTask);
                throw new HussarException("导入失败", e);
            }
        }
    });
    return ApiResponse.success();
}