/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.task.basetask;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARTASKSerialNumber")
public class OscarTaskSerialNumberVisitor
implements OscarOperationVisitor<OscarTaskDataModel, OscarTaskDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarTaskSerialNumberVisitor.class);
    public static final String OPERATION_NAME = "OSCARTASKSerialNumber";

    @Override
    public void visit(OscarBackCtx<OscarTaskDataModel, OscarTaskDataModelDTO> taskBackCtx, OscarDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        OscarFlowDataModelDTO dataModelBaseDTO = (OscarFlowDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        OscarFlowDataModel useDataModelBase = (OscarFlowDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        OscarBackCtx backCtx = new OscarBackCtx();
        backCtx.setUseDataModelBase(useDataModelBase);
        HashMap<String, OscarFlowDataModelDTO> map = new HashMap<String, OscarFlowDataModelDTO>();
        map.put(modelId, dataModelBaseDTO);
        backCtx.setUseDataModelDtoMap(map);
        Optional<OscarDataModelFieldDto> serialFieldOpt = dataModelBaseDTO.getFields().stream().filter(m -> HussarUtils.equals((Object)"serialNumber", (Object)m.getFill())).findFirst();
        if (!serialFieldOpt.isPresent()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        OscarDataModelFieldDto field = serialFieldOpt.get();
        params.put("field", field);
        params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
        params.put("returnValue", dataModelBaseDTO.getEntityName());
        dataModelBaseDTO.addServiceImplImport(dataModelBaseDTO.getImportInfo().get("Entity"));
        params.put("parameter", dataModelBaseDTO.getQueryDtoMap().get(dataModelBaseDTO.getName()).getEntityName());
        dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
        dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
        dataModelBaseDTO.addServiceImplImport("java.util.HashMap");
        dataModelBaseDTO.addServiceImplImport("java.util.Map");
        dataModelBaseDTO.addServiceImplImport("com.alibaba.fastjson.JSONObject");
        dataModelBaseDTO.addServiceImplImport("com.alibaba.fastjson.JSON");
        dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        dataModelBaseDTO.addServiceImplImport("com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        dataModelBaseDTO.addServiceImplImport("org.apache.commons.beanutils.BeanUtils");
        dataModelBaseDTO.addServiceImplImport("java.lang.reflect.InvocationTargetException");
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getServiceName());
        backCtx.addServiceImplInversion(useDataModelBase.getId(), "ISysCodeRuleService");
        String implPath = "template/oscar/taskbackcode/basetaskbackcode/serialNumber/serialNumberServiceImpl.ftl";
        String servicePath = "template/oscar/taskbackcode/basetaskbackcode/serialNumber/serialNumberService.ftl";
        SerialNumberUtil.saveCodeRule(JSONObject.parseObject((String)JSONObject.toJSONString((Object)useDataModelBase)), useDataModelBase.getComment(), useDataModelBase.getSourceDataModelName(), field.getName(), params, false, field.getId());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, params));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

