/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarEnclosure;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarRender;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryObject;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortConditionField;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OscarMsDataModel
extends OscarDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(OscarMsDataModel.class);
    public static final String FUNCTION_TYPE = "MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<OscarQueryCondition> queryConditions;
    private List<OscarQueryObject> queryObject;
    private OscarDataModelBase masterTable;
    private List<OscarDataModelBase> slaveTables;
    private List<OscarRelationshipBase> relationships;
    private boolean logicallyDelete;
    private OscarBaseDataModel taskModel;
    private List<OscarSortCondition> sortCondition;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"OSCAR.MASTER_SLAVE", OscarMsDataModel.class);
    }

    @Override
    public OscarMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        OscarMsDataModel oscarMsDataModel;
        try {
            ArrayList<OscarDataModelField> fieldList = new ArrayList<OscarDataModelField>();
            oscarMsDataModel = (OscarMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), OscarMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                OscarDataModelBase master = OscarDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(oscarMsDataModel.getName() + "Master");
                oscarMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<OscarDataModelBase> slaveTables = new ArrayList<OscarDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    OscarDataModelBase slaveTable = OscarDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (OscarRelationshipBase relationship : oscarMsDataModel.getRelationships()) {
                    OscarDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(OscarBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    OscarDataModelField oscarDataModelField = new OscarDataModelField();
                    oscarDataModelField.setId(UUID.randomUUID().toString());
                    oscarDataModelField.setName(dataModelBase.getName());
                    oscarDataModelField.setComment(dataModelBase.getComment());
                    oscarDataModelField.setSourceDataModelId(dataModelBase.getId());
                    oscarDataModelField.setDataType("array");
                    fieldList.add(oscarDataModelField);
                }
                oscarMsDataModel.setSlaveTables(slaveTables);
            }
            oscarMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return oscarMsDataModel;
    }

    @Override
    public OscarEnclosure<OscarDataModelBase> enclosure() throws LcdpException {
        return OscarModelBeanUtil.getEnclosureBean("OSCAR", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public OscarRender<OscarDataModelBase, OscarDataModelBaseDTO> render() throws LcdpException {
        return OscarModelBeanUtil.getRenderBean("OSCAR", FUNCTION_TYPE, "RENDER");
    }

    public OscarBaseDataModel getTaskModel() {
        return this.taskModel;
    }

    public void setTaskModel(OscarBaseDataModel taskModel) {
        this.taskModel = taskModel;
    }

    public OscarDataModelBase getMasterTable() {
        return this.masterTable;
    }

    public void setMasterTable(OscarDataModelBase masterTable) {
        this.masterTable = masterTable;
    }

    public List<OscarDataModelBase> getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(List<OscarDataModelBase> slaveTables) {
        this.slaveTables = slaveTables;
    }

    public List<OscarRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<OscarRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    public List<OscarQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<OscarQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<OscarQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<OscarQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<OscarSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (OscarSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (OscarSortConditionField field : condition.getFields()) {
                    Map<String, String> fieldMap;
                    String fieldName;
                    if (HussarUtils.isEmpty((Object)field.getParentModelId())) {
                        field.setParentModelId(field.getFromModelIdSort());
                    }
                    OscarDataModelBase dataModelBase = this.masterTable;
                    if (!this.masterTable.getId().equals(field.getFromModelIdSort())) {
                        for (OscarDataModelBase modelBase : this.slaveTables) {
                            if (!modelBase.getId().equals(field.getFromModelIdSort())) continue;
                            dataModelBase = modelBase;
                            break;
                        }
                    }
                    if (HussarUtils.equals((Object)(fieldName = (fieldMap = dataModelBase.getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName))).get(field.getFromModelFieldIdSort())), (Object)field.getFromModelFieldSort())) continue;
                    field.setFromModelFieldSort(fieldName);
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<OscarSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public boolean isLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    @Override
    public OscarQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (OscarQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public OscarSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (OscarSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return "";
    }

    @Override
    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.masterTable.getId(), "T2");
        if (ToolUtil.isNotEmpty(this.relationships) && !this.relationships.isEmpty()) {
            for (int i = 0; i < this.relationships.size(); ++i) {
                OscarRelationshipBase relationship = this.relationships.get(i);
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        return finalMap;
    }

    public DataSet getDataSetById(String dataSetId) {
        if (this.getDataSets() != null) {
            for (DataSet dataSet : this.getDataSets()) {
                if (!dataSet.getId().equals(dataSetId)) continue;
                return dataSet;
            }
        }
        return null;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> findTableContrast() throws IOException, LcdpException {
        List<ContrastVO<OscarDataModelField>> tableContrast = this.masterTable.findTableContrast();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).findTableContrast().get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> tableContrastModel(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<OscarDataModelField>> tableContrast = this.masterTable.tableContrastModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).tableContrastModel(fieldsContrastParam).get(0));
        }
        List<OscarDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (OscarDataModelBase extSlaveTable : extSlaveTables) {
            ContrastVO<OscarDataModelField> oscarDataModelFieldContrastVO = extSlaveTable.tableContrastModel(fieldsContrastParam).get(0);
            if (HussarUtils.isNotEmpty(oscarDataModelFieldContrastVO) && HussarUtils.isNotEmpty((Object)oscarDataModelFieldContrastVO.getTableFields())) {
                for (OscarDataModelField field : oscarDataModelFieldContrastVO.getTableFields()) {
                    field.setExtension(true);
                }
            }
            tableContrast.add(oscarDataModelFieldContrastVO);
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> tableContrastModelIn(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        ArrayList<ContrastVO<OscarDataModelField>> tableContrast = new ArrayList<ContrastVO<OscarDataModelField>>();
        List tableInfos = DataModelUtil.filterInTables((String)this.getDataSourceName(), (String)"BASE TABLE", this.getTableNames(fieldsContrastParam));
        TableInfo masterTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> this.masterTable.getSourceDataModelName().toUpperCase().equals(table.getName())).findFirst().orElse(null) : null;
        tableContrast.add(this.masterTable.tableContrastModel(masterTableInfo, fieldsContrastParam));
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (OscarDataModelBase slaveTable : this.slaveTables) {
            if (!HussarUtils.isEmpty(map.get(slaveTable.getSourceDataModelName()))) continue;
            String slaveUpperCaseName = slaveTable.getSourceDataModelName().toUpperCase();
            TableInfo slaveTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> slaveUpperCaseName.equals(table.getName())).findFirst().orElse(null) : null;
            tableContrast.add(slaveTable.tableContrastModel(slaveTableInfo, fieldsContrastParam));
            map.put(slaveTable.getSourceDataModelName(), true);
        }
        List<OscarDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (OscarDataModelBase extSlaveTable : extSlaveTables) {
            if (!HussarUtils.isEmpty(map.get(extSlaveTable.getSourceDataModelName()))) continue;
            String extSlaveUpperCaseName = extSlaveTable.getSourceDataModelName().toUpperCase();
            TableInfo slaveTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> extSlaveUpperCaseName.equals(table.getName())).findFirst().orElse(null) : null;
            ContrastVO<OscarDataModelField> oscarDataModelFieldContrastVO = extSlaveTable.tableContrastModel(slaveTableInfo, fieldsContrastParam);
            if (HussarUtils.isNotEmpty(oscarDataModelFieldContrastVO) && HussarUtils.isNotEmpty((Object)oscarDataModelFieldContrastVO.getTableFields())) {
                for (OscarDataModelField field : oscarDataModelFieldContrastVO.getTableFields()) {
                    field.setExtension(true);
                }
            }
            tableContrast.add(oscarDataModelFieldContrastVO);
            map.put(extSlaveTable.getSourceDataModelName(), true);
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> modelContrastTable(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<OscarDataModelField>> tableContrast = this.masterTable.modelContrastTable(fieldsContrastParam);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            if (!HussarUtils.isEmpty(map.get(this.slaveTables.get(i).getSourceDataModelName()))) continue;
            tableContrast.add(this.slaveTables.get(i).modelContrastTable(fieldsContrastParam).get(0));
            map.put(this.slaveTables.get(i).getSourceDataModelName(), true);
        }
        List<OscarDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (OscarDataModelBase extSlaveTable : extSlaveTables) {
            if (!HussarUtils.isEmpty(map.get(extSlaveTable.getSourceDataModelName()))) continue;
            ContrastVO<OscarDataModelField> oscarDataModelFieldContrastVO = extSlaveTable.modelContrastTable(fieldsContrastParam).get(0);
            if (HussarUtils.isNotEmpty(oscarDataModelFieldContrastVO) && HussarUtils.isNotEmpty((Object)oscarDataModelFieldContrastVO.getTableFields())) {
                for (OscarDataModelField field : oscarDataModelFieldContrastVO.getTableFields()) {
                    field.setExtension(true);
                }
            }
            tableContrast.add(oscarDataModelFieldContrastVO);
            map.put(extSlaveTable.getSourceDataModelName(), true);
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<OscarDataModelField>> modelContrastTableIn(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        ArrayList<ContrastVO<OscarDataModelField>> tableContrast = new ArrayList<ContrastVO<OscarDataModelField>>();
        List tableInfos = DataModelUtil.filterInTables((String)this.getDataSourceName(), (String)"BASE TABLE", this.getTableNames(fieldsContrastParam));
        TableInfo masterTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> this.masterTable.getSourceDataModelName().toUpperCase().equals(table.getName())).findFirst().orElse(null) : null;
        tableContrast.add(this.masterTable.modelContrastTable(masterTableInfo, fieldsContrastParam));
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (OscarDataModelBase slaveTable : this.slaveTables) {
            if (!HussarUtils.isEmpty(map.get(slaveTable.getSourceDataModelName()))) continue;
            String slaveUpperCaseName = slaveTable.getSourceDataModelName().toUpperCase();
            TableInfo slaveTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> slaveUpperCaseName.equals(table.getName())).findFirst().orElse(null) : null;
            tableContrast.add(slaveTable.modelContrastTable(slaveTableInfo, fieldsContrastParam));
            map.put(slaveTable.getSourceDataModelName(), true);
        }
        List<OscarDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (OscarDataModelBase extSlaveTable : extSlaveTables) {
            if (!HussarUtils.isEmpty(map.get(extSlaveTable.getSourceDataModelName()))) continue;
            String extSlaveUpperCaseName = extSlaveTable.getSourceDataModelName().toUpperCase();
            TableInfo slaveTableInfo = HussarUtils.isNotEmpty((Object)tableInfos) ? (TableInfo)tableInfos.stream().filter(table -> extSlaveUpperCaseName.equals(table.getName())).findFirst().orElse(null) : null;
            ContrastVO<OscarDataModelField> oscarDataModelFieldContrastVO = extSlaveTable.modelContrastTable(slaveTableInfo, fieldsContrastParam);
            if (HussarUtils.isNotEmpty(oscarDataModelFieldContrastVO) && HussarUtils.isNotEmpty((Object)oscarDataModelFieldContrastVO.getTableFields())) {
                for (OscarDataModelField field : oscarDataModelFieldContrastVO.getTableFields()) {
                    field.setExtension(true);
                }
            }
            tableContrast.add(oscarDataModelFieldContrastVO);
            map.put(extSlaveTable.getSourceDataModelName(), true);
        }
        return tableContrast;
    }

    public List<String> getTableNames(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws LcdpException {
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.masterTable.getTableName(fieldsContrastParam));
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (OscarDataModelBase slaveTable : this.slaveTables) {
            if (!HussarUtils.isEmpty(map.get(slaveTable.getSourceDataModelName()))) continue;
            tableNames.add(slaveTable.getTableName(fieldsContrastParam));
            map.put(slaveTable.getSourceDataModelName(), true);
        }
        List<OscarDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (OscarDataModelBase extSlaveTable : extSlaveTables) {
            if (!HussarUtils.isEmpty(map.get(extSlaveTable.getSourceDataModelName()))) continue;
            tableNames.add(extSlaveTable.getTableName(fieldsContrastParam));
            map.put(extSlaveTable.getSourceDataModelName(), true);
        }
        return tableNames;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId, Map<String, List<JSONObject>> extFields, List<JSONObject> extSlaveTables) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.masterTable.checkTableContrast(modelId, extFields, extSlaveTables).getDetails().get(0));
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            details.add(this.slaveTables.get(i).checkTableContrast(modelId, extFields, extSlaveTables).getDetails().get(0));
        }
        List<OscarDataModelBase> extSlaveTableDto = this.extSlaveTables(extSlaveTables);
        for (OscarDataModelBase extSlaveTable : extSlaveTableDto) {
            details.add(extSlaveTable.checkTableContrast(modelId, extFields, extSlaveTables).getDetails().get(0));
        }
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        this.masterTable.updateTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            this.slaveTables.get(i).updateTable(fieldsContrastParam);
        }
        List<OscarDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (OscarDataModelBase extSlaveTable : extSlaveTables) {
            extSlaveTable.updateTable(fieldsContrastParam);
        }
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws Exception {
        StringBuilder sql = new StringBuilder(this.masterTable.copyTableByModel(fieldsContrastParam));
        for (OscarDataModelBase slaveTable : this.slaveTables) {
            sql.append(slaveTable.copyTableByModel(fieldsContrastParam));
        }
        List<OscarDataModelBase> extSlaveTables = this.extSlaveTables(fieldsContrastParam);
        for (OscarDataModelBase extSlaveTable : extSlaveTables) {
            sql.append(extSlaveTable.copyTableByModel(fieldsContrastParam));
        }
        return sql.toString();
    }

    public OscarDataModelField getDeleteFlag() {
        return this.getMasterTable().getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public OscarDataModelField getUpdateTime() {
        return this.masterTable.getFields().stream().filter(field -> "updateTime".equals(field.getUsage())).findFirst().orElse(null);
    }

    public OscarDataModelField getPrimaryKey() {
        return this.getMasterTable().getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() throws LcdpException {
        JSONObject dataModelJsonExt;
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        List<OscarDataModelBase> slaveTables = this.getSlaveTables();
        for (OscarDataModelBase slaveTable : slaveTables) {
            OscarDataModelField oscarDataModelField = slaveTable.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(new OscarDataModelField());
            HashMap<String, Object> val = new HashMap<String, Object>();
            val.put("name", slaveTable.getName());
            val.put("sourceDataModelName", slaveTable.getSourceDataModelName());
            val.put("comment", slaveTable.getComment());
            val.put("primary", oscarDataModelField.getName());
            val.put("fields", slaveTable.getFields());
            boolean association = this.getRelationships().stream().anyMatch(relationship -> relationship.getRelateModelType().equals(ASSOCIATION) && relationship.getSlaveTableId().equals(slaveTable.getId()));
            val.put(ASSOCIATION, association);
            val.put("type", association ? ASSOCIATION : COLLECTION);
            map.put(slaveTable.getId(), val);
        }
        HashMap<String, String> val = new HashMap<String, String>();
        val.put("name", this.masterTable.getName());
        val.put("sourceDataModelName", this.masterTable.getSourceDataModelName());
        val.put("type", "master");
        map.put(this.masterTable.getId(), val);
        if (AppContextUtil.isHTSZMode() && AppContextUtil.isExtension() && HussarUtils.isNotEmpty((Object)(dataModelJsonExt = DataModelUtil.getDataModelJsonExt((String)this.getId())))) {
            JSONArray slaveTablesJson = (JSONArray)dataModelJsonExt.get((Object)SLAVE_KEY);
            JSONArray relationshipsJson = (JSONArray)dataModelJsonExt.get((Object)"relationships");
            ArrayList<OscarRelationshipBase> relationshipBaseList = new ArrayList<OscarRelationshipBase>();
            if (HussarUtils.isNotEmpty((Object)relationshipsJson)) {
                for (Object o : relationshipsJson) {
                    OscarRelationshipBase relationshipBase = (OscarRelationshipBase)JsonUtil.parse((String)o.toString(), OscarRelationshipBase.class);
                    relationshipBaseList.add(relationshipBase);
                }
            }
            if (HussarUtils.isNotEmpty((Object)slaveTablesJson) && HussarUtils.isNotEmpty(relationshipBaseList)) {
                for (Object slaveObj : slaveTablesJson) {
                    OscarBaseDataModel parse = (OscarBaseDataModel)JsonUtil.parse((String)slaveObj.toString(), OscarBaseDataModel.class);
                    OscarDataModelField oscarDataModelField = parse.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(new OscarDataModelField());
                    HashMap<String, Object> valext = new HashMap<String, Object>();
                    valext.put("name", parse.getName());
                    valext.put("sourceDataModelName", parse.getSourceDataModelName());
                    valext.put("comment", parse.getComment());
                    valext.put("primary", oscarDataModelField.getName());
                    valext.put("fields", parse.getFields());
                    boolean association = relationshipBaseList.stream().anyMatch(relationship -> relationship.getRelateModelType().equals(ASSOCIATION) && relationship.getSlaveTableId().equals(parse.getId()));
                    valext.put(ASSOCIATION, association);
                    valext.put("type", association ? ASSOCIATION : COLLECTION);
                    map.put(parse.getId(), valext);
                }
            }
        }
        return map;
    }

    private List<OscarDataModelBase> extSlaveTables(FieldsContrastParam<OscarDataModelField> fieldsContrastParam) throws LcdpException {
        List slaveTables;
        ArrayList<OscarDataModelBase> extSlaveTables = new ArrayList<OscarDataModelBase>();
        if (HussarUtils.isNotEmpty((Object)fieldsContrastParam.getSlaveTables()) && HussarUtils.isNotEmpty((Object)(slaveTables = fieldsContrastParam.getSlaveTables()))) {
            for (JSONObject slaveTable : slaveTables) {
                OscarDataModelBase extSlaveTable = OscarDataModelUtil.transfer(slaveTable);
                extSlaveTables.add(extSlaveTable);
            }
        }
        return extSlaveTables;
    }

    private List<OscarDataModelBase> extSlaveTables(List<JSONObject> slaveTables) throws LcdpException {
        ArrayList<OscarDataModelBase> extSlaveTables = new ArrayList<OscarDataModelBase>();
        if (HussarUtils.isNotEmpty(slaveTables)) {
            for (JSONObject slaveTable : slaveTables) {
                OscarDataModelBase extSlaveTable = OscarDataModelUtil.transfer(slaveTable);
                extSlaveTables.add(extSlaveTable);
            }
        }
        return extSlaveTables;
    }
}

