/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.element.customview;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarEnclosure;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarRender;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.querycondition.OscarQueryObject;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortCondition;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.sortcondition.OscarSortConditionField;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OscarCustomViewModel
extends OscarDataModelBase {
    private static final Logger logger = LoggerFactory.getLogger(OscarDataModelBase.class);
    public static final String FUNCTION_TYPE = "CUSTOM_VIEW";
    private String viewSql;
    public static final Logger LOGGER = LoggerFactory.getLogger(OscarBaseDataModel.class);
    private String sourceDataModelName;
    private List<OscarQueryCondition> queryConditions;
    private List<OscarQueryObject> queryObject;
    private List<OscarSortCondition> sortCondition;
    private List<OscarDataModelField> addFields;
    private List<OscarDataModelField> delFields;
    private List<OscarDataModelField> editFields;

    public String getViewSql() {
        return this.viewSql;
    }

    public void setViewSql(String viewSql) {
        this.viewSql = viewSql;
    }

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"OSCAR.CUSTOM_VIEW", OscarCustomViewModel.class);
    }

    @Override
    public OscarCustomViewModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        OscarCustomViewModel customSqlModel;
        try {
            customSqlModel = (OscarCustomViewModel)JSONObject.parseObject((String)jsonObject.toString(), OscarCustomViewModel.class);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return customSqlModel;
    }

    public OscarEnclosure enclosure() throws LcdpException {
        return null;
    }

    public OscarRender render() throws LcdpException {
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    public List<OscarQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<OscarQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<OscarQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<OscarQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<OscarSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (OscarSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (OscarSortConditionField field : condition.getFields()) {
                    try {
                        Map<String, String> fieldMap = OscarDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)field.getFromModelIdSort())).getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName));
                        String fieldName = fieldMap.get(field.getFromModelFieldIdSort());
                        if (HussarUtils.equals((Object)fieldName, (Object)field.getFromModelFieldSort())) continue;
                        field.setFromModelFieldSort(fieldName);
                    }
                    catch (LcdpException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<OscarSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    public List<OscarDataModelField> getAddFields() {
        return this.addFields;
    }

    public void setAddFields(List<OscarDataModelField> addFields) {
        this.addFields = addFields;
    }

    public List<OscarDataModelField> getDelFields() {
        return this.delFields;
    }

    public void setDelFields(List<OscarDataModelField> delFields) {
        this.delFields = delFields;
    }

    public List<OscarDataModelField> getEditFields() {
        return this.editFields;
    }

    public void setEditFields(List<OscarDataModelField> editFields) {
        this.editFields = editFields;
    }

    @Override
    public OscarQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (OscarQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return new OscarQueryCondition();
    }

    @Override
    public OscarSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (OscarSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return new OscarSortCondition();
    }
}

