/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.task.masterslavetask.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OscarTaskMsUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";

    private OscarTaskMsUtil() {
    }

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, OscarBackCtx<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> backCtx) throws LcdpException {
        OscarTaskMsUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, OscarBackCtx<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> backCtx) {
        OscarTaskMsUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(OscarBackCtx<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        OscarMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        OscarMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        OscarDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<OscarRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        OscarDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        if (params.get("logicallyDelete") != null) {
            for (OscarRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.init();
            }
        } else {
            for (OscarRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = OscarTaskMsUtil.getDelStr(relationshipDtoList, masterDto);
        OscarTaskMsUtil.renderTransaction(backCtx, params);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (OscarRelationshipDTO oscarRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            OscarDataModelBaseDTO oscarDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(oscarRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, oscarDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, oscarDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, oscarDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(OscarBackCtx<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        OscarMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        OscarMsDataModelDTO oscarMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<OscarRelationshipDTO> relationshipDtoList = oscarMsDataModelDTO.getRelationshipDtoList();
        OscarDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, OscarDataModelBaseDTO> dataModelDtoMap = oscarMsDataModelDTO.getDataModelDtoMap();
        OscarDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        OscarTaskMsUtil.renderTransaction(backCtx, controllerParams);
        String masterFillCode = OscarTaskMsUtil.renderFillCode(backCtx, mainDataModelDto, oscarMsDataModelDTO);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (OscarRelationshipDTO oscarRelationshipDTO : relationshipDtoList) {
                List<OscarRelationshipFieldDTO> oscarRelationshipFieldDTOS;
                String slaveTableId = oscarRelationshipDTO.getSlaveTableId();
                String relateModelType = oscarRelationshipDTO.getRelateModelType();
                OscarDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = OscarTaskMsUtil.renderFillCode(backCtx, slaveModelDto, oscarMsDataModelDTO);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                if (slaveFillCode != null) {
                    oscarRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(oscarRelationshipFieldDTOS = oscarRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
            controllerParams.put("slaveFillCodeList", slaveFillCodeList);
        }
    }

    private static void renderTransaction(OscarBackCtx<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> backCtx, Map<String, Object> controllerParams) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(OscarBackCtx<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> backCtx, OscarDataModelBaseDTO dataModelBaseDTO, OscarMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (OscarDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/oscar/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<OscarRelationshipDTO> relationshipDtoList, OscarDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (OscarRelationshipDTO relationtMap : relationshipDtoList) {
            List<OscarRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            OscarRelationshipFieldDTO oscarRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(oscarRelationshipFieldDTO.getSlaveFieldCap()).append(",idList));\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(oscarRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                OscarRelationshipFieldDTO oscarRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(oscarRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(oscarRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(oscarRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(OscarTaskMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(oscarRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(oscarRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(OscarTaskMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(oscarRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static void transferControllerCode(OscarDataModelBaseDTO fromDataModelBaseDTO, OscarDataModelBaseDTO toDataModelBaseDTO) {
        ControllerGenerateInfo businessController = fromDataModelBaseDTO.getControllerGenerateInfo();
        ControllerGenerateInfo taskController = toDataModelBaseDTO.getControllerGenerateInfo();
        if (HussarUtils.isEmpty((Object)taskController)) {
            taskController = new ControllerGenerateInfo();
            toDataModelBaseDTO.setControllerGenerateInfo(taskController);
        }
        if (HussarUtils.isNotEmpty((Object)businessController)) {
            if (HussarUtils.isNotEmpty(businessController.getImports())) {
                if (HussarUtils.isEmpty(taskController.getImports())) {
                    taskController.setImports(new HashSet<String>());
                }
                taskController.getImports().addAll(businessController.getImports());
            }
            if (HussarUtils.isNotEmpty(businessController.getInversions())) {
                if (HussarUtils.isEmpty(taskController.getInversions())) {
                    taskController.setInversions(new HashSet<String>());
                }
                taskController.getInversions().addAll(businessController.getInversions());
            }
            if (HussarUtils.isNotEmpty(businessController.getInversionsWithName())) {
                if (HussarUtils.isEmpty(taskController.getInversionsWithName())) {
                    taskController.setInversionsWithName(new HashMap<String, String>());
                }
                taskController.getInversionsWithName().putAll(businessController.getInversionsWithName());
            }
            if (HussarUtils.isNotEmpty(businessController.getCodes())) {
                if (HussarUtils.isEmpty(taskController.getCodes())) {
                    taskController.setCodes(new ArrayList<String>());
                }
                taskController.getCodes().addAll(businessController.getCodes());
            }
        }
        if (HussarUtils.isNotEmpty(fromDataModelBaseDTO.getApis())) {
            if (HussarUtils.isEmpty(toDataModelBaseDTO.getApis())) {
                toDataModelBaseDTO.setApis(new ArrayList<String>());
            }
            toDataModelBaseDTO.getApis().addAll(fromDataModelBaseDTO.getApis());
        }
    }
}

