/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.masterslave.extension;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARMASTER_SLAVEextensionSlaveQueryPlus")
public class OscarMsExtensionSlaveQueryPlusVisitor
implements OscarOperationVisitor<OscarMsDataModel, OscarMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsExtensionSlaveQueryPlusVisitor.class);
    public static final String OPERATION_NAME = "OSCARMASTER_SLAVEextensionSlaveQueryPlus";

    @Override
    public void visit(OscarBackCtx<OscarMsDataModel, OscarMsDataModelDTO> backCtx, OscarDataModelOperation operation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        OscarMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        OscarMsDataModelDTO oscarMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", oscarMsDataModelDTO);
        controllerParams.put("operationName", controllerParams.get("name"));
        List<OscarDataModelBase> extendSlaveTables = OscarMsExtensionSlaveQueryPlusVisitor.getSlaveArrayTables(oscarMsDataModelDTO, dataModelBase);
        if (extendSlaveTables.isEmpty()) {
            return;
        }
        controllerParams.put("extendSlaveTable", extendSlaveTables);
        HashMap<String, String> slaveTableValueNames = new HashMap<String, String>();
        for (OscarDataModelBase slaveTable : extendSlaveTables) {
            String slaveTableValueName = NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)slaveTable.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
            slaveTableValueNames.put(slaveTable.getId(), slaveTableValueName);
        }
        controllerParams.put("slaveTableValueNames", slaveTableValueNames);
        String serviceImplPath = "template/oscar/masterslavebackcode/extension/slaveQueryPlus/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplInversion(modelId, oscarMsDataModelDTO.getMapperName());
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static List<OscarDataModelBase> getSlaveArrayTables(OscarMsDataModelDTO dataModelBaseDTO, OscarMsDataModel dataModelBase) {
        CopyOnWriteArrayList<OscarDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<OscarDataModelBase>(dataModelBase.getSlaveTables());
        block0: for (OscarDataModelBase slaveArrayTable : slaveArrayTables) {
            if (!slaveArrayTable.isExtension()) {
                slaveArrayTables.remove(slaveArrayTable);
                continue;
            }
            for (OscarRelationshipDTO relationshipDTO : dataModelBaseDTO.getRelationshipDtoList()) {
                if (!"association".equals(relationshipDTO.getRelateModelType()) || !slaveArrayTable.getId().equals(relationshipDTO.getSlaveTableId())) continue;
                slaveArrayTables.remove(slaveArrayTable);
                continue block0;
            }
        }
        for (OscarDataModelBase slaveArrayTable : slaveArrayTables) {
            boolean flag = false;
            for (OscarDataModelOperation operation : dataModelBase.getOperations()) {
                if (!slaveArrayTable.getId().equals(operation.getParams().get("slaveModelId")) || !operation.getType().equals("SlaveQuery")) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            slaveArrayTables.remove(slaveArrayTable);
        }
        return slaveArrayTables;
    }
}

