/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.masterslave.OscarMsAsyncVerifyVisitor;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.SqlReturnUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARMASTER_SLAVEUniqueVerify")
public class OscarMsUniqueVerifyVisitor
implements OscarOperationVisitor<OscarMsDataModel, OscarMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsAsyncVerifyVisitor.class);
    public static final String OPERATION_NAME = "OSCARMASTER_SLAVEUniqueVerify";

    @Override
    public void visit(OscarBackCtx<OscarMsDataModel, OscarMsDataModelDTO> backCtx, OscarDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        OscarMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = backCtx.getUseDataModelBase().getId();
        OscarMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        HashMap<String, Object> controllerParams = new HashMap<String, Object>();
        controllerParams.put("getPrimaryMethod", String.format("%s%s", "get", dataModelBaseDTO.getPrimaryKeyFirstToUpper()));
        controllerParams.put("name", dataModelOperation.getName());
        if (ToolUtil.isNotEmpty((Object)dataModelOperation.getExegesis())) {
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        } else {
            controllerParams.put("exegesis", dataModelBaseDTO.getComment() + "\u552f\u4e00\u6027\u6821\u9a8c");
        }
        controllerParams.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        controllerParams.put("entityName", dataModelBaseDTO.getEntityName());
        controllerParams.put("mapperEnName", dataModelBaseDTO.getMapperEnName());
        controllerParams.put("table", dataModelBaseDTO);
        for (OscarDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (!"primary".equals(field.getFill())) continue;
            String dataType = field.getColumnType().getType();
            controllerParams.put("primaryKeyType", dataType);
            break;
        }
        List<OscarDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        boolean isLogicallyDelete = useDataModelBase.isLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (isLogicallyDelete) {
            OscarDataModelField logicallyField = useDataModelBase.getDeleteFlag();
            for (OscarDataModelFieldDto field : fields) {
                if (!field.getId().equals(logicallyField.getId())) continue;
                OscarDataModelField deleteField = useDataModelBase.getDeleteFlag();
                String logicallyFlag = useDataModelBase.getModelAliasName().get(useDataModelBase.getMasterTable().getId()) + "." + deleteField.getSourceFieldName();
                controllerParams.put("logicallyFlag", logicallyFlag);
                break;
            }
        }
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), dataModelBaseDTO);
        String controllerPath = "template/oscar/masterslavebackcode/uniqueverify/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/oscar/masterslavebackcode/uniqueverify/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/oscar/masterslavebackcode/uniqueverify/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        String finalReturn = SqlReturnUtil.renderReturn(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), dataModelOperation.getName());
        controllerParams.put("return", finalReturn);
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/oscar/masterslavebackcode/uniqueverify/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/oscar/masterslavebackcode/uniqueverify/xml.ftl";
        String finalRelation = SqlReturnUtil.renderRelation(backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName(), "\u552f\u4e00\u6027\u6821\u9a8c");
        backCtx.addApi(modelId, OscarBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(OscarBackCtx<OscarMsDataModel, OscarMsDataModelDTO> backCtx, String modelId, OscarMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.backVerify.BackVerifyVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "java.util.List");
    }
}

