/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.util;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.SqlTransUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipBase;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SqlReturnUtil {
    protected static final int DEF_SB_SIZE = 128;

    public static String renderReturn(OscarMsDataModel dataModel, Map<String, String> aliasMap) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        List<OscarDataModelField> dataModelFieldBases = dataModel.getFields();
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static String renderReturn(OscarMsDataModel dataModel, Map<String, String> aliasMap, String methodName) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        StringBuilder extendSelectFields = new StringBuilder(128);
        extendSelectFields.append("<!-- begin ExtendSQLFields:" + methodName + " #\u6269\u5c55\u5b57\u6bb5sql -->\n");
        boolean hasExtendFields = false;
        List<OscarDataModelField> dataModelFieldBases = dataModel.getFields();
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            if (dataModelFieldBase.isExtend()) {
                hasExtendFields = true;
                extendSelectFields.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
                continue;
            }
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (hasExtendFields) {
            extendSelectFields = new StringBuilder(extendSelectFields.substring(0, extendSelectFields.length() - 2));
            extendSelectFields.append("\n");
            extendSelectFields.append("<!-- end ExtendSQLFields:" + methodName + " -->");
            return finalReturn.append((CharSequence)extendSelectFields).toString();
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static String renderReturnNew(OscarDataModelBase dataModel, Map<String, String> aliasMap, String methodName) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        StringBuilder extendSelectFields = new StringBuilder(128);
        extendSelectFields.append("<!-- begin ExtendSQLFields:" + methodName + " #\u6269\u5c55\u5b57\u6bb5sql -->\n");
        boolean hasExtendFields = false;
        List<OscarDataModelField> dataModelFieldBases = dataModel.getFields();
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId)) || "task".equals(aliasMap.get(showModelId))) continue;
            if (dataModelFieldBase.isExtend()) {
                hasExtendFields = true;
                extendSelectFields.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
                continue;
            }
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (hasExtendFields) {
            extendSelectFields = new StringBuilder(extendSelectFields.substring(0, extendSelectFields.length() - 2));
            extendSelectFields.append("\n");
            extendSelectFields.append("<!-- end ExtendSQLFields:" + methodName + " -->");
            return finalReturn.append((CharSequence)extendSelectFields).toString();
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static String renderReturn(List<OscarDataModelField> dataModelFieldBases, Map<String, String> aliasMap, String methodName) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        StringBuilder extendSelectFields = new StringBuilder(128);
        extendSelectFields.append("<!-- begin ExtendSQLFields:" + methodName + " #\u6269\u5c55\u5b57\u6bb5sql -->\n");
        boolean hasExtendFields = false;
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            if (dataModelFieldBase.isExtend()) {
                hasExtendFields = true;
                extendSelectFields.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
                continue;
            }
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (hasExtendFields) {
            extendSelectFields = new StringBuilder(extendSelectFields.substring(0, extendSelectFields.length() - 2));
            extendSelectFields.append("\n");
            extendSelectFields.append("<!-- end ExtendSQLFields:" + methodName + " -->");
            return finalReturn.append((CharSequence)extendSelectFields).toString();
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static String renderReturn(OscarTaskDataModel dataModel, Map<String, String> aliasMap) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        List<OscarDataModelField> dataModelFieldBases = dataModel.getFields();
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static String renderReturn(OscarTaskDataModel dataModel, Map<String, String> aliasMap, String methodName) {
        String template = "${alias}.${attrReal} AS ${alias}${attrName},\n";
        StringBuilder finalReturn = new StringBuilder(128);
        StringBuilder extendSelectFields = new StringBuilder(128);
        extendSelectFields.append("<!-- begin ExtendSQLFields:" + methodName + " #\u6269\u5c55\u5b57\u6bb5sql -->\n");
        boolean hasExtendFields = false;
        List<OscarDataModelField> dataModelFieldBases = dataModel.getFields();
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            if (dataModelFieldBase.isExtend()) {
                hasExtendFields = true;
                extendSelectFields.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
                continue;
            }
            finalReturn.append(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField).replace("${attrName}", dataModelFieldBase.getAttrName()));
        }
        if (hasExtendFields) {
            extendSelectFields = new StringBuilder(extendSelectFields.substring(0, extendSelectFields.length() - 2));
            extendSelectFields.append("\n");
            extendSelectFields.append("<!-- end ExtendSQLFields:" + methodName + " -->");
            return finalReturn.append((CharSequence)extendSelectFields).toString();
        }
        if (finalReturn.length() > 0) {
            return finalReturn.substring(0, finalReturn.length() - 2);
        }
        return finalReturn.toString();
    }

    public static void renderAlias(OscarMsDataModel dataModel, Map<String, String> aliasMap, OscarDataModelBaseDTO dataModelBaseDTO) {
        String template = "${alias}.${attrReal}";
        List<OscarDataModelField> dataModelFieldBases = dataModel.getFields();
        List<OscarDataModelFieldDto> dataModelFieldDtos = dataModelBaseDTO.getFields();
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            for (OscarDataModelFieldDto dataModelFieldDto : dataModelFieldDtos) {
                if (dataModelFieldDto.getName() == null || !dataModelFieldDto.getId().equals(dataModelFieldBase.getId())) continue;
                dataModelFieldDto.setAliasName(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField));
            }
        }
    }

    public static void renderAlias(OscarTaskDataModel dataModel, Map<String, String> aliasMap, OscarTaskDataModelDTO dataModelBaseDTO) {
        String template = "${alias}.${attrReal}";
        List<OscarDataModelField> dataModelFieldBases = dataModel.getFields();
        List<OscarDataModelFieldDto> dataModelFieldDtos = dataModelBaseDTO.getFields();
        for (OscarDataModelField dataModelFieldBase : dataModelFieldBases) {
            String showModelId = dataModelFieldBase.getSourceDataModelId();
            String originField = dataModelFieldBase.getSourceFieldName();
            String string = originField = originField != null ? originField.toUpperCase() : originField;
            if (!ToolUtil.isNotEmpty((Object)showModelId) || !ToolUtil.isNotEmpty((Object)originField) || !DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType()) || !ToolUtil.isNotEmpty((Object)aliasMap.get(showModelId))) continue;
            for (OscarDataModelFieldDto dataModelFieldDto : dataModelFieldDtos) {
                if (dataModelFieldDto.getName() == null || !dataModelFieldDto.getId().equals(dataModelFieldBase.getId())) continue;
                dataModelFieldDto.setAliasName(template.replace("${alias}", aliasMap.get(showModelId)).replace("${attrReal}", originField));
            }
        }
    }

    public static String renderRelation(OscarMsDataModel dataModelBase, Map<String, OscarDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<OscarRelationshipBase> relationships = dataModelBase.getRelationships();
        OscarDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        if (ToolUtil.isNotEmpty((Object)masterId)) {
            String mainModel = masterTable.getSourceDataModelName();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterId)));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (OscarRelationshipBase relationship : relationships) {
                if (!"association".equals(relationship.getRelateModelType())) continue;
                OscarDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveModelBase.getSourceDataModelName();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), dataModelBase, alias, "and", modelAlias.get(masterId), slaveModelBase);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderRelation(OscarTaskMsDataModel dataModelBase, Map<String, OscarDataModelBase> dataModelBaseMap) {
        String condition;
        String alias;
        String modelRealName;
        OscarDataModelBase slaveTable;
        OscarDataModelBase masterTable;
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<OscarRelationshipBase> relationships = dataModelBase.getRelationships();
        OscarBaseDataModel taskTable = dataModelBase.getTask();
        String taskId = taskTable.getId();
        if (ToolUtil.isNotEmpty((Object)taskId) && ToolUtil.isNotEmpty(relationships)) {
            SqlReturnUtil.renderRelationMaster(dataModelBase, dataModelBaseMap, relationResult, modelAlias, relationships, taskId, relationTemplate);
        } else {
            if (ToolUtil.isNotEmpty((Object)taskId)) {
                String mainModel = ((OscarDataModelBase)taskTable).getSourceDataModelName();
                String mainTemplate = "FROM ${mainModel} ${alias} ";
                relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(taskId)));
            }
            if (ToolUtil.isNotEmpty(relationships)) {
                for (OscarRelationshipBase relationship : relationships) {
                    if (!relationship.getMasterTableId().equals(dataModelBase.getTask().getId())) continue;
                    masterTable = dataModelBaseMap.get(relationship.getMasterTableId());
                    slaveTable = dataModelBaseMap.get(dataModelBase.getMasterTable().getId());
                    modelRealName = slaveTable.getSourceDataModelName().toUpperCase();
                    alias = modelAlias.get(slaveTable.getId());
                    condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(taskId), slaveTable);
                    relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                    if (!ToolUtil.isNotEmpty((Object)condition)) break;
                    relationResult.append("ON\n").append(condition);
                    break;
                }
            }
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (OscarRelationshipBase relationship : relationships) {
                if (relationship.getMasterTableId().equals(dataModelBase.getTask().getId()) || !"association".equals(relationship.getRelateModelType())) continue;
                masterTable = dataModelBaseMap.get(relationship.getMasterTableId());
                slaveTable = dataModelBaseMap.get(relationship.getSlaveTableId());
                modelRealName = slaveTable.getSourceDataModelName().toUpperCase();
                alias = modelAlias.get(relationship.getSlaveTableId());
                condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(masterTable.getId()), slaveTable);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    private static void renderRelationMaster(OscarTaskMsDataModel dataModelBase, Map<String, OscarDataModelBase> dataModelBaseMap, StringBuilder relationResult, Map<String, String> modelAlias, List<OscarRelationshipBase> relationships, String taskId, String relationTemplate) {
        OscarDataModelBase masterTable = dataModelBaseMap.get(dataModelBase.getMasterTable().getId());
        String mainModel = masterTable.getSourceDataModelName();
        String mainTemplate = "FROM ${mainModel} ${alias} ";
        relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterTable.getId())));
        for (OscarRelationshipBase relationship : relationships) {
            if (!relationship.getMasterTableId().equals(dataModelBase.getTask().getId()) || !relationship.getMasterTableId().equals(dataModelBase.getTask().getId())) continue;
            OscarDataModelBase masterTableTask = dataModelBaseMap.get(relationship.getMasterTableId());
            OscarDataModelBase slaveTable = dataModelBaseMap.get(dataModelBase.getMasterTable().getId());
            String modelRealName = masterTableTask.getSourceDataModelName().toUpperCase();
            String alias = modelAlias.get(masterTableTask.getId());
            String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTableTask, modelAlias.get(slaveTable.getId()), "and", modelAlias.get(taskId), slaveTable);
            relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
            if (!ToolUtil.isNotEmpty((Object)condition)) break;
            relationResult.append("ON\n").append(condition);
            break;
        }
    }

    public static String renderRelationNew(OscarTaskMsDataModel dataModelBase, Map<String, OscarDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        String mainModel = dataModelBase.getMasterTable().getSourceDataModelName();
        String mainTemplate = "FROM ${mainModel} ${alias} ";
        relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(dataModelBase.getMasterTable().getId())));
        List<OscarRelationshipBase> relationships = dataModelBase.getRelationships();
        if (ToolUtil.isNotEmpty(relationships)) {
            for (OscarRelationshipBase relationship : relationships) {
                if (relationship.getMasterTableId().equals(dataModelBase.getTask().getId()) || !"association".equals(relationship.getRelateModelType())) continue;
                OscarDataModelBase masterTable = dataModelBaseMap.get(relationship.getMasterTableId());
                OscarDataModelBase slaveTable = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveTable.getSourceDataModelName().toUpperCase();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(masterTable.getId()), slaveTable);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderRelation(OscarTaskDataModel dataModelBase, Map<String, OscarDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<OscarRelationshipBase> relationships = dataModelBase.getRelationships();
        OscarBaseDataModel masterTable = dataModelBase.getTask();
        String masterId = masterTable.getId();
        if (ToolUtil.isNotEmpty((Object)masterId)) {
            String mainModel = ((OscarDataModelBase)masterTable).getSourceDataModelName();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterId)));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (OscarRelationshipBase relationship : relationships) {
                if (!"association".equals(relationship.getRelateModelType())) continue;
                OscarDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveModelBase.getSourceDataModelName();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(masterId), slaveModelBase);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderFlowTotalsRelation(OscarTaskDataModel dataModelBase, Map<String, OscarDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nINNER JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        String mainTemplate = "FROM ${mainModel} ${alias} ";
        relationResult.append(mainTemplate.replace("${mainModel}", "BPM_PROCINST_LIST_VIEW").replace("${alias}", "BPLV"));
        relationResult.append(relationTemplate.replace("${RE_MODEL}", dataModelBase.getSourceDataModelName()).replace("${ALIAS}", modelAlias.get(dataModelBase.getId())));
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        relationResult.append("ON\n").append(conditionTemplate.replace("${CONNECT}", "").replace("${FIELD}", "businessKey").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getId())).replace("${RE_FIELD}", dataModelBase.getPrimaryKey().getSourceFieldName()).replace("${RE}", "BPLV"));
        relationResult.append(relationTemplate.replace("${RE_MODEL}", dataModelBase.getTask().getSourceDataModelName()).replace("${ALIAS}", modelAlias.get(dataModelBase.getTask().getId())));
        relationResult.append("ON\n").append(conditionTemplate.replace("${CONNECT}", "").replace("${FIELD}", "taskId").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getTask().getId())).replace("${RE_FIELD}", "TASK_ID").replace("${RE}", "BPLV")).append(conditionTemplate.replace("${CONNECT}", "AND").replace("${FIELD}", "userId").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getTask().getId())).replace("${RE_FIELD}", "ASSIGNEE").replace("${RE}", "BPLV"));
        return relationResult.toString();
    }

    public static String renderFlowTotalsRelation(OscarTaskMsDataModel dataModelBase, Map<String, OscarDataModelBase> dataModelBaseMap) {
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nINNER JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<OscarRelationshipBase> relationships = dataModelBase.getRelationships();
        String mainTemplate = "FROM ${mainModel} ${alias} ";
        relationResult.append(mainTemplate.replace("${mainModel}", "BPM_PROCINST_LIST_VIEW").replace("${alias}", "BPLV"));
        relationResult.append(relationTemplate.replace("${RE_MODEL}", dataModelBase.getMasterTable().getSourceDataModelName()).replace("${ALIAS}", modelAlias.get(dataModelBase.getMasterTable().getId())));
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        relationResult.append("ON\n").append(conditionTemplate.replace("${CONNECT}", "").replace("${FIELD}", "businessKey").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getMasterTable().getId())).replace("${RE_FIELD}", dataModelBase.getPrimaryKey().getSourceFieldName()).replace("${RE}", "BPLV"));
        relationResult.append(relationTemplate.replace("${RE_MODEL}", dataModelBase.getTask().getSourceDataModelName()).replace("${ALIAS}", modelAlias.get(dataModelBase.getTask().getId())));
        relationResult.append("ON\n").append(conditionTemplate.replace("${CONNECT}", "").replace("${FIELD}", "taskId").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getTask().getId())).replace("${RE_FIELD}", "TASK_ID").replace("${RE}", "BPLV")).append(conditionTemplate.replace("${CONNECT}", "AND").replace("${FIELD}", "userId").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)"=")).replace("${T_RE}", modelAlias.get(dataModelBase.getTask().getId())).replace("${RE_FIELD}", "ASSIGNEE").replace("${RE}", "BPLV"));
        if (ToolUtil.isNotEmpty(relationships)) {
            for (OscarRelationshipBase relationship : relationships) {
                if (relationship.getMasterTableId().equals(dataModelBase.getTask().getId()) || !"association".equals(relationship.getRelateModelType())) continue;
                OscarDataModelBase masterTable = dataModelBaseMap.get(relationship.getMasterTableId());
                OscarDataModelBase slaveTable = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveTable.getSourceDataModelName().toUpperCase();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), masterTable, alias, "and", modelAlias.get(masterTable.getId()), slaveTable);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        return relationResult.toString();
    }

    public static String renderTotalCalculateRelation(OscarMsDataModel dataModelBase, Map<String, OscarDataModelBase> dataModelBaseMap, Map<String, Object> controllerParams) {
        boolean isPaired = false;
        StringBuilder relationResult = new StringBuilder(128);
        String relationTemplate = "\nLEFT JOIN ${RE_MODEL} ${ALIAS} \n";
        Map<String, String> modelAlias = dataModelBase.getModelAliasName();
        List<OscarRelationshipBase> relationships = dataModelBase.getRelationships();
        OscarDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        if (ToolUtil.isNotEmpty((Object)masterId)) {
            String mainModel = masterTable.getSourceDataModelName().toUpperCase();
            String mainTemplate = "FROM ${mainModel} ${alias} ";
            relationResult.append(mainTemplate.replace("${mainModel}", mainModel).replace("${alias}", modelAlias.get(masterId)));
            controllerParams.put("Alias", modelAlias.get(masterId));
        }
        if (ToolUtil.isNotEmpty(relationships)) {
            for (OscarRelationshipBase relationship : relationships) {
                if (!"association".equals(relationship.getRelateModelType())) continue;
                OscarDataModelBase slaveModelBase = dataModelBaseMap.get(relationship.getSlaveTableId());
                String modelRealName = slaveModelBase.getSourceDataModelName();
                String alias = modelAlias.get(relationship.getSlaveTableId());
                String condition = SqlReturnUtil.renderRelationCondition(relationship.getRelationships(), dataModelBase, alias, "and", modelAlias.get(masterId), slaveModelBase);
                relationResult.append(relationTemplate.replace("${RE_MODEL}", modelRealName).replace("${ALIAS}", alias));
                if (!ToolUtil.isNotEmpty((Object)condition)) continue;
                relationResult.append("ON\n").append(condition);
            }
        }
        controllerParams.put("isPaired", isPaired);
        return relationResult.toString();
    }

    private static String renderRelationCondition(List<OscarRelationshipFieldBase> relationshipFieldBases, OscarMsDataModel dataModelBase, String alias, String lastConnect, String mainAlias, OscarDataModelBase slaveModelBase) {
        StringBuilder finalCondition = new StringBuilder(128);
        String slaveModelBaseId = slaveModelBase.getId();
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        for (int i = 0; i < relationshipFieldBases.size(); ++i) {
            OscarRelationshipFieldBase relationshipFieldBase = relationshipFieldBases.get(i);
            String connect = lastConnect;
            if (i == 0) {
                connect = "";
            }
            OscarDataModelBase masterTable = dataModelBase.getMasterTable();
            OscarDataModelBase slaveTables = null;
            List<OscarDataModelBase> slaveTableList = dataModelBase.getSlaveTables();
            String masterTableFieldId = relationshipFieldBase.getMasterTableFieldId();
            String mainField = null;
            String slaveTableFieldId = relationshipFieldBase.getSlaveTableFieldId();
            for (OscarDataModelBase oscarDataModelBase : slaveTableList) {
                if (!HussarUtils.equals((Object)slaveModelBaseId, (Object)oscarDataModelBase.getId())) continue;
                slaveTables = oscarDataModelBase;
                break;
            }
            String dependField = null;
            for (OscarDataModelField field : masterTable.getFields()) {
                if (!HussarUtils.equals((Object)masterTableFieldId, (Object)field.getId())) continue;
                mainField = field.getSourceFieldName();
                break;
            }
            if (slaveTables != null) {
                for (OscarDataModelField field : slaveTables.getFields()) {
                    if (!HussarUtils.equals((Object)slaveTableFieldId, (Object)field.getId())) continue;
                    dependField = field.getSourceFieldName();
                    break;
                }
            }
            String string = relationshipFieldBase.getSymbol();
            String connectSym = relationshipFieldBase.getConnect();
            finalCondition.append(conditionTemplate.replace("${CONNECT}", connect).replace("${FIELD}", StringUtils.isNotBlank((CharSequence)mainField) ? mainField : "").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)string)).replace("${T_RE}", alias).replace("${RE_FIELD}", StringUtils.isNotBlank((CharSequence)dependField) ? dependField : "").replace("${RE}", mainAlias));
            lastConnect = connectSym;
        }
        return finalCondition.toString();
    }

    private static String renderRelationCondition(List<OscarRelationshipFieldBase> relationshipFieldBases, OscarDataModelBase masterModelBase, String alias, String lastConnect, String mainAlias, OscarDataModelBase slaveModelBase) {
        StringBuilder finalCondition = new StringBuilder(128);
        String slaveModelBaseId = slaveModelBase.getId();
        String conditionTemplate = "${CONNECT} ${RE}.${FIELD} ${SYMBOL} ${T_RE}.${RE_FIELD} ";
        for (int i = 0; i < relationshipFieldBases.size(); ++i) {
            OscarRelationshipFieldBase relationshipFieldBase = relationshipFieldBases.get(i);
            String connect = lastConnect;
            if (i == 0) {
                connect = "";
            }
            String masterTableFieldId = relationshipFieldBase.getMasterTableFieldId();
            String mainField = null;
            String slaveTableFieldId = relationshipFieldBase.getSlaveTableFieldId();
            String dependField = null;
            for (OscarDataModelField field : masterModelBase.getFields()) {
                if (!HussarUtils.equals((Object)masterTableFieldId, (Object)field.getId())) continue;
                mainField = field.getSourceFieldName();
                break;
            }
            for (OscarDataModelField field : slaveModelBase.getFields()) {
                if (!HussarUtils.equals((Object)slaveTableFieldId, (Object)field.getId())) continue;
                dependField = field.getSourceFieldName();
                break;
            }
            String symbol = relationshipFieldBase.getSymbol();
            String connectSym = relationshipFieldBase.getConnect();
            finalCondition.append(conditionTemplate.replace("${CONNECT}", connect).replace("${FIELD}", StringUtils.isNotBlank((CharSequence)mainField) ? mainField : "").replace("${SYMBOL}", SqlTransUtil.transSqlSymbol((String)symbol)).replace("${T_RE}", alias).replace("${RE_FIELD}", StringUtils.isNotBlank((CharSequence)dependField) ? dependField : "").replace("${RE}", mainAlias));
            lastConnect = connectSym;
        }
        return finalCondition.toString();
    }
}

