/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.task.masterslavetask.extension;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARTASK_MASTER_SLAVEextensionQuery")
public class OscarMsTaskExtensionQueryVisitor
implements OscarOperationVisitor<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsTaskExtensionQueryVisitor.class);
    public static final String OPERATION_NAME = "OSCARTASK_MASTER_SLAVEextensionQuery";

    @Override
    public void visit(OscarBackCtx<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> taskBackCtx, OscarDataModelOperation operation) throws LcdpException, IOException, CloneNotSupportedException {
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        OscarFlowMsDataModelDTO oscarFlowMsDataModelDTO = (OscarFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        OscarFlowMsDataModel dataModelBase = (OscarFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        OscarBackCtx backCtx = new OscarBackCtx();
        backCtx.setUseDataModelBase(dataModelBase);
        HashMap<String, OscarFlowMsDataModelDTO> map = new HashMap<String, OscarFlowMsDataModelDTO>();
        map.put(modelId, oscarFlowMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", oscarFlowMsDataModelDTO);
        controllerParams.put("operationName", controllerParams.get("name"));
        List<OscarDataModelBase> extendSlaveTables = OscarMsTaskExtensionQueryVisitor.getSlaveArrayTables(oscarFlowMsDataModelDTO, dataModelBase);
        controllerParams.put("extendSlaveTable", extendSlaveTables);
        HashMap<String, String> slaveTableValueNames = new HashMap<String, String>();
        for (OscarDataModelBase oscarDataModelBase : extendSlaveTables) {
            String slaveTableValueName = NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)oscarDataModelBase.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
            slaveTableValueNames.put(oscarDataModelBase.getId(), slaveTableValueName);
        }
        controllerParams.put("slaveTableValueNames", slaveTableValueNames);
        HashMap<String, String> slaveTableForeign = new HashMap<String, String>();
        for (OscarDataModelBase slaveTable : extendSlaveTables) {
            for (OscarDataModelField field : slaveTable.getFields()) {
                if (!"foreign".equals(field.getUsage())) continue;
                slaveTableForeign.put(slaveTable.getId(), field.getName());
            }
        }
        controllerParams.put("slaveTableForeign", slaveTableForeign);
        String string = "template/oscar/masterslavebackcode/extension/slaveQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)string, controllerParams));
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static List<OscarDataModelBase> getSlaveArrayTables(OscarMsDataModelDTO dataModelBaseDTO, OscarMsDataModel dataModelBase) {
        CopyOnWriteArrayList<OscarDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<OscarDataModelBase>(dataModelBase.getSlaveTables());
        block0: for (OscarDataModelBase slaveArrayTable : slaveArrayTables) {
            if (!slaveArrayTable.isExtension()) {
                slaveArrayTables.remove(slaveArrayTable);
                continue;
            }
            for (OscarRelationshipDTO relationshipDTO : dataModelBaseDTO.getRelationshipDtoList()) {
                if (!"association".equals(relationshipDTO.getRelateModelType()) || !slaveArrayTable.getId().equals(relationshipDTO.getSlaveTableId())) continue;
                slaveArrayTables.remove(slaveArrayTable);
                continue block0;
            }
        }
        return slaveArrayTables;
    }
}

