/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.oscar.function.visitor.task.masterslavetask;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.oscar.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.oscar.ctx.OscarBackCtx;
import com.jxdinfo.hussar.formdesign.oscar.function.OscarOperationVisitor;
import com.jxdinfo.hussar.formdesign.oscar.function.element.base.OscarBaseDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.flow.OscarFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.OscarMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.masterslave.relationship.OscarRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.oscar.function.element.task.OscarTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBase;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.OscarQueryDTO;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelField;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.field.OscarDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.oscar.function.modelentity.operation.OscarDataModelOperation;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.constant.OscarConstUtil;
import com.jxdinfo.hussar.formdesign.oscar.function.visitor.masterslave.util.OscarMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.OscarBackRenderUtil;
import com.jxdinfo.hussar.formdesign.oscar.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="OSCARTASK_MASTER_SLAVEDataImport")
public class OscarMsTaskDataImportVisitor
implements OscarOperationVisitor<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(OscarMsTaskDataImportVisitor.class);
    public static final String OPERATION_NAME = "OSCARTASK_MASTER_SLAVEDataImport";

    @Override
    public void visit(OscarBackCtx<OscarTaskMsDataModel, OscarTaskMsDataModelDTO> taskBackCtx, OscarDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        OscarFlowMsDataModelDTO flowMsDataModelDTO = (OscarFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        OscarFlowMsDataModel flowMsDataModel = (OscarFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx = new OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO>();
        backCtx.setUseDataModelBase(flowMsDataModel);
        HashMap<String, OscarFlowMsDataModelDTO> map = new HashMap<String, OscarFlowMsDataModelDTO>();
        map.put(modelId, flowMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, flowMsDataModelDTO);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        for (OscarDataModelBase oscarDataModelBase : flowMsDataModel.getSlaveTables()) {
            OscarDataModelBaseDTO oscarDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(oscarDataModelBase.getId());
            String slaveModelName = oscarDataModelBase.getName();
            for (OscarDataModelFieldDto oscarDataModelFieldDto : oscarDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(oscarDataModelFieldDto.getFill())) continue;
                relationTagKeys.put(slaveModelName, oscarDataModelFieldDto.getCapitalName());
            }
        }
        if (HussarUtils.isNotEmpty(relationTagKeys)) {
            controllerParams.put("relationTagKeys", relationTagKeys);
        }
        HashMap<String, Boolean> slaveTablePlusSave = new HashMap<String, Boolean>();
        for (OscarRelationshipDTO relationshipDTO : flowMsDataModelDTO.getRelationshipDtoList()) {
            if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
            slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
        }
        for (OscarDataModelBase modelBase : flowMsDataModel.getSlaveTables()) {
            isLogicallyDelete.put(modelBase.getId(), ((OscarBaseDataModel)modelBase).getLogicallyDelete());
            OscarDataModelBaseDTO oscarDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
            String slaveModelName = modelBase.getName();
            capitalNameList.put(slaveModelName, OscarMasterSlaveUtil.getCapitalName(slaveModelName));
            for (OscarDataModelField oscarDataModelField : modelBase.getFields()) {
                if (!"delDefFlag".equals(oscarDataModelField.getUsage())) continue;
                logicallyDelField.put(slaveModelName, oscarDataModelField.getName());
            }
            for (OscarDataModelFieldDto oscarDataModelFieldDto : oscarDataModelBaseDTO.getFields()) {
                if ("primary".equals(oscarDataModelFieldDto.getFill())) {
                    primaryKeys.put(slaveModelName, oscarDataModelFieldDto.getCapitalName());
                }
                if (!"foreign".equals(oscarDataModelFieldDto.getFill())) continue;
                foreignKeys.put(slaveModelName, oscarDataModelFieldDto.getCapitalName());
            }
        }
        this.addFormPlusSaveDto(flowMsDataModel, flowMsDataModelDTO, backCtx, slaveTablePlusSave);
        controllerParams.put("table", flowMsDataModelDTO);
        controllerParams.put("returnValue", flowMsDataModelDTO.getEntityName());
        OscarDataModelBaseDTO oscarDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(flowMsDataModel.getMasterTable().getId());
        controllerParams.put("masterTable", oscarDataModelBaseDTO);
        String controllerPath = "template/oscar/taskbackcode/masterslavetaskbackcode/templateImport/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, flowMsDataModelDTO.getServiceName());
        String servicePath = "template/oscar/taskbackcode/masterslavetaskbackcode/templateImport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        this.masterSlaveCode(backCtx, controllerParams);
        OscarDataModelFieldDto keyField = flowMsDataModelDTO.getKeyField();
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        String string = "template/oscar/taskbackcode/masterslavetaskbackcode/templateImport/service_impl.ftl";
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        controllerParams.put("primaryKeys", primaryKeys);
        controllerParams.put("foreignKeys", foreignKeys);
        controllerParams.put("slaveTable", OscarMasterSlaveUtil.ofSlaveParam(flowMsDataModel, flowMsDataModelDTO));
        controllerParams.put("isLogicallyDelete", isLogicallyDelete);
        controllerParams.put("logicallyDelField", logicallyDelField);
        controllerParams.put("capitalNameList", capitalNameList);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)string, controllerParams));
        this.renderImport(backCtx, modelId, flowMsDataModelDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", flowMsDataModelDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName(), "\u6a21\u677f\u6253\u5370");
        backCtx.addApi(modelId, OscarBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, String modelId, OscarFlowMsDataModelDTO flowMsDataModelDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, flowMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, flowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.template.print.utils.VerifyExcelUtil");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.model.SysExcelTask");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.constants.TaskConstants");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.service.ISysExcelTaskService");
        backCtx.addServiceImplImport(modelId, "java.time.LocalDateTime");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplInversion(modelId, "ISysExcelTaskService");
        backCtx.addServiceImplInversion(modelId, "HussarThreadPoolConfiguration");
        backCtx.addServiceImplImport(modelId, "java.io.IOException");
        backCtx.addServiceImplImport(modelId, "java.io.InputStream");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.SecurityUser");
        backCtx.addServiceImplImport(modelId, "java.util.concurrent.Executor");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration");
    }

    private Map<String, Object> initParams(OscarDataModelOperation dataModelOperation, OscarMsDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix(new String[0]) + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6a21\u677f\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void masterSlaveCode(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        OscarFlowMsDataModel flowMsDataModel = backCtx.getUseDataModelBase();
        String modelId = flowMsDataModel.getId();
        OscarFlowMsDataModelDTO flowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<OscarRelationshipDTO> relationshipDtoList = flowMsDataModelDTO.getRelationshipDtoList();
        OscarDataModelBase masterTable = flowMsDataModel.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, OscarDataModelBaseDTO> dataModelDtoMap = flowMsDataModelDTO.getDataModelDtoMap();
        OscarDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(backCtx, mainDataModelDto, flowMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)flowMsDataModel) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (OscarRelationshipDTO oscarRelationshipDTO : relationshipDtoList) {
                List<OscarRelationshipFieldDTO> oscarRelationshipFieldDTOS;
                String slaveTableId = oscarRelationshipDTO.getSlaveTableId();
                String relateModelType = oscarRelationshipDTO.getRelateModelType();
                OscarDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(backCtx, slaveModelDto, flowMsDataModelDTO, false, mainDataModelDto);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                controllerParams.put("slaveFillCodeList", slaveFillCodeList);
                if (slaveFillCode != null) {
                    oscarRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(oscarRelationshipFieldDTOS = oscarRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private String renderFillCode(OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, OscarDataModelBaseDTO dataModelBaseDTO, OscarFlowMsDataModelDTO msDataModelDTO, boolean isMs, OscarDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (OscarDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", OscarConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", OscarConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", OscarConstUtil.TRUE);
                    break;
                }
                case "primary": {
                    insertFill = true;
                    params.put("insertFill", OscarConstUtil.TRUE);
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.support.engine.core.util.EngineUtil");
                    params.put("primaryFill", OscarConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/oscar/masterslavebackcode/templateImport/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private void addFormPlusSaveDto(OscarFlowMsDataModel flowMsDataModel, OscarFlowMsDataModelDTO flowMsDataModelDTO, OscarBackCtx<OscarFlowMsDataModel, OscarFlowMsDataModelDTO> backCtx, Map<String, Boolean> slaveTablePlusSave) {
        OscarQueryDTO queryDTO = new OscarQueryDTO();
        String modelId = flowMsDataModel.getId();
        String masterId = flowMsDataModel.getMasterTable().getId();
        queryDTO.setFtlPath("template/oscar/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", flowMsDataModelDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", OscarMasterSlaveUtil.ofSlaveParam(flowMsDataModel, flowMsDataModelDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("queryDto", queryDTO);
        params.put("table", flowMsDataModelDTO);
        queryDTO.setParams(params);
        queryDTO.setName(flowMsDataModelDTO.getName() + "IncrementDTO");
        queryDTO.setEntityName(flowMsDataModelDTO.getEntityName() + "IncrementDTO");
        queryDTO.setPackageInfo(flowMsDataModelDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(flowMsDataModelDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importDTOPath = flowMsDataModelDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        flowMsDataModelDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }
}

